/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.IDefinitionPriority;
import org.apache.royale.compiler.common.Multiname;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.PackageDefinition;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.ASScopeBase;
import org.apache.royale.compiler.internal.scopes.IMutableDefinitionSet;
import org.apache.royale.compiler.internal.scopes.PackageScope;
import org.apache.royale.compiler.internal.scopes.SWCFileScopeProvider;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.scopes.IFileScope;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.units.requests.IRequest;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class ASProjectScope
extends ASScopeBase {
    private final CompilerProject project;
    private final ReadWriteLock readWriteLock;
    private final Lock readLock;
    private final Lock writeLock;
    private final Lock newVectorClassLock;
    private Map<SWCFileScopeProvider.SWCFileScope, ICompilationUnit> swcFileScopeToCompilationUnitMap = new MapMaker().weakKeys().weakValues().makeMap();
    private final Map<ITypeDefinition, AppliedVectorDefinition> vectorElementTypeToVectorClassMap = new MapMaker().weakKeys().weakValues().makeMap();
    private HashMap<String, Set<IDefinition>> qnameToShadowedDefinitions;
    private Set<String> validImports;
    private final LoadingCache<ICompilationUnit, Collection<IASScope>> compilationUnitToScopeList = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ICompilationUnit, Collection<IASScope>>(){

        public Collection<IASScope> load(ICompilationUnit unit) {
            return new ConcurrentLinkedQueue<IASScope>();
        }
    });
    private static final HashSet<String> CACHED_DEFINITION_QNAMES = new HashSet();
    private ITypeDefinition objectDefinition;
    private ITypeDefinition stringDefinition;
    private ITypeDefinition arrayDefinition;
    private ITypeDefinition xmlDefinition;
    private ITypeDefinition xmllistDefinition;
    private ITypeDefinition booleanDefinition;
    private ITypeDefinition intDefinition;
    private ITypeDefinition uintDefinition;
    private ITypeDefinition numberDefinition;
    private ITypeDefinition classDefinition;
    private ITypeDefinition functionDefinition;
    private ITypeDefinition namespaceDefinition;
    private ITypeDefinition vectorDefinition;
    private IDefinition undefinedValueDefinition;

    private static void accumulateDefinitions(ICompilationUnit referencingCU, Collection<IDefinition> defs, IDefinition def) {
        boolean invisible = referencingCU != null ? referencingCU.isInvisible() : false;
        for (IDefinition d : defs) {
            if (d == def) {
                return;
            }
            if (!invisible || !d.getQualifiedName().equals(def.getQualifiedName())) continue;
            return;
        }
        defs.add(def);
    }

    private void addExternallyVisibleDefinitionsToProjectScope(ICompilationUnit cu, IASScope[] scopes) {
        if (scopes != null) {
            for (IASScope iasScope : scopes) {
                IFileScope scope = (IFileScope)iasScope;
                if (scope == null) continue;
                Collection compilationUnitScopeList = (Collection)this.compilationUnitToScopeList.getUnchecked((Object)cu);
                assert (compilationUnitScopeList != null);
                compilationUnitScopeList.add(scope);
                ArrayList<IDefinition> externallVisibleDefs = new ArrayList<IDefinition>();
                scope.collectExternallyVisibleDefinitions(externallVisibleDefs, false);
                for (IDefinition d : externallVisibleDefs) {
                    this.addDefinition(d);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllExternallyVisibleDefinitions(ArrayList<IRequest<IFileScopeRequestResult, ICompilationUnit>> scopeRequests) throws InterruptedException {
        int i;
        int size = scopeRequests.size();
        ICompilationUnit[] comps = new ICompilationUnit[size];
        IASScope[][] scopes = new IASScope[size][];
        for (i = 0; i < size; ++i) {
            IRequest<IFileScopeRequestResult, ICompilationUnit> scopeRequest = scopeRequests.get(i);
            scopes[i] = scopeRequest.get().getScopes();
            comps[i] = scopeRequest.getRequestee();
        }
        this.writeLock.lock();
        try {
            for (i = 0; i < size; ++i) {
                this.addExternallyVisibleDefinitionsToProjectScope(comps[i], scopes[i]);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ASProjectScope(CompilerProject project) {
        this.project = project;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.newVectorClassLock = new ReentrantReadWriteLock().writeLock();
        this.qnameToShadowedDefinitions = null;
        super.addDefinitionToStore(ClassDefinition.getAnyTypeClassDefinition());
        super.addDefinitionToStore(ClassDefinition.getVoidClassDefinition());
    }

    public CompilerProject getProject() {
        return this.project;
    }

    public static DefinitionPromise createDefinitionPromise(String qname, ICompilationUnit compilationUnit) {
        DefinitionPromise definitionPromise = new DefinitionPromise(qname, compilationUnit);
        return definitionPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDefinitionSet replacePromisesWithDefinitions(IDefinitionSet definitionSet) {
        IDefinitionSet returnedDefinitionSet = definitionSet;
        int n = definitionSet.getSize();
        for (int i = 0; i < n; ++i) {
            IDefinition definition = definitionSet.getDefinition(i);
            if (!(definition instanceof DefinitionPromise)) continue;
            DefinitionPromise promise = (DefinitionPromise)definition;
            this.writeLock.unlock();
            try {
                definition = promise.getActualDefinition();
            }
            finally {
                this.writeLock.lock();
            }
            if (definition == null || definitionSet.getDefinition(i) != promise) continue;
            if (definitionSet.getMaxSize() == 1) {
                returnedDefinitionSet = (DefinitionBase)definition;
            } else {
                ((IMutableDefinitionSet)definitionSet).replaceDefinition(i, definition);
            }
            if (!ASProjectScope.shouldBeCached(definition)) continue;
            this.setBuiltinDefinition(definition);
        }
        return returnedDefinitionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDefinitionSet getLocalDefinitionSetByName(String name) {
        boolean containsPromise;
        IDefinitionSet definitionSet;
        block9: {
            definitionSet = null;
            containsPromise = false;
            this.readLock.lock();
            try {
                definitionSet = super.getLocalDefinitionSetByName(name);
                if (definitionSet == null) break block9;
                int n = definitionSet.getSize();
                for (int i = 0; i < n; ++i) {
                    IDefinition definition = definitionSet.getDefinition(i);
                    if (!(definition instanceof DefinitionPromise)) continue;
                    containsPromise = true;
                    break;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        IDefinitionSet returnedDefinitionSet = definitionSet;
        if (containsPromise) {
            this.writeLock.lock();
            try {
                returnedDefinitionSet = this.replacePromisesWithDefinitions(definitionSet);
                if (returnedDefinitionSet != definitionSet) {
                    this.definitionStore.putDefinitionSetByName(name, returnedDefinitionSet);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return returnedDefinitionSet;
    }

    private static boolean referenceMatchesQName(IWorkspace workspace, IResolvedQualifiersReference reference, String qualifiedName) {
        IResolvedQualifiersReference qualifiedNameReference = ReferenceFactory.packageQualifiedReference(workspace, qualifiedName, true);
        ImmutableSet<INamespaceDefinition> referenceQualifiers = reference.getQualifiers();
        for (INamespaceDefinition qNameNS : qualifiedNameReference.getQualifiers()) {
            if (!referenceQualifiers.contains((Object)qNameNS)) continue;
            return true;
        }
        return false;
    }

    public Set<ICompilationUnit> getCompilationUnitsForReferences(Iterable<IResolvedQualifiersReference> references) {
        return this.getCompilationUnitsForReferences(references, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ICompilationUnit> getCompilationUnitsForReferences(Iterable<IResolvedQualifiersReference> references, Collection<IResolvedQualifiersReference> unresolvedReferences) {
        HashSet<ICompilationUnit> compilationUnits = new HashSet<ICompilationUnit>();
        Workspace workspace = this.project.getWorkspace();
        this.readLock.lock();
        try {
            for (IResolvedQualifiersReference reference : references) {
                String baseName = reference.getName();
                IDefinitionSet definitionSet = super.getLocalDefinitionSetByName(baseName);
                ICompilationUnit cu = null;
                if (definitionSet != null) {
                    int n = definitionSet.getSize();
                    for (int i = 0; i < n; ++i) {
                        IDefinition definition = definitionSet.getDefinition(i);
                        String definitionQualifiedName = definition.getQualifiedName();
                        if (!ASProjectScope.referenceMatchesQName(workspace, reference, definitionQualifiedName)) continue;
                        cu = this.getCompilationUnitForDefinition(definition);
                        assert (cu != null) : "All symbol table entries should have a corresponding CU!";
                        compilationUnits.add(cu);
                    }
                }
                if (cu != null || unresolvedReferences == null) continue;
                unresolvedReferences.add(reference);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return compilationUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ICompilationUnit> getCompilationUnitsByDefinitionName(String name) {
        HashSet<ICompilationUnit> compilationUnits = new HashSet<ICompilationUnit>();
        this.readLock.lock();
        try {
            IDefinitionSet definitionSet = super.getLocalDefinitionSetByName(name);
            if (definitionSet != null) {
                int n = definitionSet.getSize();
                for (int i = 0; i < n; ++i) {
                    ICompilationUnit compilationUnit;
                    IDefinition definition = definitionSet.getDefinition(i);
                    if (definition instanceof DefinitionPromise) {
                        compilationUnit = ((DefinitionPromise)definition).getCompilationUnit();
                    } else {
                        IASScope containingScope = definition.getContainingScope();
                        compilationUnit = this.getCompilationUnitForScope(containingScope);
                    }
                    assert (compilationUnit != null);
                    compilationUnits.add(compilationUnit);
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return compilationUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ICompilationUnit> getCompilationUnitsWithConflictingDefinitions(final IWorkspace workspace, Iterable<ICompilationUnit> units) {
        HashSet<ICompilationUnit> hashSet;
        HashSet<ASProjectScope> projectScopes = new HashSet<ASProjectScope>();
        try {
            HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
            for (ICompilationUnit unit : units) {
                List<String> qNames;
                if (unit.isInvisible()) {
                    result.add(unit);
                    continue;
                }
                CompilerProject project = (CompilerProject)unit.getProject();
                ASProjectScope projectScope = project.getScope();
                if (projectScopes.add(projectScope)) {
                    projectScope.readLock.lock();
                }
                try {
                    qNames = unit.getQualifiedNames();
                }
                catch (InterruptedException e) {
                    qNames = Collections.emptyList();
                }
                Set<ICompilationUnit> visibleDefinitionCompilationUnits = projectScope.getCompilationUnitsForReferences(Iterables.transform(qNames, (Function)new Function<String, IResolvedQualifiersReference>(){

                    public IResolvedQualifiersReference apply(String qname) {
                        return ReferenceFactory.packageQualifiedReference(workspace, qname);
                    }
                }));
                result.addAll(visibleDefinitionCompilationUnits);
                for (String qName : qNames) {
                    Set<IDefinition> shadowedDefinitions = projectScope.getShadowedDefinitionsByQName(qName);
                    if (shadowedDefinitions == null) continue;
                    for (IDefinition shadowedDefinition : shadowedDefinitions) {
                        ICompilationUnit shadowedCompilationUnit = projectScope.getCompilationUnitForDefinition(shadowedDefinition);
                        result.add(shadowedCompilationUnit);
                    }
                }
                result.add(unit);
            }
            hashSet = result;
        }
        catch (Throwable throwable) {
            for (ASProjectScope projectScope : projectScopes) {
                projectScope.readLock.unlock();
            }
            throw throwable;
        }
        for (ASProjectScope projectScope : projectScopes) {
            projectScope.readLock.unlock();
        }
        return hashSet;
    }

    @Override
    public Collection<IDefinitionSet> getAllLocalDefinitionSets() {
        Collection<String> names = this.getAllLocalNames();
        ArrayList<IDefinitionSet> result = new ArrayList<IDefinitionSet>(names.size());
        for (String name : names) {
            IDefinitionSet set = this.getLocalDefinitionSetByName(name);
            result.add(set);
        }
        return result;
    }

    @Override
    public Collection<IDefinition> getAllLocalDefinitions() {
        Collection<String> names = this.getAllLocalNames();
        ArrayList<IDefinition> result = new ArrayList<IDefinition>(names.size());
        for (String name : names) {
            IDefinitionSet set = this.getLocalDefinitionSetByName(name);
            int n = set.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition definition = set.getDefinition(i);
                result.add(definition);
            }
        }
        return result;
    }

    public IDefinition findDefinitionByName(String definitionName) {
        Multiname multiname = Multiname.crackDottedQName(this.project, definitionName);
        return this.findDefinitionByName(multiname, false);
    }

    public IDefinition[] findAllDefinitionsByName(Multiname multiname) {
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>(1);
        this.getLocalProperty((ICompilerProject)this.project, defs, multiname.getBaseName(), multiname.getNamespaceSet());
        return defs.toArray(new IDefinition[defs.size()]);
    }

    public IDefinition findDefinitionByName(Multiname multiname, boolean ignoreAmbiguous) {
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>(1);
        this.getLocalProperty((ICompilerProject)this.project, defs, multiname.getBaseName(), multiname.getNamespaceSet());
        if (defs.size() == 1 || ignoreAmbiguous && defs.size() > 0) {
            return defs.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefinitionBase findVisibleDefinition(IDefinition definition) {
        this.readLock.lock();
        try {
            String newDefinitionQName = definition.getQualifiedName();
            String newDefBaseName = definition.getBaseName();
            IDefinitionSet defSet = super.getLocalDefinitionSetByName(newDefBaseName);
            if (defSet != null) {
                int nDefs = defSet.getSize();
                for (int i = 0; i < nDefs; ++i) {
                    IDefinition existingDef = defSet.getDefinition(i);
                    String existingDefQName = existingDef.getQualifiedName();
                    if (!existingDefQName.equals(newDefinitionQName)) continue;
                    DefinitionBase definitionBase = (DefinitionBase)existingDef;
                    return definitionBase;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    private int compareCompilationUnits(ICompilationUnit a, ICompilationUnit b) {
        IDefinitionPriority priorityA = a.getDefinitionPriority();
        IDefinitionPriority priorityB = b.getDefinitionPriority();
        return priorityA.compareTo(priorityB);
    }

    private int compareDefinitions(IDefinition a, IDefinition b) {
        ICompilationUnit cuA = this.getCompilationUnitForDefinition(a);
        ICompilationUnit cuB = this.getCompilationUnitForDefinition(b);
        return this.compareCompilationUnits(cuA, cuB);
    }

    private boolean shadowDefinitionIfNeeded(IDefinition visibleDefinition, IDefinition newDefinition) {
        ICompilationUnit newDefinitionCU;
        ICompilationUnit visibleDefinitionCU;
        Set<IDefinition> shadowedDefinitions;
        if (visibleDefinition == null) {
            return true;
        }
        String qname = visibleDefinition.getQualifiedName();
        assert (qname.equals(newDefinition.getQualifiedName()));
        if (this.qnameToShadowedDefinitions == null) {
            this.qnameToShadowedDefinitions = new HashMap();
        }
        if ((shadowedDefinitions = this.qnameToShadowedDefinitions.get(qname)) == null) {
            shadowedDefinitions = new HashSet<IDefinition>(1);
            this.qnameToShadowedDefinitions.put(qname, shadowedDefinitions);
        }
        if (this.compareCompilationUnits(visibleDefinitionCU = this.getCompilationUnitForDefinition(visibleDefinition), newDefinitionCU = this.getCompilationUnitForDefinition(newDefinition)) >= 0) {
            shadowedDefinitions.add(newDefinition);
            return false;
        }
        List<IDefinition> promises = visibleDefinitionCU.getDefinitionPromises();
        if (!promises.isEmpty() && !(visibleDefinition instanceof DefinitionPromise)) {
            IDefinition promiseForVisibleDefinition = null;
            for (IDefinition promise : promises) {
                if (!promise.getQualifiedName().equals(qname)) continue;
                promiseForVisibleDefinition = promise;
                break;
            }
            assert (promiseForVisibleDefinition != null);
            assert (((DefinitionPromise)promiseForVisibleDefinition).getCompilationUnit() == visibleDefinitionCU);
            assert (((DefinitionPromise)promiseForVisibleDefinition).getActualDefinition() == visibleDefinition);
            shadowedDefinitions.add(promiseForVisibleDefinition);
        } else {
            shadowedDefinitions.add(visibleDefinition);
        }
        return true;
    }

    private Set<IDefinition> getShadowedDefinitionsByQName(String qName) {
        if (this.qnameToShadowedDefinitions == null) {
            return null;
        }
        Set<IDefinition> shadowedDefs = this.qnameToShadowedDefinitions.get(qName);
        if (shadowedDefs != null) {
            return shadowedDefs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IDefinition> getShadowedDefinitions(IDefinition def) {
        Set<IDefinition> shadowedDefs = null;
        if (def == null) {
            throw new NullPointerException("def may not be null");
        }
        this.readLock.lock();
        try {
            assert (this.getCompilationUnitForDefinition(def) != null) : "def must either be a definition promise or addScopeForCompilationUnit must be called before addDefinition";
            if (this.qnameToShadowedDefinitions != null) {
                String qname = def.getQualifiedName();
                shadowedDefs = this.qnameToShadowedDefinitions.get(qname);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return shadowedDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefinition(IDefinition def) {
        this.writeLock.lock();
        try {
            assert (this.getCompilationUnitForDefinition(def) != null) : "def must either be a definition promise or addScopeForCompilationUnit must be called before addDefinition";
            DefinitionBase existingDef = this.findVisibleDefinition(def);
            boolean shouldAddDef = this.shadowDefinitionIfNeeded(existingDef, def);
            if (shouldAddDef) {
                if (existingDef != null) {
                    super.removeDefinition(existingDef);
                }
                this.addDefinitionToStore(def);
            }
            assert (def instanceof DefinitionPromise || this.getCompilationUnitForScope(def.getContainingScope()) != null);
        }
        finally {
            if (!def.isGeneratedEmbedClass()) {
                this.validImports = null;
            }
            this.writeLock.unlock();
        }
    }

    @Override
    protected void addDefinitionToStore(IDefinition def) {
        super.addDefinitionToStore(def);
        if (!(def instanceof DefinitionPromise) && ASProjectScope.shouldBeCached(def)) {
            this.setBuiltinDefinition(def);
        }
        if (!def.isGeneratedEmbedClass()) {
            this.validImports = null;
        }
    }

    private void setBuiltinDefinition(IDefinition def) {
        String defName = def.getBaseName();
        if (def.getNamespaceReference() == NamespaceDefinition.getPublicNamespaceDefinition()) {
            if (defName.equals(IASLanguageConstants.BuiltinType.OBJECT.getName())) {
                this.objectDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.STRING.getName())) {
                this.stringDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.ARRAY.getName())) {
                this.arrayDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.XML.getName())) {
                this.xmlDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.XMLLIST.getName())) {
                this.xmllistDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.BOOLEAN.getName())) {
                this.booleanDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.INT.getName())) {
                this.intDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.UINT.getName())) {
                this.uintDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.NUMBER.getName())) {
                this.numberDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.CLASS.getName())) {
                this.classDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.FUNCTION.getName())) {
                this.functionDefinition = (ITypeDefinition)def;
            } else if (defName.equals(IASLanguageConstants.BuiltinType.NAMESPACE.getName())) {
                this.namespaceDefinition = (ITypeDefinition)def;
            } else if (defName.equals("undefined")) {
                this.undefinedValueDefinition = def;
            } else assert (false);
        } else if (def.getPackageName().equals("__AS3__.vec")) {
            if (defName.equals(IASLanguageConstants.BuiltinType.VECTOR.getName())) {
                this.vectorDefinition = (ITypeDefinition)def;
            } else if (defName.equals("Vector$object")) {
                this.updateAppliedVectorDefinitionBaseClasses("Vector$object");
            } else if (defName.equals("Vector$double")) {
                this.updateAppliedVectorDefinitionBaseClasses("Vector$double");
            } else if (defName.equals("Vector$int")) {
                this.updateAppliedVectorDefinitionBaseClasses("Vector$int");
            } else if (defName.equals("Vector$uint")) {
                this.updateAppliedVectorDefinitionBaseClasses("Vector$uint");
            }
        }
    }

    private void updateAppliedVectorDefinitionBaseClasses(String changedVectorImplClass) {
        for (AppliedVectorDefinition appliedVectorDefinition : this.vectorElementTypeToVectorClassMap.values()) {
            appliedVectorDefinition.updateBaseClass(changedVectorImplClass);
        }
    }

    private void removeBuiltinDefinition(IDefinition visibleDefinition) {
        if (visibleDefinition == this.objectDefinition) {
            this.objectDefinition = null;
        } else if (visibleDefinition == this.stringDefinition) {
            this.stringDefinition = null;
        } else if (visibleDefinition == this.arrayDefinition) {
            this.arrayDefinition = null;
        } else if (visibleDefinition == this.xmlDefinition) {
            this.xmlDefinition = null;
        } else if (visibleDefinition == this.xmllistDefinition) {
            this.xmllistDefinition = null;
        } else if (visibleDefinition == this.booleanDefinition) {
            this.booleanDefinition = null;
        } else if (visibleDefinition == this.intDefinition) {
            this.intDefinition = null;
        } else if (visibleDefinition == this.uintDefinition) {
            this.uintDefinition = null;
        } else if (visibleDefinition == this.numberDefinition) {
            this.numberDefinition = null;
        } else if (visibleDefinition == this.classDefinition) {
            this.classDefinition = null;
        } else if (visibleDefinition == this.functionDefinition) {
            this.functionDefinition = null;
        } else if (visibleDefinition == this.namespaceDefinition) {
            this.namespaceDefinition = null;
        } else if (visibleDefinition == this.vectorDefinition) {
            this.vectorDefinition = null;
        } else if (visibleDefinition == this.undefinedValueDefinition) {
            this.undefinedValueDefinition = null;
        } else assert (false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefinition(IDefinition definition) {
        this.writeLock.lock();
        try {
            ICompilationUnit visibleDefinitionCU;
            DefinitionBase visibleDefinition = this.findVisibleDefinition(definition);
            assert (visibleDefinition != null) : "Can't remove a definition that is not in the symbol table.";
            if (visibleDefinition == definition) {
                if (!(visibleDefinition instanceof DefinitionPromise) && ASProjectScope.shouldBeCached(visibleDefinition)) {
                    this.removeBuiltinDefinition(visibleDefinition);
                }
                super.removeDefinition(definition);
                Set<IDefinition> shadowedDefs = this.getShadowedDefinitions(definition);
                if (shadowedDefs != null) {
                    IDefinition nextDef;
                    if (shadowedDefs.size() == 1) {
                        nextDef = shadowedDefs.iterator().next();
                        this.qnameToShadowedDefinitions.remove(definition.getQualifiedName());
                    } else {
                        IDefinition[] shadowedDefsArr = shadowedDefs.toArray(new IDefinition[0]);
                        Arrays.sort(shadowedDefsArr, new Comparator<IDefinition>(){

                            @Override
                            public int compare(IDefinition d1, IDefinition d2) {
                                assert (d1 != null);
                                assert (d2 != null);
                                return 0 - ASProjectScope.this.compareDefinitions(d1, d2);
                            }
                        });
                        nextDef = shadowedDefsArr[0];
                        shadowedDefs.remove(nextDef);
                    }
                    this.addDefinitionToStore(nextDef);
                }
                return;
            }
            if (!(visibleDefinition instanceof DefinitionPromise) && definition instanceof DefinitionPromise && (visibleDefinitionCU = this.getCompilationUnitForDefinition(visibleDefinition)) == ((DefinitionPromise)definition).getCompilationUnit()) {
                assert (visibleDefinition == this.findVisibleDefinition(visibleDefinition)) : "assert if we are about to start infinite recursion";
                this.removeDefinition(visibleDefinition);
                return;
            }
            String qName = definition.getQualifiedName();
            Set<IDefinition> shadowedDefinitions = this.qnameToShadowedDefinitions.get(qName);
            assert (shadowedDefinitions != null) : "If the def to remove is shadowed, we should have a set of shadowed defs.";
            assert (shadowedDefinitions.contains(definition)) : "If the def to remove is shadowed it should be in this set.";
            if (shadowedDefinitions.size() == 1) {
                this.qnameToShadowedDefinitions.remove(qName);
            } else {
                shadowedDefinitions.remove(definition);
            }
        }
        finally {
            this.validImports = null;
            this.writeLock.unlock();
        }
    }

    @Override
    public void compact() {
        this.writeLock.lock();
        try {
            super.compact();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Collection<String> getAllLocalNames() {
        this.readLock.lock();
        try {
            Collection<String> collection = super.getAllLocalNames();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllQualifiedNames() {
        this.readLock.lock();
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (IDefinitionSet definitionSet : super.getAllLocalDefinitionSets()) {
                int nDefinitionsInSet = definitionSet.getSize();
                for (int i = 0; i < nDefinitionsInSet; ++i) {
                    result.add(definitionSet.getDefinition(i).getQualifiedName());
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addScopeForCompilationUnit(ICompilationUnit cu, ASFileScope scope) {
        if (scope.setCompilationUnit(cu)) {
            return;
        }
        this.writeLock.lock();
        try {
            assert (scope instanceof SWCFileScopeProvider.SWCFileScope) : "only SWCFileScope should be added to swcFileScopeToCompilationUnitMap";
            this.swcFileScopeToCompilationUnitMap.put((SWCFileScopeProvider.SWCFileScope)scope, cu);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeScopeForCompilationUnit(ASFileScope scope) {
        if (scope.setCompilationUnit(null)) {
            assert (!this.swcFileScopeToCompilationUnitMap.containsKey(scope)) : "scope should not be in the scopeToCompilationUnitMap when setCompilationUnit returns true";
            return;
        }
        assert (scope instanceof SWCFileScopeProvider.SWCFileScope) : "only SWCFileScope should be in swcFileScopeToCompilationUnitMap";
        this.swcFileScopeToCompilationUnitMap.remove(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompilationUnit getCompilationUnitForScope(IASScope scope) {
        while (scope != null && !(scope instanceof ASFileScope)) {
            scope = scope.getContainingScope();
        }
        if (scope == null) {
            return null;
        }
        ASFileScope fileScope = (ASFileScope)scope;
        ICompilationUnit compilationUnit = fileScope.getCompilationUnit();
        if (compilationUnit != null) {
            assert (compilationUnit.getProject() == this.getProject());
            return compilationUnit;
        }
        this.readLock.lock();
        try {
            assert (fileScope instanceof SWCFileScopeProvider.SWCFileScope) : "only SWCFileScope should be in swcFileScopeToCompilationUnitMap";
            ICompilationUnit swcCompilationUnit = this.swcFileScopeToCompilationUnitMap.get(fileScope);
            assert (swcCompilationUnit == null || swcCompilationUnit.getProject() == this.getProject());
            ICompilationUnit iCompilationUnit = swcCompilationUnit;
            return iCompilationUnit;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addScopeToCompilationUnitScopeList(ASScope scope) {
        if (AppliedVectorDefinition.isVectorScope(scope)) {
            return;
        }
        ICompilationUnit compilationUnit = this.getCompilationUnitForScope(scope);
        assert (compilationUnit != null);
        Collection relatedScopes = (Collection)this.compilationUnitToScopeList.getUnchecked((Object)compilationUnit);
        relatedScopes.add(scope);
    }

    public Collection<IASScope> clearCompilationUnitScopeList(ICompilationUnit compilationUnit) {
        Collection scopeList = (Collection)this.compilationUnitToScopeList.getUnchecked((Object)compilationUnit);
        this.compilationUnitToScopeList.invalidate((Object)compilationUnit);
        return scopeList;
    }

    public Collection<IASScope> getCompilationUnitScopeList(ICompilationUnit compilationUnit) {
        if (this.compilationUnitToScopeList.getIfPresent((Object)compilationUnit) == null) {
            return Collections.emptyList();
        }
        Collection result = (Collection)this.compilationUnitToScopeList.getUnchecked((Object)compilationUnit);
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public ICompilationUnit getCompilationUnitForDefinition(IDefinition def) {
        if (def == null) {
            return null;
        }
        if (def instanceof DefinitionPromise) {
            return ((DefinitionPromise)def).getCompilationUnit();
        }
        return this.getCompilationUnitForScope(def.getContainingScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompilationUnits(Collection<ICompilationUnit> compilationUnitsToRemove) {
        if (compilationUnitsToRemove == null || compilationUnitsToRemove.size() == 0) {
            return;
        }
        this.writeLock.lock();
        try {
            HashSet<IDefinition> defsToRemove = new HashSet<IDefinition>(compilationUnitsToRemove.size());
            ArrayList<IASScope> scopesToRemove = new ArrayList<IASScope>(compilationUnitsToRemove.size());
            for (ICompilationUnit compilationUnit : compilationUnitsToRemove) {
                Collection<IASScope> relatedScopes = this.getCompilationUnitScopeList(compilationUnit);
                List<IDefinition> definitionPromises = compilationUnit.getDefinitionPromises();
                if (definitionPromises.isEmpty()) {
                    ArrayList<IDefinition> relatedDefs = new ArrayList<IDefinition>();
                    for (IASScope scope : relatedScopes) {
                        if (!(scope instanceof ASFileScope)) continue;
                        ((ASFileScope)scope).collectExternallyVisibleDefinitions(relatedDefs, false);
                    }
                    defsToRemove.addAll(relatedDefs);
                } else {
                    defsToRemove.addAll(definitionPromises);
                }
                scopesToRemove.addAll(relatedScopes);
                this.project.clearScopeCacheForCompilationUnit(compilationUnit);
            }
            for (IDefinition defToRemove : defsToRemove) {
                this.removeDefinition(defToRemove);
            }
            for (IASScope scope : scopesToRemove) {
                if (!(scope instanceof ASFileScope)) continue;
                this.removeScopeForCompilationUnit((ASFileScope)scope);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public IASScope getContainingScope() {
        return null;
    }

    private AppliedVectorDefinition getExistingVectorClass(ITypeDefinition elementType) {
        this.readLock.lock();
        try {
            AppliedVectorDefinition appliedVectorDefinition = this.vectorElementTypeToVectorClassMap.get(elementType);
            return appliedVectorDefinition;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppliedVectorDefinition newVectorClass(ITypeDefinition elementType) {
        AppliedVectorDefinition existingVectorClass = this.getExistingVectorClass(elementType);
        if (existingVectorClass != null) {
            return existingVectorClass;
        }
        this.newVectorClassLock.lock();
        try {
            existingVectorClass = this.getExistingVectorClass(elementType);
            if (existingVectorClass != null) {
                AppliedVectorDefinition appliedVectorDefinition = existingVectorClass;
                return appliedVectorDefinition;
            }
            String vectorTypeName = null;
            INamespaceReference elementTypeNSRef = elementType.getNamespaceReference();
            if (elementTypeNSRef.equals(NamespaceDefinition.getPublicNamespaceDefinition()) && elementType.getPackageName().length() == 0 && elementType instanceof IClassDefinition && !(elementType instanceof AppliedVectorDefinition)) {
                String elementTypeName = elementType.getBaseName();
                if (elementTypeName.equals("int")) {
                    vectorTypeName = "Vector$int";
                } else if (elementTypeName.equals("uint")) {
                    vectorTypeName = "Vector$uint";
                } else if (elementTypeName.equals("Number")) {
                    vectorTypeName = "Vector$double";
                }
                if (vectorTypeName != null) {
                    IDefinition numberTypeClassDef = this.findDefinitionByName(elementTypeName);
                    assert (numberTypeClassDef != null) : "Unable to lookup: " + elementTypeName;
                    if (!numberTypeClassDef.equals(elementType)) {
                        vectorTypeName = null;
                    }
                }
            }
            if (vectorTypeName == null) {
                vectorTypeName = "Vector$object";
            }
            IClassDefinition vectorImplClass = AppliedVectorDefinition.lookupVectorImplClass(this.project, vectorTypeName);
            AppliedVectorDefinition result = new AppliedVectorDefinition(this.project, vectorImplClass, elementType);
            this.vectorElementTypeToVectorClassMap.put(elementType, result);
            if (vectorTypeName == "Vector$object") {
                result.adjustVectorMethods(this.project);
            }
            AppliedVectorDefinition appliedVectorDefinition = result;
            return appliedVectorDefinition;
        }
        finally {
            this.newVectorClassLock.unlock();
        }
    }

    private void getPropertyForScopeChainInvisibleCompilationUnit(ICompilationUnit referencingCU, Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet) {
        assert (referencingCU.isInvisible());
        try {
            Collection<IDefinition> externallyVisibleDefs = referencingCU.getFileScopeRequest().get().getExternallyVisibleDefinitions();
            ICompilerProject project = referencingCU.getProject();
            for (IDefinition externallyVisibleDefinition : externallyVisibleDefs) {
                if (!baseName.equals(externallyVisibleDefinition.getBaseName())) continue;
                this.accumulateMatchingDefinitions(referencingCU, project, defs, namespaceSet, true, null, externallyVisibleDefinition);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void getPropertyForScopeChain(ASScope referencingScope, Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet, DependencyType dt) {
        ICompilationUnit referencingCU = this.getCompilationUnitForScope(referencingScope);
        if (referencingCU != null && referencingCU.isInvisible()) {
            this.getPropertyForScopeChainInvisibleCompilationUnit(referencingCU, defs, baseName, namespaceSet);
        }
        if (dt != null && !AppliedVectorDefinition.isVectorScope(referencingScope)) {
            assert (referencingCU != null) : "this can only be null if the ref scope is a vector scope, which we guard against.";
            this.findDefinitionByName(referencingCU, defs, baseName, namespaceSet, dt);
        } else {
            this.getLocalProperty(referencingCU, this.project, defs, baseName, namespaceSet, true, null);
        }
    }

    public void findDefinitionByName(ICompilationUnit referencingCU, Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet, DependencyType dt) {
        this.getLocalProperty(referencingCU, this.project, defs, baseName, namespaceSet, true, null);
        if (dt != null) {
            for (IDefinition def : defs) {
                assert (def != null);
                if (def.isImplicit()) continue;
                assert (referencingCU != null);
                assert (def.getContainingScope() != null) : "null containing scope: " + def.getBaseName();
                assert (def.getContainingScope() instanceof ASFileScope || def.getContainingScope().getDefinition() instanceof PackageDefinition);
                ICompilationUnit referencedCU = this.getCompilationUnitForScope(def.getContainingScope());
                assert (referencedCU != null);
                this.project.addDependency(referencingCU, referencedCU, dt, def.getQualifiedName());
            }
        }
        if (defs.isEmpty()) {
            this.project.addUnfoundDefinitionDependency(baseName, referencingCU);
        }
    }

    public boolean isActiveDefinition(IDefinition definition) {
        DefinitionPromise defPromise;
        assert (definition != null);
        assert (definition.getContainingScope() instanceof ASFileScope || definition.getContainingScope() instanceof PackageScope);
        DefinitionBase visibleDefinition = this.findVisibleDefinition(definition);
        if (definition == visibleDefinition) {
            return true;
        }
        return visibleDefinition instanceof DefinitionPromise && definition == (defPromise = (DefinitionPromise)visibleDefinition).getActualDefinition();
    }

    public void findDefinitionByName(Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet) {
        this.getLocalProperty((ICompilerProject)this.project, defs, baseName, namespaceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidImport(String importName) {
        boolean needToBuildValidImports = false;
        this.readLock.lock();
        try {
            if (this.validImports == null) {
                needToBuildValidImports = true;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (needToBuildValidImports) {
            this.writeLock.lock();
            try {
                if (this.validImports == null) {
                    this.validImports = new HashSet<String>();
                    for (String name : this.getAllQualifiedNames()) {
                        this.validImports.add(name);
                        this.validImports.add(ImportNode.makeWildcardName(name));
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        boolean isValid = false;
        this.readLock.lock();
        try {
            isValid = this.validImports.contains(importName);
        }
        finally {
            this.readLock.unlock();
        }
        return isValid;
    }

    public void getAllProperties(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet) {
        this.getAllLocalProperties(project, defs, namespaceSet, null);
    }

    private static boolean shouldBeCached(IDefinition definition) {
        String qname = definition.getQualifiedName();
        return CACHED_DEFINITION_QNAMES.contains(qname);
    }

    public final ITypeDefinition getObjectDefinition() {
        if (this.objectDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.OBJECT.getName());
        }
        return this.objectDefinition;
    }

    public final ITypeDefinition getStringDefinition() {
        if (this.stringDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.STRING.getName());
        }
        return this.stringDefinition;
    }

    public final ITypeDefinition getArrayDefinition() {
        if (this.arrayDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.ARRAY.getName());
        }
        return this.arrayDefinition;
    }

    public final ITypeDefinition getXMLDefinition() {
        if (this.xmlDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.XML.getName());
        }
        return this.xmlDefinition;
    }

    public final ITypeDefinition getXMLListDefinition() {
        if (this.xmllistDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.XMLLIST.getName());
        }
        return this.xmllistDefinition;
    }

    public final ITypeDefinition getBooleanDefinition() {
        if (this.booleanDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.BOOLEAN.getName());
        }
        return this.booleanDefinition;
    }

    public final ITypeDefinition getIntDefinition() {
        if (this.intDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.INT.getName());
        }
        return this.intDefinition;
    }

    public final ITypeDefinition getUIntDefinition() {
        if (this.uintDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.UINT.getName());
        }
        return this.uintDefinition;
    }

    public final ITypeDefinition getNumberDefinition() {
        if (this.numberDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.NUMBER.getName());
        }
        return this.numberDefinition;
    }

    public final ITypeDefinition getClassDefinition() {
        if (this.classDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.CLASS.getName());
        }
        return this.classDefinition;
    }

    public final ITypeDefinition getFunctionDefinition() {
        if (this.functionDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.FUNCTION.getName());
        }
        return this.functionDefinition;
    }

    public final ITypeDefinition getNamespaceDefinition() {
        if (this.namespaceDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.NAMESPACE.getName());
        }
        return this.namespaceDefinition;
    }

    public final ITypeDefinition getVectorDefinition() {
        if (this.vectorDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.VECTOR.getName());
        }
        return this.vectorDefinition;
    }

    public final IDefinition getUndefinedValueDefinition() {
        if (this.undefinedValueDefinition == null) {
            this.getLocalDefinitionSetByName(IASLanguageConstants.BuiltinType.Undefined.getName());
        }
        return this.undefinedValueDefinition;
    }

    private void getLocalProperty(ICompilationUnit referencingCU, ICompilerProject project, Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet, boolean getContingents, INamespaceDefinition extraNamespace) {
        IDefinitionSet defSet = this.getLocalDefinitionSetByName(baseName);
        if (defSet != null) {
            int nDefs = defSet.getSize();
            for (int i = 0; i < nDefs; ++i) {
                IDefinition definition = defSet.getDefinition(i);
                this.accumulateMatchingDefinitions(referencingCU, project, defs, namespaceSet, getContingents, extraNamespace, definition);
            }
        }
    }

    private final void accumulateMatchingDefinitions(ICompilationUnit referencingCU, ICompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet, boolean getContingents, INamespaceDefinition extraNamespace, IDefinition definition) {
        if (!definition.isContingent() || getContingents && this.isContingentDefinitionNeeded(project, definition)) {
            if (extraNamespace != null && extraNamespace == definition.getNamespaceReference()) {
                ASProjectScope.accumulateDefinitions(referencingCU, defs, definition);
            } else if (namespaceSet == null) {
                ASProjectScope.accumulateDefinitions(referencingCU, defs, definition);
            } else {
                INamespaceDefinition ns = definition.resolveNamespace(project);
                if (extraNamespace != null && (ns == extraNamespace || extraNamespace.equals(ns))) {
                    ASProjectScope.accumulateDefinitions(referencingCU, defs, definition);
                } else if (namespaceSet.contains(ns)) {
                    ASProjectScope.accumulateDefinitions(referencingCU, defs, definition);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify() {
        this.readLock.lock();
        try {
            for (IDefinitionSet defSet : this.definitionStore.getAllDefinitionSets()) {
                int n = defSet.getSize();
                for (int i = 0; i < n; ++i) {
                    IDefinition def = defSet.getDefinition(i);
                    if (def.isImplicit() || this.getCompilationUnitForDefinition(def) != null) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    static {
        CACHED_DEFINITION_QNAMES.add("Object");
        CACHED_DEFINITION_QNAMES.add("String");
        CACHED_DEFINITION_QNAMES.add("Array");
        CACHED_DEFINITION_QNAMES.add("XML");
        CACHED_DEFINITION_QNAMES.add("XMLList");
        CACHED_DEFINITION_QNAMES.add("Boolean");
        CACHED_DEFINITION_QNAMES.add("int");
        CACHED_DEFINITION_QNAMES.add("uint");
        CACHED_DEFINITION_QNAMES.add("Number");
        CACHED_DEFINITION_QNAMES.add("Class");
        CACHED_DEFINITION_QNAMES.add("Function");
        CACHED_DEFINITION_QNAMES.add("Namespace");
        CACHED_DEFINITION_QNAMES.add(IASLanguageConstants.Vector_qname);
        CACHED_DEFINITION_QNAMES.add("undefined");
    }

    public static final class DefinitionPromise
    extends DefinitionBase {
        private WeakReference<ICompilationUnit> compilationUnitWeakRef;
        private IDefinition actualDefinition;

        private DefinitionPromise(String qname, ICompilationUnit compilationUnit) {
            super(qname);
            assert (qname.charAt(qname.length() - 1) != '.') : "Qualified names must not end in '.'";
            this.compilationUnitWeakRef = new WeakReference<ICompilationUnit>(compilationUnit);
            this.actualDefinition = null;
        }

        public IDefinition getActualDefinition() {
            if (this.actualDefinition != null) {
                return this.actualDefinition;
            }
            String qname = this.getQualifiedName();
            try {
                ICompilationUnit compilationUnit = (ICompilationUnit)this.compilationUnitWeakRef.get();
                assert (compilationUnit != null);
                IFileScopeRequestResult fileScopeRequestResult = compilationUnit.getFileScopeRequest().get();
                this.actualDefinition = fileScopeRequestResult.getMainDefinition(qname);
            }
            catch (InterruptedException e) {
                this.actualDefinition = null;
            }
            return this.actualDefinition;
        }

        public ICompilationUnit getCompilationUnit() {
            return (ICompilationUnit)this.compilationUnitWeakRef.get();
        }

        public void clean() {
            this.actualDefinition = null;
        }

        @Override
        public String toString() {
            return "DefinitionPromise \"" + this.getQualifiedName() + "\"";
        }

        @Override
        protected String toStorageName(String name) {
            return name;
        }

        @Override
        public final String getPackageName() {
            String storageName = this.getStorageName();
            int lastDotIndex = storageName.lastIndexOf(46);
            return lastDotIndex != -1 ? storageName.substring(0, lastDotIndex) : "";
        }

        @Override
        public final String getQualifiedName() {
            return this.getStorageName();
        }

        @Override
        public final String getBaseName() {
            String storageName = this.getStorageName();
            int lastDotIndex = storageName.lastIndexOf(46);
            return lastDotIndex != -1 ? storageName.substring(lastDotIndex + 1) : storageName;
        }

        @Override
        public boolean isInProject(ICompilerProject project) {
            return false;
        }
    }
}

