/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.royale.abc.ABCEmitter;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.IEmbedResolver;
import org.apache.royale.compiler.config.RSLSettings;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSManager;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IEffectDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.IStyleDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.abc.ClassGeneratorHelper;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.css.codegen.ICSSCodeGenResult;
import org.apache.royale.compiler.internal.css.semantics.ActivatedStyleSheets;
import org.apache.royale.compiler.internal.css.semantics.CSSSemanticAnalyzer;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.projects.DependencyGraph;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.targets.AppSWFTarget;
import org.apache.royale.compiler.internal.targets.FlexRSLInfo;
import org.apache.royale.compiler.internal.targets.FlexSplashScreenImage;
import org.apache.royale.compiler.internal.targets.ITargetAttributes;
import org.apache.royale.compiler.internal.targets.NilTargetAttributes;
import org.apache.royale.compiler.internal.targets.RoyaleApplicationFrame1Info;
import org.apache.royale.compiler.internal.targets.RoyaleTarget;
import org.apache.royale.compiler.internal.targets.SWFTarget;
import org.apache.royale.compiler.internal.targets.Target;
import org.apache.royale.compiler.internal.targets.TargetReport;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.internal.units.MXMLCompilationUnit;
import org.apache.royale.compiler.problems.CSSCodeGenProblem;
import org.apache.royale.compiler.problems.ClassesMappedToSameRemoteAliasProblem;
import org.apache.royale.compiler.problems.FileNotFoundProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MissingFactoryClassInFrameMetadataProblem;
import org.apache.royale.compiler.targets.ITargetProgressMonitor;
import org.apache.royale.compiler.targets.ITargetReport;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEmbedNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFileNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IRequest;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.SWFFrame;
import org.apache.royale.swf.tags.DoABCTag;

public class RoyaleAppSWFTarget
extends AppSWFTarget {
    private boolean isFlexSDKInfo;
    private final RoyaleProject royaleProject;
    private FlexDelegate delegate;

    public RoyaleAppSWFTarget(IResolvedQualifiersReference mainApplicationClass, RoyaleProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) throws InterruptedException {
        super(project, targetSettings, progressMonitor);
        this.isFlexSDKInfo = this.targetSettings.getInfoFlex();
        this.royaleProject = project;
    }

    public boolean isFlexInfo() {
        return this.getDelegate().isFlexInfo(this.getRootClassDefinition());
    }

    private FlexDelegate getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        ClassDefinition mainAppClass = this.getRootClassDefinition();
        assert (mainAppClass != null) : "build should be abort before this point if root class does not exist!";
        this.delegate = new FlexDelegate(mainAppClass, this.targetSettings, this.royaleProject);
        return this.delegate;
    }

    private void resolveReferenceToCompilationUnit(IResolvedQualifiersReference referenceToResolve, ASProjectScope projectScope, ImmutableSet.Builder<ICompilationUnit> compilationUnits, ImmutableList.Builder<ICompilerProblem> problems) {
        IDefinition definition = referenceToResolve.resolve(this.royaleProject);
        if (definition != null) {
            ICompilationUnit moduleFactoryCU = projectScope.getCompilationUnitForDefinition(definition);
            assert (moduleFactoryCU != null) : "Unable to get compilation unit for definition!";
            compilationUnits.add((Object)moduleFactoryCU);
        }
    }

    private SWFTarget.SWFFrameInfo createFrameInfoForGeneratedSystemManager(ClassDefinition factoryClass) throws InterruptedException {
        IResolvedQualifiersReference runtimeDPIProviderRef;
        String compatibilityVersion;
        boolean hasCrossDomainRSL;
        ICompilationUnit factoryClassCompilationUnit = this.royaleProject.getScope().getCompilationUnitForDefinition(factoryClass);
        assert (factoryClassCompilationUnit != null) : "Unable to find compilation unit for definiton!";
        ImmutableSet.Builder compilationUnits = ImmutableSet.builder();
        ImmutableList.Builder problems = ImmutableList.builder();
        compilationUnits.add((Object)factoryClassCompilationUnit);
        ASProjectScope projectScope = this.royaleProject.getScope();
        FlexDelegate delegate = this.getDelegate();
        if (delegate.iModuleFactoryReference.resolve(this.royaleProject) != null) {
            this.resolveReferenceToCompilationUnit(delegate.iModuleFactoryReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        }
        if (delegate.iSWFContextReference.resolve(this.royaleProject) != null) {
            this.resolveReferenceToCompilationUnit(delegate.iSWFContextReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        }
        this.resolveReferenceToCompilationUnit(delegate.getPreloaderClassReference(), projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        boolean bl = hasCrossDomainRSL = !this.targetSettings.getRuntimeSharedLibraryPath().isEmpty();
        if (hasCrossDomainRSL) {
            this.resolveReferenceToCompilationUnit(delegate.crossDomainRSLItemReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        }
        if ((compatibilityVersion = this.royaleProject.getCompatibilityVersionString()) != null) {
            this.resolveReferenceToCompilationUnit(delegate.royaleVersionReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        }
        if ((runtimeDPIProviderRef = delegate.getRuntimeDPIProviderClassReference()) != null) {
            this.resolveReferenceToCompilationUnit(runtimeDPIProviderRef, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        }
        FlexSplashScreenImage splashScreen = delegate.getSplashScreenImage();
        if (splashScreen.compilationUnit != null) {
            compilationUnits.add((Object)splashScreen.compilationUnit);
        } else if (splashScreen.generatedEmbedClassReference != null) {
            this.resolveReferenceToCompilationUnit(splashScreen.generatedEmbedClassReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        }
        SWFTarget.SWFFrameInfo systemManagerFrameInfo = new SWFTarget.SWFFrameInfo(factoryClass.getQualifiedName(), false, (Set<ICompilationUnit>)compilationUnits.build(), (Iterable<ICompilerProblem>)problems.build());
        return systemManagerFrameInfo;
    }

    private SWFTarget.SWFFrameInfo createFrameInfoForApplicationFrame(ClassDefinition rootClassDefinition) throws InterruptedException {
        ImmutableSet.Builder compilationUnits = ImmutableSet.builder();
        ImmutableList.Builder classes = ImmutableList.builder();
        ImmutableList.Builder problems = ImmutableList.builder();
        ICompilationUnit rootClassCU = this.getRootClassCompilationUnit();
        assert (rootClassCU != null) : "Unable to find compilation unit for definiton!";
        compilationUnits.add((Object)rootClassCU);
        classes.add((Object)rootClassDefinition);
        Set<ICompilationUnit> includesCompilationUnits = this.getIncludesCompilationUnits();
        compilationUnits.addAll(includesCompilationUnits);
        Collection<ICompilationUnit> includeLibrariesCompilationUnits = this.getIncludeLibrariesCompilationUnits();
        compilationUnits.addAll(includeLibrariesCompilationUnits);
        FlexDelegate delegate = this.getDelegate();
        ASProjectScope projectScope = this.royaleProject.getScope();
        if (delegate.getGenerateSystemManagerAndFlexInit() && this.isFlexSDKInfo) {
            this.resolveReferenceToCompilationUnit(delegate.generateCSSStyleDeclarationsReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
            this.resolveReferenceToCompilationUnit(delegate.childManagerReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
            this.resolveReferenceToCompilationUnit(delegate.styleManagerImplReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
            this.resolveReferenceToCompilationUnit(delegate.effectManagerReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
            this.resolveReferenceToCompilationUnit(delegate.textFieldFactoryReference, projectScope, (ImmutableSet.Builder<ICompilationUnit>)compilationUnits, (ImmutableList.Builder<ICompilerProblem>)problems);
        }
        SWFTarget.SWFFrameInfo applicationFrameInfo = new SWFTarget.SWFFrameInfo(rootClassDefinition.getQualifiedName(), true, (Set<ICompilationUnit>)compilationUnits.build(), (Iterable<ICompilerProblem>)problems.build());
        return applicationFrameInfo;
    }

    @Override
    protected SWFTarget.FramesInformation computeFramesInformation() throws InterruptedException {
        ClassDefinition initialFactoryClass;
        LinkedList<SWFTarget.SWFFrameInfo> frames = new LinkedList<SWFTarget.SWFFrameInfo>();
        ClassDefinition rootClassDef = this.getRootClassDefinition();
        assert (rootClassDef != null) : "If the root class can not be resolved, the build should be aborted before this point";
        ICompilationUnit rootClassCU = this.getRootClassCompilationUnit();
        assert (rootClassCU != null) : "Unable to find compilation unit for definiton!";
        SWFTarget.SWFFrameInfo applicationFrame = this.createFrameInfoForApplicationFrame(rootClassDef);
        frames.addFirst(applicationFrame);
        ClassDefinition currentFrameClass = initialFactoryClass = rootClassDef.resolveInheritedFactoryClass(this.royaleProject);
        SWFTarget.SWFFrameInfo systemManagerFrame = null;
        FlexDelegate delegate = this.getDelegate();
        if (delegate.getGenerateSystemManagerAndFlexInit()) {
            SWFTarget.SWFFrameInfo frameInfo;
            systemManagerFrame = frameInfo = this.createFrameInfoForGeneratedSystemManager(initialFactoryClass);
            frames.addFirst(frameInfo);
            currentFrameClass = currentFrameClass.resolveInheritedFactoryClass(this.project);
        }
        while (currentFrameClass != null && !currentFrameClass.isImplicit()) {
            ICompilationUnit currentFrameClassCompilationUnit = this.royaleProject.getScope().getCompilationUnitForDefinition(currentFrameClass);
            assert (currentFrameClassCompilationUnit != null) : "Unable to find compilation unit for definiton!";
            SWFTarget.SWFFrameInfo frameInfo = new SWFTarget.SWFFrameInfo(currentFrameClass.getQualifiedName(), false, Collections.singleton(currentFrameClassCompilationUnit), Collections.emptyList());
            frames.addFirst(frameInfo);
            currentFrameClass = currentFrameClass.resolveInheritedFactoryClass(this.project);
        }
        assert (((SWFTarget.SWFFrameInfo)frames.getLast()).rootedUnits.contains(rootClassCU)) : "The main class definition for the last frame, must be the main class definition for the SWF.";
        SWFTarget.FramesInformation explicitFrames = this.getExplicitFramesInformation();
        return new RoyaleApplicationFramesInformation(frames, explicitFrames, initialFactoryClass, systemManagerFrame, applicationFrame);
    }

    @Override
    protected Target.DirectDependencies getDirectDependencies(ICompilationUnit cu) throws InterruptedException {
        Target.DirectDependencies directDependencies = super.getDirectDependencies(cu);
        if (!this.targetSettings.isAccessible()) {
            return directDependencies;
        }
        FlexDelegate delegate = this.getDelegate();
        Target.DirectDependencies acccessibilityDependencies = delegate.getAccessibilityDependencies(cu);
        return Target.DirectDependencies.concat(directDependencies, acccessibilityDependencies);
    }

    @Override
    protected Set<ICompilationUnit> findAllCompilationUnitsToLink(Collection<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        FlexDelegate delegate = this.getDelegate();
        if (!delegate.getGenerateSystemManagerAndFlexInit() && !delegate.isFlexInfo(this.getRootClassDefinition())) {
            return super.findAllCompilationUnitsToLink(compilationUnits, problems);
        }
        for (ICompilationUnit cu : compilationUnits) {
            cu.startBuildAsync(this.getTargetType());
        }
        assert (compilationUnits != null) : "compilation units can't be null";
        assert (problems != null) : "problems can't be null";
        HashSet<ICompilationUnit> allCompilationUnitsInTarget = new HashSet<ICompilationUnit>(compilationUnits);
        ActivatedStyleSheets activatedStyleSheets = new ActivatedStyleSheets();
        ICSSManager cssManager = this.royaleProject.getCSSManager();
        this.collectThemes(cssManager, activatedStyleSheets, problems);
        this.collectDefaultCSS(cssManager, activatedStyleSheets, problems);
        boolean done = false;
        while (!done) {
            Set<ICompilationUnit> dependencies = this.getDependentCompilationUnits(allCompilationUnitsInTarget, problems);
            allCompilationUnitsInTarget.addAll(dependencies);
            Map<ICSSDocument, File> activatedDefaultCSSList = RoyaleAppSWFTarget.getAllDefaultCSS(cssManager, allCompilationUnitsInTarget);
            for (Map.Entry<ICSSDocument, File> entry : activatedDefaultCSSList.entrySet()) {
                activatedStyleSheets.addLibraryCSS(entry.getKey(), entry.getValue().getAbsolutePath());
            }
            ImmutableList<IDefinition> definitions = Target.getAllExternallyVisibleDefinitions(allCompilationUnitsInTarget);
            HashSet<ICompilationUnit> cssDependencies = new HashSet<ICompilationUnit>();
            for (ICSSDocument cssDocument : activatedStyleSheets.all()) {
                Collection<ICompilationUnit> dependentCUListFromCSS = cssManager.getDependentCompilationUnitsFromCSS(delegate.cssCompilationSession, cssDocument, (Collection<IDefinition>)definitions, problems);
                cssDependencies.addAll(dependentCUListFromCSS);
            }
            done = !allCompilationUnitsInTarget.addAll(cssDependencies);
            if (!done) continue;
            ClassDefinition rootDef = this.getRootClassDefinition();
            ICompilationUnit rootClassCompilationUnit = this.project.getScope().getCompilationUnitForDefinition(rootDef);
            DependencyGraph graph = this.royaleProject.getDependencyGraph();
            for (ICompilationUnit cu : cssDependencies) {
                graph.addDependency(rootClassCompilationUnit, cu, DependencyType.EXPRESSION);
            }
        }
        ((FlexDelegate)delegate).cssCompilationSession.cssDocuments.addAll(activatedStyleSheets.sort());
        return allCompilationUnitsInTarget;
    }

    private void collectThemes(ICSSManager cssManager, ActivatedStyleSheets activatedStyleSheets, Collection<ICompilerProblem> problems) {
        Collection<ICSSDocument> cssFromThemes = cssManager.getCSSFromThemes(problems);
        for (ICSSDocument themeCSS : cssFromThemes) {
            activatedStyleSheets.addThemeCSS(themeCSS);
        }
    }

    private void collectDefaultCSS(ICSSManager cssManager, ActivatedStyleSheets activatedStyleSheets, Collection<ICompilerProblem> problems) {
        for (String defaultsCSSPath : this.getTargetSettings().getDefaultsCSSFiles()) {
            ICSSDocument defaultsCSSModel = cssManager.getCSS(defaultsCSSPath);
            if (defaultsCSSModel == null) {
                problems.add(new FileNotFoundProblem(defaultsCSSPath));
                continue;
            }
            activatedStyleSheets.addDefaultCSS(defaultsCSSModel);
        }
    }

    private boolean hasRSLs() {
        List<RSLSettings> rslSettingsList = this.targetSettings.getRuntimeSharedLibraryPath();
        return rslSettingsList.size() > 0 || this.targetSettings.getRuntimeSharedLibraries().size() > 0;
    }

    @Override
    protected final ITargetReport computeTargetReport() throws InterruptedException {
        Target.BuiltCompilationUnitSet builtCompilationUnits = this.getBuiltCompilationUnitSet();
        FlexRSLInfo rslInfo = this.getDelegate().getRSLInfo();
        return new TargetReport(this.project, builtCompilationUnits.compilationUnits, rslInfo.requiredRSLs, this.getBackgroundColor(), this.targetSettings, this.getTargetAttributes(), this.getLinkageChecker());
    }

    private static Map<ICSSDocument, File> getAllDefaultCSS(ICSSManager cssManager, Collection<ICompilationUnit> compilationUnits) {
        assert (cssManager != null) : "Expected CSS manager.";
        assert (compilationUnits != null) : "Expected collection of compilation units.";
        HashMap<ICSSDocument, File> result = new HashMap<ICSSDocument, File>();
        for (ICompilationUnit compilationUnit : compilationUnits) {
            File swcFile;
            ICSSDocument defaultCSS;
            if (compilationUnit.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT || (defaultCSS = cssManager.getDefaultCSS(swcFile = new File(compilationUnit.getAbsoluteFilename()))) == null) continue;
            result.put(defaultCSS, swcFile);
        }
        return result;
    }

    @Override
    protected ITargetAttributes computeTargetAttributes() throws InterruptedException {
        return this.delegate.getTargetAttributes();
    }

    @Override
    protected Iterable<ICompilerProblem> computeFatalProblems() throws InterruptedException {
        Iterable<ICompilerProblem> fatalProblemsFromSuper = super.computeFatalProblems();
        if (!Iterables.isEmpty(fatalProblemsFromSuper)) {
            return fatalProblemsFromSuper;
        }
        ICompilationUnit rootClassCompilationUnit = this.getRootClassCompilationUnit();
        Collection<ICompilerProblem> externallyVisibleDefinitionProblems = rootClassCompilationUnit.getFileScopeRequest().get().checkExternallyVisibleDefinitions(this.targetSettings.getRootClassName());
        assert (!externallyVisibleDefinitionProblems.isEmpty() || this.checkRootDefinitionConsistency());
        return externallyVisibleDefinitionProblems;
    }

    @Override
    protected ISWF initializeSWF(List<ICompilationUnit> reachableCompilationUnits) throws InterruptedException {
        ISWF swf = super.initializeSWF(reachableCompilationUnits);
        this.delegate.addProductInfoToSWF(swf);
        return swf;
    }

    private boolean checkRootDefinitionConsistency() {
        ICompilationUnit rootClassCompilationUnit;
        ClassDefinition rootClassDefinition = this.getRootClassDefinition();
        if (rootClassDefinition == null) {
            return false;
        }
        ICompilationUnit rootCompilationUnit = this.getRootClassCompilationUnit();
        return rootCompilationUnit == (rootClassCompilationUnit = this.project.getScope().getCompilationUnitForDefinition(rootClassDefinition));
    }

    private class FlexDelegate
    extends RoyaleTarget {
        private final IClassDefinition mainApplicationClassDefinition;
        private final IResolvedQualifiersReference objectReference;
        private final IResolvedQualifiersReference generateCSSStyleDeclarationsReference;
        private final IResolvedQualifiersReference iModuleFactoryReference;
        private final IResolvedQualifiersReference childManagerReference;
        private final IResolvedQualifiersReference styleManagerImplReference;
        private final IResolvedQualifiersReference effectManagerReference;
        private final IResolvedQualifiersReference mxInternalReference;
        private final IResolvedQualifiersReference getClassByAliasReference;
        private final IResolvedQualifiersReference registerClassAliasReference;
        private final IResolvedQualifiersReference crossDomainRSLItemReference;
        private final IResolvedQualifiersReference royaleVersionReference;
        private final IResolvedQualifiersReference capabilitiesReference;
        private final IResolvedQualifiersReference textFieldFactoryReference;
        private final IResolvedQualifiersReference iSWFContextReference;
        private final CSSCompilationSession cssCompilationSession;
        private Boolean generateSystemManagerAndFlexInit;
        private FlexSplashScreenImage splashScreenImage;
        private IResolvedQualifiersReference preloaderReference;
        private ITargetAttributes targetAttributes;
        private IASNode rootNode;
        private RoyaleApplicationFrame1Info frame1Info;
        private FlexRSLInfo rslInfo;

        FlexDelegate(IClassDefinition mainApplicationClassDefinition, ITargetSettings targetSettings, RoyaleProject project) {
            super(targetSettings, project);
            this.mainApplicationClassDefinition = mainApplicationClassDefinition;
            this.objectReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "", "Object", false);
            this.generateCSSStyleDeclarationsReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "flex.compiler.support.generateCSSStyleDeclarations");
            this.iModuleFactoryReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.core.IFlexModuleFactory");
            this.childManagerReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.managers.systemClasses.ChildManager");
            this.styleManagerImplReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.styles.StyleManagerImpl");
            this.effectManagerReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.effects.EffectManager");
            this.mxInternalReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.core.mx_internal");
            this.getClassByAliasReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "flash.net.getClassByAlias");
            this.registerClassAliasReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "flash.net.registerClassAlias");
            this.crossDomainRSLItemReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.core.CrossDomainRSLItem");
            this.royaleVersionReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.core.RoyaleVersion");
            this.capabilitiesReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "flash.system.Capabilities");
            this.textFieldFactoryReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "mx.core.TextFieldFactory");
            this.iSWFContextReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), "flashx.textLayout.compose.ISWFContext");
            this.cssCompilationSession = new CSSCompilationSession();
            this.cssCompilationSession.setKeepAllTypeSelectors(targetSettings.keepAllTypeSelectors());
        }

        private String getMainClassQName() {
            Name mainApplicationName = ((DefinitionBase)((Object)this.mainApplicationClassDefinition)).getMName(this.royaleProject);
            String mainApplicationPackageName = ((Namespace)Iterables.getFirst((Iterable)mainApplicationName.getQualifiers(), null)).getName();
            if (mainApplicationPackageName.length() != 0) {
                mainApplicationPackageName = mainApplicationPackageName + ".";
            }
            return mainApplicationPackageName + mainApplicationName.getBaseName();
        }

        private String getFlexInitClassName() {
            String royaleInitClassName = "_" + this.getMainClassQName() + "_FlexInit";
            royaleInitClassName = royaleInitClassName.replaceAll("[^a-zA-Z0-9]", "_");
            return royaleInitClassName;
        }

        private String getStylesClassName() {
            String royaleInitClassName = "_" + this.getMainClassQName() + "_Styles";
            royaleInitClassName = royaleInitClassName.replaceAll("[^a-zA-Z0-9]", "_");
            return royaleInitClassName;
        }

        private String getGeneratedSystemManagerClassName(ClassDefinition systemManagerClass) {
            String generatorSystemManagerName = "_" + this.getMainClassQName() + "_" + systemManagerClass.getQualifiedName();
            generatorSystemManagerName = generatorSystemManagerName.replaceAll("[^a-zA-Z0-9]", "_");
            return generatorSystemManagerName;
        }

        private boolean addGeneratedStylesClassToFrame(SWFFrame frame, Set<ICompilationUnit> emittedCompilationUnits) throws Exception {
            ABCEmitter emitter = new ABCEmitter();
            emitter.visit(46, 16);
            ICSSCodeGenResult cssCodeGenResult = this.cssCompilationSession.emitStyleDataClass(this.royaleProject, emitter);
            Name stylesClassName = new Name(this.getStylesClassName());
            IDefinition objectDef = this.objectReference.resolve(this.royaleProject);
            if (objectDef == null || !(objectDef instanceof ClassDefinition)) {
                return false;
            }
            ClassDefinition objectClassDef = (ClassDefinition)objectDef;
            InstructionList cinit = cssCodeGenResult.getClassInitializationInstructions();
            assert (cinit.canFallThrough()) : "CSSReducer should not append 'returnvoid' to the initialization instructions.";
            cinit.addInstruction(71);
            ClassGeneratorHelper classGenerator = new ClassGeneratorHelper(this.royaleProject, emitter, stylesClassName, objectClassDef, Collections.emptyList(), Collections.emptyList(), ClassGeneratorHelper.returnVoid(), cinit, false);
            cssCodeGenResult.visitClassTraits(classGenerator.getCTraitsVisitor());
            classGenerator.finishScript();
            DoABCTag tag = new DoABCTag();
            tag.setABCData(emitter.emit());
            tag.setName("defaults.css and theme CSS data");
            frame.addTag(tag);
            return true;
        }

        private boolean computeGenerateSystemManagerAndFlexInit() {
            ClassDefinition rootClassDef = (ClassDefinition)this.mainApplicationClassDefinition;
            ClassDefinition rootFactoryClass = rootClassDef.resolveInheritedFactoryClass(this.royaleProject);
            this.generateSystemManagerAndFlexInit = rootFactoryClass != null && !rootClassDef.hasOwnFactoryClass(this.royaleProject.getWorkspace());
            return this.generateSystemManagerAndFlexInit;
        }

        public boolean isFlexInfo(ClassDefinition rootClassDef) {
            for (ClassDefinition superClass = (ClassDefinition)rootClassDef.resolveBaseClass(this.royaleProject); superClass != null && !superClass.getBaseName().equals("Object"); superClass = (ClassDefinition)superClass.resolveBaseClass(this.royaleProject)) {
                String[] impls;
                for (String impl : impls = superClass.getImplementedInterfacesAsDisplayStrings()) {
                    if (!impl.contains(".IFlexInfo")) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean getGenerateSystemManagerAndFlexInit() {
            if (this.generateSystemManagerAndFlexInit != null) {
                return this.generateSystemManagerAndFlexInit;
            }
            this.generateSystemManagerAndFlexInit = this.computeGenerateSystemManagerAndFlexInit();
            return this.generateSystemManagerAndFlexInit;
        }

        private String getAtFunctionName(String value) {
            int openParen;
            if ((value = value.trim()).length() > 1 && value.charAt(0) == '@' && (openParen = value.indexOf(40)) > 1 && value.indexOf(41) > openParen) {
                return value.substring(1, openParen);
            }
            return null;
        }

        private EmbedCompilationUnit getEmbeddedCompilationUnit(String attributeName) throws InterruptedException {
            if (attributeName == null) {
                throw new NullPointerException();
            }
            ICompilationUnit splashUnit = null;
            IASNode asNode = this.getRootNode();
            if (!(asNode instanceof IMXMLFileNode)) {
                return null;
            }
            IMXMLFileNode mxmlNode = (IMXMLFileNode)asNode;
            List<IEmbedResolver> embedNodes = mxmlNode.getEmbedNodes();
            for (IEmbedResolver node : embedNodes) {
                ISetterDefinition setter;
                IMXMLPropertySpecifierNode propertyNode;
                IDefinition propertyDefinition;
                IMXMLEmbedNode embedNode;
                IASNode parent;
                if (!(node instanceof IMXMLEmbedNode) || !((parent = (embedNode = (IMXMLEmbedNode)((Object)node)).getParent()) instanceof IMXMLPropertySpecifierNode) || !((propertyDefinition = (propertyNode = (IMXMLPropertySpecifierNode)parent).getDefinition()) instanceof ISetterDefinition) || !attributeName.equals((setter = (ISetterDefinition)propertyDefinition).getBaseName())) continue;
                Collection<ICompilerProblem> problems = null;
                splashUnit = node.resolveCompilationUnit(this.royaleProject, problems);
                break;
            }
            if (splashUnit instanceof EmbedCompilationUnit) {
                return (EmbedCompilationUnit)splashUnit;
            }
            return null;
        }

        private FlexSplashScreenImage compuateSplashScreenImage() throws InterruptedException {
            String splashScreenImageValue = this.getTargetAttributes().getSplashScreenImage();
            if (splashScreenImageValue == null) {
                return new FlexSplashScreenImage(null, null);
            }
            String className = null;
            EmbedCompilationUnit splashScreenImageEmbedUnit = null;
            String functionName = this.getAtFunctionName(splashScreenImageValue);
            IResolvedQualifiersReference splashScreenImageReference = null;
            if ("Embed".equals(functionName)) {
                splashScreenImageEmbedUnit = this.getEmbeddedCompilationUnit("splashScreenImage");
                className = splashScreenImageEmbedUnit.getName();
                assert (className != null);
            } else {
                className = splashScreenImageValue;
            }
            if (className != null) {
                splashScreenImageReference = ReferenceFactory.packageQualifiedReference(this.royaleProject.getWorkspace(), className);
            }
            return new FlexSplashScreenImage(splashScreenImageEmbedUnit, splashScreenImageReference);
        }

        private FlexSplashScreenImage getSplashScreenImage() throws InterruptedException {
            if (this.splashScreenImage != null) {
                return this.splashScreenImage;
            }
            this.splashScreenImage = this.compuateSplashScreenImage();
            return this.splashScreenImage;
        }

        private ITargetAttributes computeTargetAttributes() throws InterruptedException {
            IASNode root = this.getRootNode();
            if (!(root instanceof IFileNode)) {
                return NilTargetAttributes.INSTANCE;
            }
            ITargetAttributes nodeTargetAttributes = ((IFileNode)root).getTargetAttributes(this.royaleProject);
            if (nodeTargetAttributes == null) {
                return NilTargetAttributes.INSTANCE;
            }
            return nodeTargetAttributes;
        }

        private ITargetAttributes getTargetAttributes() throws InterruptedException {
            if (this.targetAttributes != null) {
                return this.targetAttributes;
            }
            this.targetAttributes = this.computeTargetAttributes();
            return this.targetAttributes;
        }

        protected IASNode getRootNode() throws InterruptedException {
            if (this.rootNode != null) {
                return this.rootNode;
            }
            ASProjectScope projectScope = this.royaleProject.getScope();
            ClassDefinition mainClassDef = (ClassDefinition)this.mainApplicationClassDefinition;
            if (mainClassDef.hasOwnFactoryClass(this.royaleProject.getWorkspace())) {
                return null;
            }
            ICompilationUnit mainUnit = projectScope.getCompilationUnitForDefinition(mainClassDef);
            IRequest<ISyntaxTreeRequestResult, ICompilationUnit> request = mainUnit.getSyntaxTreeRequest();
            ISyntaxTreeRequestResult result = request.get();
            this.rootNode = result.getAST();
            return this.rootNode;
        }

        final RoyaleApplicationFrame1Info getFrame1Info() throws InterruptedException {
            if (this.frame1Info != null) {
                return this.frame1Info;
            }
            this.frame1Info = new RoyaleApplicationFrame1Info(this.royaleProject, RoyaleAppSWFTarget.this.targetSettings, this.mainApplicationClassDefinition, this.getGenerateSystemManagerAndFlexInit(), this.isFlexInfo((ClassDefinition)this.mainApplicationClassDefinition), RoyaleAppSWFTarget.this.getBuiltCompilationUnitSet().compilationUnits);
            return this.frame1Info;
        }

        final FlexRSLInfo getRSLInfo() throws InterruptedException {
            if (this.rslInfo != null) {
                return this.rslInfo;
            }
            this.rslInfo = new FlexRSLInfo(this.getFrame1Info(), this.royaleProject, RoyaleAppSWFTarget.this.targetSettings);
            return this.rslInfo;
        }

        boolean addGeneratedCodeToMainApplicationFrame(SWFFrame mainApplicationFrame, RoyaleApplicationFrame1Info frame1Info, Set<ICompilationUnit> emittedCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            boolean isAppFlexInfo = this.isFlexInfo((ClassDefinition)this.mainApplicationClassDefinition);
            if (this.getGenerateSystemManagerAndFlexInit() || isAppFlexInfo) {
                try {
                    if (!this.addGeneratedStylesClassToFrame(mainApplicationFrame, emittedCompilationUnits)) {
                        return false;
                    }
                }
                catch (Exception e) {
                    CSSCodeGenProblem problem = new CSSCodeGenProblem(e);
                    problems.add(problem);
                }
                FlexRSLInfo rslInfo = RoyaleAppSWFTarget.this.getDelegate().getRSLInfo();
                this.addGeneratedFlexInitToFrame(problems, mainApplicationFrame, emittedCompilationUnits, isAppFlexInfo, frame1Info, rslInfo);
            } else {
                this.addGeneratedCompiledResourceBundleInfoToFrame(frame1Info, mainApplicationFrame);
            }
            return true;
        }

        private void addGeneratedCompiledResourceBundleInfoToFrame(RoyaleApplicationFrame1Info frame1Info, SWFFrame frame) {
            Collection<String> locales = this.royaleProject.getLocales();
            if (locales.size() == 0 || frame1Info.compiledResourceBundleNames.size() == 0) {
                return;
            }
            String className = "_CompiledResourceBundleInfo";
            IResolvedQualifiersReference mainClassRef = ReferenceFactory.packageQualifiedReference(this.royaleProject.getWorkspace(), className);
            ABCEmitter emitter = new ABCEmitter();
            emitter.visit(46, 16);
            ClassGeneratorHelper classGen = new ClassGeneratorHelper(this.royaleProject, emitter, mainClassRef.getMName(), (ClassDefinition)this.royaleProject.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT), ClassGeneratorHelper.returnVoid());
            InstructionList localesInstructionList = new InstructionList();
            for (String string : locales) {
                localesInstructionList.addInstruction(44, string);
            }
            localesInstructionList.addInstruction(86, locales.size());
            localesInstructionList.addInstruction(72);
            classGen.addCTraitsGetter(new Name("compiledLocales"), new Name("Array"), localesInstructionList);
            InstructionList bundlesInstructionList = new InstructionList();
            for (String bundleName : frame1Info.compiledResourceBundleNames) {
                bundlesInstructionList.addInstruction(44, bundleName);
            }
            bundlesInstructionList.addInstruction(86, frame1Info.compiledResourceBundleNames.size());
            bundlesInstructionList.addInstruction(72);
            classGen.addCTraitsGetter(new Name("compiledResourceBundleNames"), new Name("Array"), bundlesInstructionList);
            classGen.finishScript();
            DoABCTag doABCTag = new DoABCTag();
            try {
                doABCTag.setABCData(emitter.emit());
            }
            catch (Exception e) {
                return;
            }
            doABCTag.setName(className);
            frame.addTag(doABCTag);
        }

        private boolean addGeneratedFlexInitToFrame(final Collection<ICompilerProblem> problems, SWFFrame frame, Set<ICompilationUnit> emittedCompilationUnits, boolean isAppFlexInfo, RoyaleApplicationFrame1Info frame1Info, FlexRSLInfo rslInfo) throws InterruptedException {
            InstructionList initMethod;
            IMethodBodyVisitor initMethodBodyVisitor;
            MethodBodyInfo initMethodBodyInfo;
            IMethodVisitor initMethodVisitor;
            MethodInfo initMethodInfo;
            ABCEmitter emitter = new ABCEmitter();
            emitter.visit(46, 16);
            String royaleInitClassNameString = this.getFlexInitClassName();
            Name royaleInitClassName = new Name(royaleInitClassNameString);
            Name stylesClassName = new Name(this.getStylesClassName());
            IDefinition objectDef = this.objectReference.resolve(this.royaleProject);
            if (objectDef == null || !(objectDef instanceof ClassDefinition)) {
                return false;
            }
            ClassDefinition objectClassDef = (ClassDefinition)objectDef;
            TreeMap<String, String> effectNameToTriggerMap = new TreeMap<String, String>();
            TreeMap<String, Boolean> inheritingStyleMap = new TreeMap<String, Boolean>();
            TreeMap<ClassDefinition, String> remoteClassAliasMap = new TreeMap<ClassDefinition, String>((Comparator)new Comparator<ClassDefinition>(){

                @Override
                public int compare(ClassDefinition o1, ClassDefinition o2) {
                    return o1.getQualifiedName().compareTo(o2.getQualifiedName());
                }
            }){
                private static final long serialVersionUID = 1L;

                @Override
                public String put(ClassDefinition key, String value) {
                    if (this.containsValue(value)) {
                        for (Map.Entry entry : this.entrySet()) {
                            if (value == null || !value.equals(entry.getValue())) continue;
                            problems.add(new ClassesMappedToSameRemoteAliasProblem(key.getQualifiedName(), ((ClassDefinition)entry.getKey()).getQualifiedName(), value));
                            break;
                        }
                    }
                    return super.put(key, value);
                }
            };
            for (ICompilationUnit cu : emittedCompilationUnits) {
                Collection<IDefinition> visibleDefs = cu.getFileScopeRequest().get().getExternallyVisibleDefinitions();
                for (IDefinition visibleDef : visibleDefs) {
                    IEffectDefinition[] effectDefinitions;
                    if (!(visibleDef instanceof ClassDefinition)) continue;
                    ClassDefinition visibleClass = (ClassDefinition)visibleDef;
                    for (IEffectDefinition effectDefinition : effectDefinitions = visibleClass.getEffectDefinitions(this.royaleProject.getWorkspace())) {
                        effectNameToTriggerMap.put(effectDefinition.getBaseName(), effectDefinition.getEvent());
                    }
                    IStyleDefinition[] styleDefinitions = visibleClass.getStyleDefinitions(this.royaleProject.getWorkspace());
                    for (IStyleDefinition styleDefinition : styleDefinitions) {
                        boolean isInheriting = styleDefinition.isInheriting();
                        inheritingStyleMap.put(styleDefinition.getBaseName(), isInheriting);
                    }
                    String remoteClassAlias = visibleClass.getRemoteClassAlias();
                    if (remoteClassAlias == null) continue;
                    remoteClassAliasMap.put(visibleClass, remoteClassAlias);
                }
            }
            InstructionList classITraitsInit = new InstructionList();
            classITraitsInit.addInstruction(208);
            classITraitsInit.addInstruction(73, 0);
            classITraitsInit.addInstruction(71);
            ClassGeneratorHelper classGen = new ClassGeneratorHelper(this.royaleProject, emitter, royaleInitClassName, objectClassDef, Collections.emptyList(), classITraitsInit);
            if (isAppFlexInfo) {
                initMethodInfo = new MethodInfo();
                initMethodInfo.setMethodName("FlexInit init method");
                initMethodInfo.setParamTypes(new Vector<Name>(Collections.singleton(new Name("Object"))));
                initMethodInfo.setReturnType(new Name("void"));
                initMethodVisitor = emitter.visitMethod(initMethodInfo);
                initMethodVisitor.visit();
                initMethodBodyInfo = new MethodBodyInfo();
                initMethodBodyInfo.setMethodInfo(initMethodInfo);
                initMethodBodyVisitor = initMethodVisitor.visitBody(initMethodBodyInfo);
                initMethodBodyVisitor.visit();
                initMethod = new InstructionList();
                initMethod.addInstruction(71);
                initMethodBodyVisitor.visitInstructionList(initMethod);
                initMethodBodyVisitor.visitEnd();
                initMethodVisitor.visitEnd();
                ITraitVisitor initMethodTraitVisitor = classGen.getCTraitsVisitor().visitMethodTrait(1, new Name("init"), 0, initMethodInfo);
                initMethodTraitVisitor.visitStart();
                initMethodTraitVisitor.visitEnd();
                this.codegenInfoMethod(classGen, this.royaleProject.getCompatibilityVersion(), this.getMainClassQName(), this.getPreloaderClassReference(), this.getRuntimeDPIProviderClassReference(), this.splashScreenImage, this.getRootNode(), this.getTargetAttributes(), this.royaleProject.getLocales(), frame1Info, this.accessibleClassNames, this.getFlexInitClassName(), this.getStylesClassName(), RoyaleAppSWFTarget.this.targetSettings.getRuntimeSharedLibraries(), rslInfo, problems, isAppFlexInfo, RoyaleAppSWFTarget.this.isFlexSDKInfo, (Map<ClassDefinition, String>)remoteClassAliasMap);
            } else {
                initMethodInfo = new MethodInfo();
                initMethodInfo.setMethodName("FlexInit init method");
                initMethodInfo.setParamTypes(new Vector<Name>(Collections.singleton(this.iModuleFactoryReference.getMName())));
                initMethodInfo.setReturnType(new Name("void"));
                initMethodVisitor = emitter.visitMethod(initMethodInfo);
                initMethodVisitor.visit();
                initMethodBodyInfo = new MethodBodyInfo();
                initMethodBodyInfo.setMethodInfo(initMethodInfo);
                initMethodBodyVisitor = initMethodVisitor.visitBody(initMethodBodyInfo);
                initMethodBodyVisitor.visit();
                initMethod = new InstructionList();
                initMethod.addInstruction(8, 0);
                initMethod.addInstruction(95, this.childManagerReference.getMName());
                initMethod.addInstruction(209);
                initMethod.addInstruction(74, new Object[]{this.childManagerReference.getMName(), 1});
                initMethod.addInstruction(41);
                initMethod.addInstruction(95, this.styleManagerImplReference.getMName());
                initMethod.addInstruction(209);
                initMethod.addInstruction(74, new Object[]{this.styleManagerImplReference.getMName(), 1});
                initMethod.addInstruction(214);
                if (!effectNameToTriggerMap.isEmpty()) {
                    IDefinition mxInternalDef = this.mxInternalReference.resolve(this.royaleProject);
                    if (!(mxInternalDef instanceof NamespaceDefinition)) {
                        return false;
                    }
                    IResolvedQualifiersReference registerEffectTriggerRef = ReferenceFactory.resolvedQualifierQualifiedReference(this.royaleProject.getWorkspace(), (INamespaceDefinition)mxInternalDef, "registerEffectTrigger");
                    Name name = registerEffectTriggerRef.getMName();
                    initMethod.addInstruction(96, this.effectManagerReference.getMName());
                    for (Map.Entry effectEntry : effectNameToTriggerMap.entrySet()) {
                        initMethod.addInstruction(42);
                        initMethod.addInstruction(44, effectEntry.getKey());
                        initMethod.addInstruction(44, effectEntry.getValue());
                        initMethod.addInstruction(79, new Object[]{name, 2});
                    }
                    initMethod.addInstruction(41);
                }
                if (RoyaleAppSWFTarget.this.targetSettings.isAccessible()) {
                    Name capabilitiesSlotName = this.capabilitiesReference.getMName();
                    initMethod.addInstruction(93, capabilitiesSlotName);
                    initMethod.addInstruction(102, capabilitiesSlotName);
                    initMethod.addInstruction(102, new Name("hasAccessibility"));
                    Label accessibilityEnd = new Label();
                    initMethod.addInstruction(18, accessibilityEnd);
                    IResolvedQualifiersReference iResolvedQualifiersReference = ReferenceFactory.packageQualifiedReference(this.royaleProject.getWorkspace(), "enableAccessibility");
                    Name enableAccessibilityName = iResolvedQualifiersReference.getMName();
                    Object[] enableAccessibilityCallPropOperands = new Object[]{enableAccessibilityName, 0};
                    for (String accessibilityClassName : this.accessibleClassNames) {
                        IResolvedQualifiersReference ref = ReferenceFactory.packageQualifiedReference(this.royaleProject.getWorkspace(), accessibilityClassName);
                        Name accName = ref.getMName();
                        initMethod.addInstruction(96, accName);
                        initMethod.addInstruction(70, enableAccessibilityCallPropOperands);
                        initMethod.addInstruction(41);
                    }
                    initMethod.labelNext(accessibilityEnd);
                }
                if (!remoteClassAliasMap.isEmpty()) {
                    Name getClassByAliasName = this.getClassByAliasReference.getMName();
                    Name registerClassAliasName = this.registerClassAliasReference.getMName();
                    Object[] objectArray = new Object[]{getClassByAliasName, 1};
                    Object[] registerClassAliasCallPropOperands = new Object[]{registerClassAliasName, 2};
                    for (Map.Entry classAliasEntry : remoteClassAliasMap.entrySet()) {
                        Label tryLabel = new Label();
                        initMethod.labelNext(tryLabel);
                        initMethod.addInstruction(95, getClassByAliasName);
                        initMethod.addInstruction(44, classAliasEntry.getValue());
                        initMethod.addInstruction(70, objectArray);
                        Name classMName = ((ClassDefinition)classAliasEntry.getKey()).getMName(this.royaleProject);
                        initMethod.addInstruction(96, classMName);
                        Label endTryLabel = new Label();
                        initMethod.addInstruction(19, endTryLabel);
                        initMethod.addInstruction(95, registerClassAliasName);
                        initMethod.addInstruction(44, classAliasEntry.getValue());
                        initMethod.addInstruction(96, classMName);
                        initMethod.addInstruction(79, registerClassAliasCallPropOperands);
                        initMethod.labelNext(endTryLabel);
                        Label afterCatch = new Label();
                        initMethod.addInstruction(16, afterCatch);
                        Label catchLabel = new Label();
                        initMethod.labelNext(catchLabel);
                        initMethod.addInstruction(41);
                        initMethod.addInstruction(95, registerClassAliasName);
                        initMethod.addInstruction(44, classAliasEntry.getValue());
                        initMethod.addInstruction(96, classMName);
                        initMethod.addInstruction(79, registerClassAliasCallPropOperands);
                        initMethod.labelNext(afterCatch);
                        initMethodBodyVisitor.visitException(tryLabel, endTryLabel, catchLabel, new Name("Error"), null);
                    }
                }
                if (!inheritingStyleMap.isEmpty()) {
                    initMethod.addInstruction(96, stylesClassName);
                    int count = 0;
                    for (Map.Entry entry : inheritingStyleMap.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        ++count;
                        initMethod.addInstruction(44, entry.getKey());
                    }
                    initMethod.addInstruction(86, count);
                    initMethod.addInstruction(97, new Name("inheritingStyles"));
                }
                initMethod.addInstruction(71);
                initMethodBodyVisitor.visitInstructionList(initMethod);
                initMethodBodyVisitor.visitEnd();
                initMethodVisitor.visitEnd();
                ITraitVisitor initMethodTraitVisitor = classGen.getCTraitsVisitor().visitMethodTrait(1, new Name("init"), 0, initMethodInfo);
                initMethodTraitVisitor.visitStart();
                initMethodTraitVisitor.visitEnd();
            }
            classGen.finishScript();
            DoABCTag doABC = new DoABCTag();
            try {
                doABC.setABCData(emitter.emit());
            }
            catch (Exception e) {
                return false;
            }
            doABC.setName(this.getFlexInitClassName());
            frame.addTag(doABC);
            return true;
        }

        private IResolvedQualifiersReference getPreloaderClassReference() throws InterruptedException {
            if (this.preloaderReference != null) {
                return this.preloaderReference;
            }
            String preloaderClassName = this.getTargetAttributes().getPreloaderClassName();
            if (preloaderClassName == null) {
                preloaderClassName = RoyaleAppSWFTarget.this.targetSettings.getPreloaderClassName();
            }
            this.preloaderReference = ReferenceFactory.packageQualifiedReference(this.royaleProject.getWorkspace(), preloaderClassName);
            return this.preloaderReference;
        }

        private IResolvedQualifiersReference getRuntimeDPIProviderClassReference() throws InterruptedException {
            String runtimeDPIProviderClassName = this.getTargetAttributes().getRuntimeDPIProviderClassName();
            if (runtimeDPIProviderClassName == null) {
                return null;
            }
            return ReferenceFactory.packageQualifiedReference(this.royaleProject.getWorkspace(), runtimeDPIProviderClassName);
        }

        boolean addGeneratedSystemManagerToFrame(SWFFrame frame, RoyaleApplicationFrame1Info frame1Info, ClassDefinition systemManagerClass, ImmutableSet<ICompilationUnit> builtCompilationUnits, Collection<ICompilerProblem> problemCollection) throws InterruptedException {
            ABCEmitter emitter = new ABCEmitter();
            emitter.visit(46, 16);
            String generatedSystemManagerClassNameString = this.getGeneratedSystemManagerClassName(systemManagerClass);
            Name generatedSystemManagerName = new Name(generatedSystemManagerClassNameString);
            ImmutableList.Builder listOfInterfaces = new ImmutableList.Builder();
            if (this.iModuleFactoryReference.resolve(this.royaleProject) != null && RoyaleAppSWFTarget.this.isFlexSDKInfo) {
                listOfInterfaces.add((Object)this.iModuleFactoryReference.getMName());
            }
            if (this.iSWFContextReference.resolve(this.royaleProject) != null && RoyaleAppSWFTarget.this.isFlexSDKInfo) {
                listOfInterfaces.add((Object)this.iSWFContextReference.getMName());
            }
            ImmutableList implementedInterfaces = listOfInterfaces.build();
            String compatibilityVersion = this.royaleProject.getCompatibilityVersionString();
            InstructionList classITraitsInit = new InstructionList();
            if (compatibilityVersion != null && this.royaleVersionReference.resolve(this.royaleProject) != null && RoyaleAppSWFTarget.this.isFlexSDKInfo) {
                Name royaleVersionSlotName = this.royaleVersionReference.getMName();
                classITraitsInit.addInstruction(96, royaleVersionSlotName);
                classITraitsInit.addInstruction(44, compatibilityVersion);
                classITraitsInit.addInstruction(97, new Name("compatibilityVersionString"));
            }
            classITraitsInit.addInstruction(208);
            classITraitsInit.addInstruction(73, 0);
            classITraitsInit.addInstruction(71);
            ClassGeneratorHelper classGen = new ClassGeneratorHelper(this.royaleProject, emitter, generatedSystemManagerName, systemManagerClass, (Collection<Name>)implementedInterfaces, classITraitsInit);
            FlexRSLInfo rslInfo = this.getRSLInfo();
            FlexSplashScreenImage splashScreenImage = this.getSplashScreenImage();
            if (this.iSWFContextReference.resolve(this.royaleProject) != null && RoyaleAppSWFTarget.this.isFlexSDKInfo) {
                this.codegenCallInContextMethod(classGen, true);
            }
            this.codegenCreateMethod(classGen, ((DefinitionBase)((Object)this.mainApplicationClassDefinition)).getMName(this.royaleProject), RoyaleAppSWFTarget.this.isFlexSDKInfo);
            this.codegenInfoMethod(classGen, this.royaleProject.getCompatibilityVersion(), this.getMainClassQName(), this.getPreloaderClassReference(), this.getRuntimeDPIProviderClassReference(), splashScreenImage, this.getRootNode(), this.getTargetAttributes(), this.royaleProject.getLocales(), frame1Info, this.accessibleClassNames, this.getFlexInitClassName(), this.getStylesClassName(), RoyaleAppSWFTarget.this.targetSettings.getRuntimeSharedLibraries(), rslInfo, problemCollection, false, RoyaleAppSWFTarget.this.isFlexSDKInfo, null);
            classGen.finishScript();
            DoABCTag doABC = new DoABCTag();
            try {
                doABC.setABCData(emitter.emit());
            }
            catch (Exception e) {
                return false;
            }
            doABC.setName(generatedSystemManagerClassNameString);
            frame.addTag(doABC);
            return true;
        }
    }

    private class RoyaleApplicationFramesInformation
    extends SWFTarget.FramesInformation {
        private final ClassDefinition initialFactoryClass;
        private final SWFTarget.SWFFrameInfo systemManagerFrame;
        private final SWFTarget.SWFFrameInfo applicationFrame;
        private RoyaleApplicationFrame1Info frame1Info;

        RoyaleApplicationFramesInformation(Iterable<SWFTarget.SWFFrameInfo> implicitFrames, SWFTarget.FramesInformation explicitFrames, ClassDefinition initialFactoryClass, SWFTarget.SWFFrameInfo systemManagerFrame, SWFTarget.SWFFrameInfo applicationFrame) {
            super(Iterables.concat(implicitFrames, explicitFrames.frameInfos));
            assert (systemManagerFrame == null == (initialFactoryClass == null)) : "If initial factory class is null, then there should be no system manager frame!";
            assert (applicationFrame != null);
            this.initialFactoryClass = initialFactoryClass;
            this.systemManagerFrame = systemManagerFrame;
            this.applicationFrame = applicationFrame;
        }

        private void validateRootCompiltionUnitCSS(ImmutableSet<ICompilationUnit> builtCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            Integer compatibilityVersion = RoyaleAppSWFTarget.this.royaleProject.getCompatibilityVersion();
            if (compatibilityVersion != null && compatibilityVersion < 0x4000000) {
                return;
            }
            ICompilationUnit rootCompilationUnit = RoyaleAppSWFTarget.this.getRootClassCompilationUnit();
            if (rootCompilationUnit.getCompilationUnitType() != ICompilationUnit.UnitType.MXML_UNIT) {
                return;
            }
            MXMLCompilationUnit rootMXMLCompilationUnit = (MXMLCompilationUnit)rootCompilationUnit;
            MXMLFileNode mxmlFileNode = (MXMLFileNode)rootMXMLCompilationUnit.getSyntaxTreeRequest().get().getAST();
            CSSSemanticAnalyzer.validate(builtCompilationUnits, mxmlFileNode.getCSSCompilationSession(), problems);
        }

        @Override
        protected void createFrames(SWFTarget swfTarget, ISWF swf, ImmutableSet<ICompilationUnit> builtCompilationUnits, Set<ICompilationUnit> emittedCompilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
            FlexDelegate delegate = RoyaleAppSWFTarget.this.getDelegate();
            ClassDefinition rootClassDefinition = RoyaleAppSWFTarget.this.getRootClassDefinition();
            this.frame1Info = new RoyaleApplicationFrame1Info(RoyaleAppSWFTarget.this.royaleProject, RoyaleAppSWFTarget.this.targetSettings, rootClassDefinition, delegate.getGenerateSystemManagerAndFlexInit(), delegate.isFlexInfo(rootClassDefinition), builtCompilationUnits);
            SWFFrame applicationSWFFrame = null;
            for (SWFTarget.SWFFrameInfo frameInfo : this.frameInfos) {
                SWFFrame swfFrame = this.createFrame(swfTarget, frameInfo, builtCompilationUnits, emittedCompilationUnits, problems);
                if (frameInfo == this.systemManagerFrame) {
                    assert (delegate.getGenerateSystemManagerAndFlexInit()) : "systemManagerFrame should be null, unless we are generating a system manager.";
                    delegate.addGeneratedSystemManagerToFrame(swfFrame, this.frame1Info, this.initialFactoryClass, builtCompilationUnits, problems);
                } else if (frameInfo == this.applicationFrame) {
                    delegate.addGeneratedCodeToMainApplicationFrame(swfFrame, this.frame1Info, emittedCompilationUnits, problems);
                    applicationSWFFrame = swfFrame;
                }
                swf.addFrame(swfFrame);
            }
            if (delegate.getGenerateSystemManagerAndFlexInit()) {
                String generatedSystemManager = delegate.getGeneratedSystemManagerClassName(this.initialFactoryClass);
                swf.setTopLevelClass(generatedSystemManager);
                this.validateRootCompiltionUnitCSS(builtCompilationUnits, problems);
            } else {
                swf.setTopLevelClass(rootClassDefinition.getQualifiedName());
                if (RoyaleAppSWFTarget.this.hasRSLs()) {
                    ICompilationUnit rootCompilationUnit = RoyaleAppSWFTarget.this.getRootClassCompilationUnit();
                    RoyaleAppSWFTarget.this.reportProblem(new MissingFactoryClassInFrameMetadataProblem(rootCompilationUnit.getAbsoluteFilename()));
                }
            }
            assert (applicationSWFFrame != null);
            Sets.SetView remainingCompilationUnitsToEmit = Sets.difference(builtCompilationUnits, emittedCompilationUnits);
            if (!remainingCompilationUnitsToEmit.isEmpty()) {
                RoyaleAppSWFTarget.this.addCompilationUnitsAndDependenciesToFrame(applicationSWFFrame, (Collection<ICompilationUnit>)remainingCompilationUnitsToEmit, true, emittedCompilationUnits);
            }
        }
    }
}

