/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IQualifiers;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceAccessExpressionNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.IScopedNode;

public class NamespaceIdentifierNode
extends IdentifierNode
implements INamespaceDecorationNode {
    private IDefinitionNode decoratedDefinitionNode = null;
    private boolean isConfig;

    public NamespaceIdentifierNode(IASToken t) {
        super(t.getText());
        this.span(t);
    }

    public NamespaceIdentifierNode(String text) {
        super(text);
    }

    public NamespaceIdentifierNode(IdentifierNode node) {
        super(node.getName());
        this.span(node.getAbsoluteStart(), node.getAbsoluteEnd(), node.getLine(), node.getColumn(), node.getEndLine(), node.getEndColumn());
        this.setSourcePath(node.getSourcePath());
    }

    protected NamespaceIdentifierNode(NamespaceIdentifierNode other) {
        super(other);
        this.isConfig = other.isConfig;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.NamespaceIdentifierID;
    }

    @Override
    public IASNode getParent() {
        if (this.parent == null && this.decoratedDefinitionNode != null) {
            return this.decoratedDefinitionNode.getParent();
        }
        return super.getParent();
    }

    @Override
    public IDefinition resolve(ICompilerProject project) {
        boolean resolveToConcreteNs = true;
        return this.resolve(project, resolveToConcreteNs);
    }

    @Override
    protected NamespaceIdentifierNode copy() {
        return new NamespaceIdentifierNode(this);
    }

    @Override
    public IScopedNode getScopeNode() {
        return (IScopedNode)this.getAncestorOfType(IScopedNode.class);
    }

    @Override
    public ExpressionNodeBase getDecorationNode() {
        return this;
    }

    @Override
    public Name getMName(ICompilerProject project) {
        if (this.isBuiltinNamespaceIdentifier()) {
            return null;
        }
        IDefinition def = this.resolve(project, false);
        if (this.canEarlyBind(project, def)) {
            return ((DefinitionBase)def).getMName(project);
        }
        return super.getMName(project);
    }

    @Override
    public IDefinitionNode getDecoratedDefinitionNode() {
        return this.decoratedDefinitionNode;
    }

    @Override
    public INamespaceDecorationNode.NamespaceDecorationKind getNamespaceDecorationKind() {
        return this.isConfig ? INamespaceDecorationNode.NamespaceDecorationKind.CONFIG : INamespaceDecorationNode.NamespaceDecorationKind.NAME;
    }

    public void setIsConfigNamespace(boolean isConfig) {
        this.isConfig = isConfig;
    }

    public void setDecorationTarget(IDefinitionNode decoratingParent) {
        this.decoratedDefinitionNode = decoratingParent;
    }

    private IDefinition resolve(ICompilerProject project, boolean resolveToConcreteNs) {
        if (this.isBuiltinNamespaceIdentifier()) {
            ASScope scope = this.getASScope();
            INamespaceReference nsRef = NamespaceDefinition.createNamespaceReference(scope, this);
            return nsRef != null ? nsRef.resolveNamespaceReference(project) : null;
        }
        IDefinition d = super.resolve(project);
        if (resolveToConcreteNs && d instanceof NamespaceDefinition.INamepaceDeclarationDirective) {
            d = ((NamespaceDefinition.INamepaceDeclarationDirective)d).resolveConcreteDefinition(project);
        } else if (d instanceof InterfaceDefinition) {
            d = ((InterfaceDefinition)d).getInterfaceNamespaceReference();
        }
        return d;
    }

    public IQualifiers resolveQualifier(ICompilerProject project) {
        IDefinition d;
        ASScope scope;
        IQualifiers result = null;
        if (this.isBuiltinNamespaceIdentifier() && NamespaceDefinition.qualifierCouldBeManyNamespaces(scope = this.getASScope(), this)) {
            Collection<INamespaceReference> nsrefs = NamespaceDefinition.createNamespaceReferencesForQualifier(scope, this);
            HashSet<INamespaceDefinition> namespaces = new HashSet<INamespaceDefinition>(nsrefs.size());
            for (INamespaceReference ns : nsrefs) {
                namespaces.add(ns.resolveNamespaceReference(project));
            }
            result = new MultiNamespaceQualifiers(namespaces);
        }
        if (result == null && (d = this.resolve(project)) instanceof IQualifiers) {
            result = (IQualifiers)((Object)d);
        }
        return result;
    }

    private boolean isBuiltinNamespaceIdentifier() {
        String name = this.getName();
        return name == "public" || name == "private" || name == "protected" || name == "internal" || name == "*";
    }

    @Override
    public boolean isExpressionQualifier() {
        IASNode p = this.getParent();
        if (p instanceof NamespaceAccessExpressionNode) {
            return ((NamespaceAccessExpressionNode)p).getLeftOperandNode() == this;
        }
        return false;
    }

    private static class MultiNamespaceQualifiers
    implements IQualifiers {
        private Set<INamespaceDefinition> namespaces;

        MultiNamespaceQualifiers(Set<INamespaceDefinition> namespaces) {
            this.namespaces = ImmutableSet.copyOf(namespaces);
        }

        @Override
        public int getNamespaceCount() {
            return this.namespaces.size();
        }

        @Override
        public Set<INamespaceDefinition> getNamespaceSet() {
            return this.namespaces;
        }

        @Override
        public INamespaceDefinition getFirst() {
            return this.namespaces.iterator().next();
        }
    }
}

