/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.ProcessClosurePrimitivesWithModuleSupport;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.JSType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class CollapsePropertiesWithModuleSupport
implements CompilerPass {
    static final DiagnosticType UNSAFE_NAMESPACE_WARNING = DiagnosticType.warning((String)"JSC_UNSAFE_NAMESPACE", (String)"incomplete alias created for namespace {0}");
    static final DiagnosticType NAMESPACE_REDEFINED_WARNING = DiagnosticType.warning((String)"JSC_NAMESPACE_REDEFINED", (String)"namespace {0} should not be redefined");
    static final DiagnosticType UNSAFE_THIS = DiagnosticType.warning((String)"JSC_UNSAFE_THIS", (String)"dangerous use of ''this'' in static method {0}");
    private final AbstractCompiler compiler;
    private final CompilerOptions.PropertyCollapseLevel propertyCollapseLevel;
    private List<GlobalNamespace.Name> globalNames;
    private Map<String, GlobalNamespace.Name> nameMap;
    private String sourceFileName;
    private File varRenameMapFile;
    private ArrayList<String> renamedVars = null;
    private List<String> externAliases;
    private List<String> providedAliases = new ArrayList<String>();
    private List<String> providedNamespaces = new ArrayList<String>();

    CollapsePropertiesWithModuleSupport(AbstractCompiler compiler, CompilerOptions.PropertyCollapseLevel propertyCollapseLevel, String sourceFileName, File varRenameMapFile) {
        this.compiler = compiler;
        this.propertyCollapseLevel = propertyCollapseLevel;
        this.varRenameMapFile = varRenameMapFile;
        this.sourceFileName = sourceFileName;
    }

    public void process(Node externs, Node root) {
        String t;
        String s;
        int i;
        this.externAliases = ProcessClosurePrimitivesWithModuleSupport.externedAliases.get(externs);
        int n = this.externAliases.size();
        for (i = 0; i < n; ++i) {
            s = this.externAliases.get(i);
            t = s.replace(".", "$");
            this.externAliases.set(i, t);
        }
        this.providedAliases = ProcessClosurePrimitivesWithModuleSupport.providedsMap.get(externs);
        this.providedNamespaces.addAll(this.providedAliases);
        n = this.providedAliases.size();
        for (i = 0; i < n; ++i) {
            s = this.providedAliases.get(i);
            t = s.replace(".", "$");
            this.providedAliases.set(i, t);
        }
        GlobalNamespace namespace = new GlobalNamespace(this.compiler, externs, root);
        this.nameMap = namespace.getNameIndex();
        this.globalNames = namespace.getNameForest();
        this.checkNamespaces();
        for (GlobalNamespace.Name name : this.globalNames) {
            this.flattenReferencesToCollapsibleDescendantNames(name, name.getBaseName());
        }
        for (GlobalNamespace.Name name : this.globalNames) {
            this.collapseDeclarationOfNameAndDescendants(name, name.getBaseName());
        }
        new Normalize.PropagateConstantAnnotationsOverVars(this.compiler, false).process(externs, root);
    }

    private boolean canCollapse(GlobalNamespace.Name name) {
        if (!name.canCollapse()) {
            return false;
        }
        return this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT || name.isModuleExport();
    }

    private boolean canEliminate(GlobalNamespace.Name name) {
        if (!name.canEliminate()) {
            return false;
        }
        return name.props == null || name.props.isEmpty() || this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT;
    }

    private void checkNamespaces() {
        for (GlobalNamespace.Name name : this.nameMap.values()) {
            if (!name.isNamespaceObjectLit() || name.getAliasingGets() <= 0 && name.getLocalSets() + name.getGlobalSets() <= 1 && name.getDeleteProps() <= 0) continue;
            boolean initialized = name.getDeclaration() != null;
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (ref == name.getDeclaration()) continue;
                if (ref.type == GlobalNamespace.Ref.Type.DELETE_PROP) {
                    if (!initialized) continue;
                    this.warnAboutNamespaceRedefinition(name, ref);
                    continue;
                }
                if (ref.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL || ref.type == GlobalNamespace.Ref.Type.SET_FROM_LOCAL) {
                    if (initialized && !CollapsePropertiesWithModuleSupport.isSafeNamespaceReinit(ref) && !this.providedNamespaces.contains(name.getFullName())) {
                        this.warnAboutNamespaceRedefinition(name, ref);
                    }
                    initialized = true;
                    continue;
                }
                if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET || this.providedNamespaces.contains(name.getFullName()) || ref.name.inExterns()) continue;
                this.warnAboutNamespaceAliasing(name, ref);
            }
        }
    }

    static boolean isSafeNamespaceReinit(GlobalNamespace.Ref ref) {
        Node maybeName;
        Node valParent = CollapsePropertiesWithModuleSupport.getValueParent(ref);
        Node val = valParent.getLastChild();
        return val != null && val.isOr() && ref.node.matchesQualifiedName(maybeName = val.getFirstChild());
    }

    private static Node getValueParent(GlobalNamespace.Ref ref) {
        Node n = ref.node.getParent();
        return n != null && NodeUtil.isNameDeclaration((Node)n) ? ref.node : ref.node.getParent();
    }

    private void warnAboutNamespaceAliasing(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make((Node)ref.node, (DiagnosticType)UNSAFE_NAMESPACE_WARNING, (String[])new String[]{nameObj.getFullName()}));
    }

    private void warnAboutNamespaceRedefinition(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make((Node)ref.node, (DiagnosticType)NAMESPACE_REDEFINED_WARNING, (String[])new String[]{nameObj.getFullName()}));
    }

    private void flattenReferencesToCollapsibleDescendantNames(GlobalNamespace.Name n, String alias) {
        if (n.props == null || n.isCollapsingExplicitlyDenied()) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            boolean isAllowedToCollapse;
            String propAlias = this.appendPropForAlias(alias, p.getBaseName());
            boolean bl = isAllowedToCollapse = this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT || p.isModuleExport();
            if (isAllowedToCollapse && (p.canCollapse() || this.wasCollapsed(propAlias) || this.shouldCollapse(propAlias))) {
                this.flattenReferencesTo(p, propAlias);
            } else if (isAllowedToCollapse && p.isSimpleStubDeclaration() && !p.isCollapsingExplicitlyDenied()) {
                this.flattenSimpleStubDeclaration(p, propAlias);
            }
            this.flattenReferencesToCollapsibleDescendantNames(p, propAlias);
        }
    }

    private boolean shouldCollapse(String propAlias) {
        if (this.providedAliases.contains(propAlias)) {
            InputId inputId = new InputId(this.sourceFileName);
            CompilerInput compilerInput = this.compiler.getInput(inputId);
            Node nameNode = IR.name((String)propAlias);
            Node child = IR.var((Node)nameNode);
            compilerInput.getAstRoot(this.compiler).addChildToBack(child);
            this.compiler.reportChangeToEnclosingScope(child);
            if (!this.externAliases.contains(propAlias)) {
                this.externAliases.add(propAlias);
            }
            return true;
        }
        return false;
    }

    private boolean wasCollapsed(String propAlias) {
        if (this.varRenameMapFile == null) {
            return false;
        }
        if (this.renamedVars == null) {
            this.renamedVars = new ArrayList();
            try {
                List<String> fileLines = Files.readLines(this.varRenameMapFile, Charset.defaultCharset());
                for (String line : fileLines) {
                    int c = line.indexOf(":");
                    if (c <= 0) continue;
                    this.renamedVars.add(line.substring(0, c));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.renamedVars.contains(propAlias) || this.externAliases.contains(propAlias)) {
            InputId inputId = new InputId(this.sourceFileName);
            CompilerInput compilerInput = this.compiler.getInput(inputId);
            Node nameNode = IR.name((String)propAlias);
            Node child = IR.var((Node)nameNode);
            compilerInput.getAstRoot(this.compiler).addChildToBack(child);
            this.compiler.reportChangeToEnclosingScope(child);
            if (!this.externAliases.contains(propAlias)) {
                this.externAliases.add(propAlias);
            }
            return true;
        }
        return false;
    }

    private void flattenSimpleStubDeclaration(GlobalNamespace.Name name, String alias) {
        GlobalNamespace.Ref ref = (GlobalNamespace.Ref)Iterables.getOnlyElement(name.getRefs());
        Node nameNode = NodeUtil.newName((AbstractCompiler)this.compiler, (String)alias, (Node)ref.node, (String)name.getFullName());
        Node varNode = IR.var((Node)nameNode).useSourceInfoIfMissingFrom(nameNode);
        Preconditions.checkState(ref.node.getParent().isExprResult());
        Node parent = ref.node.getParent();
        Node grandparent = parent.getParent();
        grandparent.replaceChild(parent, varNode);
        this.compiler.reportChangeToEnclosingScope(varNode);
    }

    private void flattenReferencesTo(GlobalNamespace.Name n, String alias) {
        String originalName = n.getFullName();
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == n.getDeclaration()) continue;
            Node rParent = r.node.getParent();
            if (r.node.isFromExterns() || NodeUtil.isObjectLitKey((Node)r.node) || r.getTwin() != null && !r.isSet()) continue;
            this.flattenNameRef(alias, r.node, rParent, originalName);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, 1);
            }
        }
    }

    private void flattenPrefixes(String alias, GlobalNamespace.Name n, int depth) {
        String originalName = n.getFullName();
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl != null && decl.node != null && !decl.node.isFromExterns() && decl.node.isGetProp()) {
            this.flattenNameRefAtDepth(alias, decl.node, depth, originalName);
        }
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == decl || r.getTwin() != null && !r.isSet() || r.node == null || r.node.isFromExterns()) continue;
            this.flattenNameRefAtDepth(alias, r.node, depth, originalName);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, depth + 1);
            }
        }
    }

    private void flattenNameRefAtDepth(String alias, Node n, int depth, String originalName) {
        Token nType = n.getToken();
        boolean isQName = nType == Token.NAME || nType == Token.GETPROP;
        boolean isObjKey = NodeUtil.isObjectLitKey((Node)n);
        Preconditions.checkState(isObjKey || isQName);
        if (isQName) {
            for (int i = 1; i < depth && n.hasChildren(); ++i) {
                n = n.getFirstChild();
            }
            if (n.isGetProp() && n.getFirstChild().isGetProp()) {
                this.flattenNameRef(alias, n.getFirstChild(), n, originalName);
            }
        }
    }

    private void flattenNameRef(String alias, Node n, Node parent, String originalName) {
        JSType type;
        Preconditions.checkArgument(n.isGetProp(), "Expected GETPROP, found %s. Node: %s", (Object)n.getToken(), (Object)n);
        Node ref = NodeUtil.newName((AbstractCompiler)this.compiler, (String)alias, (Node)n, (String)originalName);
        NodeUtil.copyNameAnnotations((Node)n.getLastChild(), (Node)ref);
        if (parent != null && parent.isCall() && n == parent.getFirstChild()) {
            parent.putBooleanProp(Node.FREE_CALL, true);
        }
        if ((type = n.getJSType()) != null) {
            ref.setJSType(type);
        }
        if (parent == null) {
            parent = n;
            n = n.getFirstChild();
            parent.replaceChild(n, ref);
        } else {
            parent.replaceChild(n, ref);
            Node enclosingScopeNode = NodeUtil.getEnclosingChangeScopeRoot((Node)n.getParent());
            if (enclosingScopeNode != null) {
                this.compiler.reportChangeToEnclosingScope(ref);
            }
        }
    }

    private void collapseDeclarationOfNameAndDescendants(GlobalNamespace.Name n, String alias) {
        boolean canCollapseChildNames = n.canCollapseUnannotatedChildNames();
        if (this.canCollapse(n)) {
            this.updateGlobalNameDeclaration(n, alias, canCollapseChildNames);
        }
        if (n.props == null) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            this.collapseDeclarationOfNameAndDescendants(p, this.appendPropForAlias(alias, p.getBaseName()));
        }
    }

    private void updateTwinnedDeclaration(String alias, GlobalNamespace.Name refName, GlobalNamespace.Ref ref) {
        Preconditions.checkNotNull(ref.getTwin());
        if (!ref.node.isGetProp()) {
            return;
        }
        Node rvalue = ref.node.getNext();
        Node parent = ref.node.getParent();
        Node grandparent = parent.getParent();
        if (rvalue != null && rvalue.isFunction()) {
            this.checkForHosedThisReferences(rvalue, refName.docInfo, refName);
        }
        Node nameNode = NodeUtil.newName((AbstractCompiler)this.compiler, (String)alias, (Node)grandparent.getFirstChild(), (String)refName.getFullName());
        NodeUtil.copyNameAnnotations((Node)ref.node.getLastChild(), (Node)nameNode);
        Node current = grandparent;
        Node currentParent = grandparent.getParent();
        while (!currentParent.isScript() && !currentParent.isBlock()) {
            current = currentParent;
            currentParent = currentParent.getParent();
        }
        Node stubVar = IR.var((Node)nameNode.cloneTree()).useSourceInfoIfMissingFrom(nameNode);
        currentParent.addChildBefore(stubVar, current);
        parent.replaceChild(ref.node, nameNode);
        this.compiler.reportChangeToEnclosingScope(nameNode);
    }

    private void updateGlobalNameDeclaration(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl == null) {
            return;
        }
        if (decl.node == null) {
            return;
        }
        switch (decl.node.getParent().getToken()) {
            case ASSIGN: {
                this.updateGlobalNameDeclarationAtAssignNode(n, alias, canCollapseChildNames);
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                this.updateGlobalNameDeclarationAtVariableNode(n, canCollapseChildNames);
                break;
            }
            case FUNCTION: {
                this.updateGlobalNameDeclarationAtFunctionNode(n, canCollapseChildNames);
                break;
            }
            case CLASS: {
                this.updateGlobalNameDeclarationAtClassNode(n, canCollapseChildNames);
                break;
            }
        }
    }

    private void updateGlobalNameDeclarationAtAssignNode(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref ref = n.getDeclaration();
        Node rvalue = ref.node.getNext();
        if (ref.getTwin() != null) {
            this.updateTwinnedDeclaration(alias, ref.name, ref);
            return;
        }
        Node varNode = new Node(Token.VAR);
        Node varParent = ref.node.getAncestor(3);
        Node grandparent = ref.node.getAncestor(2);
        boolean isObjLit = rvalue.isObjectLit();
        boolean insertedVarNode = false;
        if (isObjLit && this.canEliminate(n)) {
            varParent.replaceChild(grandparent, varNode);
            ref.node = null;
            insertedVarNode = true;
            this.compiler.reportChangeToEnclosingScope(varNode);
        } else if (!n.isSimpleName()) {
            if (rvalue.isFunction()) {
                this.checkForHosedThisReferences(rvalue, n.docInfo, n);
            }
            this.compiler.reportChangeToEnclosingScope(rvalue);
            ref.node.getParent().removeChild(rvalue);
            Node nameNode = NodeUtil.newName((AbstractCompiler)this.compiler, (String)alias, (Node)ref.node.getAncestor(2), (String)n.getFullName());
            JSDocInfo info = NodeUtil.getBestJSDocInfo((Node)ref.node.getParent());
            if (ref.node.getLastChild().getBooleanProp(Node.IS_CONSTANT_NAME) || info != null && info.isConstant()) {
                nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            }
            if (info != null) {
                varNode.setJSDocInfo(info);
            }
            varNode.addChildToBack(nameNode);
            nameNode.addChildToFront(rvalue);
            varParent.replaceChild(grandparent, varNode);
            ref.node = nameNode;
            insertedVarNode = true;
            this.compiler.reportChangeToEnclosingScope(varNode);
        }
        if (canCollapseChildNames) {
            if (isObjLit) {
                this.declareVariablesForObjLitValues(n, alias, rvalue, varNode, varNode.getPrevious(), varParent);
            }
            this.addStubsForUndeclaredProperties(n, alias, varParent, varNode);
        }
        if (insertedVarNode && !varNode.hasChildren()) {
            varParent.removeChild(varNode);
        }
    }

    private void checkForHosedThisReferences(Node function, JSDocInfo docInfo, final GlobalNamespace.Name name) {
        boolean isAllowedToReferenceThis;
        boolean bl = isAllowedToReferenceThis = docInfo != null && (docInfo.isConstructorOrInterface() || docInfo.hasThisType()) || function.isArrowFunction();
        if (!isAllowedToReferenceThis) {
            NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)function.getLastChild(), (NodeTraversal.Callback)new NodeTraversal.AbstractShallowCallback(){

                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isThis()) {
                        CollapsePropertiesWithModuleSupport.this.compiler.report(JSError.make((Node)n, (DiagnosticType)UNSAFE_THIS, (String[])new String[]{name.getFullName()}));
                    }
                }
            });
        }
    }

    private void updateGlobalNameDeclarationAtVariableNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String name = ref.node.getString();
        Node rvalue = ref.node.getFirstChild();
        Node variableNode = ref.node.getParent();
        Node grandparent = variableNode.getParent();
        boolean isObjLit = rvalue.isObjectLit();
        if (isObjLit) {
            this.declareVariablesForObjLitValues(n, name, rvalue, variableNode, variableNode.getPrevious(), grandparent);
        }
        this.addStubsForUndeclaredProperties(n, name, grandparent, variableNode);
        if (isObjLit && this.canEliminate(n)) {
            variableNode.removeChild(ref.node);
            this.compiler.reportChangeToEnclosingScope(variableNode);
            if (!variableNode.hasChildren()) {
                grandparent.removeChild(variableNode);
            }
            ref.node = null;
        }
    }

    private void updateGlobalNameDeclarationAtFunctionNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames || !this.canCollapse(n)) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String fnName = ref.node.getString();
        this.addStubsForUndeclaredProperties(n, fnName, ref.node.getAncestor(2), ref.node.getParent());
    }

    private void updateGlobalNameDeclarationAtClassNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames || !this.canCollapse(n)) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String className = ref.node.getString();
        this.addStubsForUndeclaredProperties(n, className, ref.node.getAncestor(2), ref.node.getParent());
    }

    private void declareVariablesForObjLitValues(GlobalNamespace.Name objlitName, String alias, Node objlit, Node varNode, Node nameToAddAfter, Node varParent) {
        int arbitraryNameCounter = 0;
        boolean discardKeys = !objlitName.shouldKeepKeys();
        Node key = objlit.getFirstChild();
        while (key != null) {
            Node value = key.getFirstChild();
            Node nextKey = key.getNext();
            if (!(key.isGetterDef() || key.isSetterDef() || key.isComputedProp())) {
                boolean isJsIdentifier = !key.isNumber() && TokenStream.isJSIdentifier((String)key.getString());
                String propName = isJsIdentifier ? key.getString() : String.valueOf(++arbitraryNameCounter);
                String qName = objlitName.getFullName() + "." + propName;
                GlobalNamespace.Name p = this.nameMap.get(qName);
                if (p == null || this.canCollapse(p)) {
                    String propAlias = this.appendPropForAlias(alias, propName);
                    Node refNode = null;
                    if (discardKeys) {
                        objlit.removeChild(key);
                        value.detach();
                    } else {
                        refNode = IR.name((String)propAlias);
                        if (key.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                            refNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                        }
                        key.replaceChild(value, refNode);
                        this.compiler.reportChangeToEnclosingScope(refNode);
                    }
                    Node nameNode = IR.name((String)propAlias);
                    nameNode.addChildToFront(value);
                    if (key.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                        nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                    }
                    Node newVar = IR.var((Node)nameNode).useSourceInfoIfMissingFromForTree(key);
                    if (nameToAddAfter != null) {
                        varParent.addChildAfter(newVar, nameToAddAfter);
                    } else {
                        varParent.addChildBefore(newVar, varNode);
                    }
                    this.compiler.reportChangeToEnclosingScope(newVar);
                    nameToAddAfter = newVar;
                    if (isJsIdentifier && p != null) {
                        if (!discardKeys) {
                            GlobalNamespace.Ref newAlias = p.getDeclaration().cloneAndReclassify(GlobalNamespace.Ref.Type.ALIASING_GET);
                            newAlias.node = refNode;
                            p.addRef(newAlias);
                        }
                        p.getDeclaration().node = nameNode;
                        if (value.isFunction()) {
                            this.checkForHosedThisReferences(value, key.getJSDocInfo(), p);
                        }
                    }
                }
            }
            key = nextKey;
        }
    }

    private void addStubsForUndeclaredProperties(GlobalNamespace.Name n, String alias, Node parent, Node addAfter) {
        Preconditions.checkState(n.canCollapseUnannotatedChildNames(), n);
        Preconditions.checkArgument(NodeUtil.isStatementBlock((Node)parent), parent);
        Preconditions.checkNotNull(addAfter);
        if (n.props == null) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            if (!p.needsToBeStubbed()) continue;
            String propAlias = this.appendPropForAlias(alias, p.getBaseName());
            Node nameNode = IR.name((String)propAlias);
            Node newVar = IR.var((Node)nameNode).useSourceInfoIfMissingFromForTree(addAfter);
            parent.addChildAfter(newVar, addAfter);
            addAfter = newVar;
            this.compiler.reportChangeToEnclosingScope(newVar);
            if (!((GlobalNamespace.Ref)p.getRefs().get((int)0)).node.getLastChild().getBooleanProp(Node.IS_CONSTANT_NAME)) continue;
            nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            this.compiler.reportChangeToEnclosingScope(nameNode);
        }
    }

    private String appendPropForAlias(String root, String prop) {
        if (prop.indexOf(36) != -1) {
            prop = prop.replace("$", "$0");
        }
        String result = root + "$" + prop;
        int id = 1;
        while (this.nameMap.containsKey(result)) {
            result = root + "$" + prop + "$" + id;
            ++id;
        }
        return result;
    }
}

