/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.Collection;
import org.apache.royale.compiler.internal.fxg.dom.AbstractFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class GradientEntryNode
extends AbstractFXGNode {
    private static final double RATIO_MIN_INCLUSIVE = 0.0;
    private static final double RATIO_MAX_INCLUSIVE = 1.0;
    public int color = -16777216;
    public double alpha = 1.0;
    public double ratio = Double.NaN;

    @Override
    public String getNodeName() {
        return "GradientEntry";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name, this.color, problems);
        } else if ("alpha".equals(name)) {
            this.alpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.alpha, problems);
        } else if ("ratio".equals(name)) {
            this.ratio = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.ratio, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }
}

