/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.common;

import org.apache.royale.compiler.common.IImportTarget;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.workspaces.IWorkspace;

public class ASImportTarget
implements IImportTarget {
    private final INamespaceDefinition.ILanguageNamespaceDefinition importedPublicPackageNamespace;
    private final String definitionName;

    public static ASImportTarget get(IWorkspace w, String target) {
        String packageName = null;
        String definitionName = null;
        int lastDotIndex = target.lastIndexOf(46);
        if (lastDotIndex == -1) {
            packageName = "";
            if (!target.equals("*")) {
                definitionName = target;
            }
        } else {
            packageName = target.substring(0, lastDotIndex);
            String afterLastDot = target.substring(lastDotIndex + 1);
            if (!afterLastDot.equals("*")) {
                definitionName = afterLastDot;
            }
        }
        Workspace workspace = (Workspace)w;
        INamespaceDefinition.ILanguageNamespaceDefinition packagePublicNamespace = workspace.getPackageNamespaceDefinitionCache().get(packageName, false);
        return new ASImportTarget(packagePublicNamespace, definitionName);
    }

    public static IImportTarget buildImportFromXMLNamespace(IWorkspace w, String xmlNamespace) {
        String directory = xmlNamespace;
        if (xmlNamespace != null && xmlNamespace.endsWith("*") && (directory = directory.substring(0, directory.length() - 1)).indexOf("/") == -1 && directory.indexOf(":") == -1) {
            return ASImportTarget.get(w, xmlNamespace);
        }
        return null;
    }

    public static IImportTarget buildImportFromPackageName(IWorkspace w, String packageName) {
        if (packageName == null || packageName.length() == 1 && packageName.charAt(0) == '*' || packageName.length() == 0) {
            packageName = "";
        }
        Workspace workspace = (Workspace)w;
        INamespaceDefinition.ILanguageNamespaceDefinition packagePublicNamespace = workspace.getPackageNamespaceDefinitionCache().get(packageName, false);
        return new ASImportTarget(packagePublicNamespace, null);
    }

    private ASImportTarget(INamespaceDefinition.ILanguageNamespaceDefinition namespace, String definitionName) {
        this.importedPublicPackageNamespace = namespace;
        this.definitionName = definitionName;
    }

    @Override
    public String getTargetPackage() {
        return this.importedPublicPackageNamespace.getURI();
    }

    @Override
    public boolean isWildcard() {
        return this.definitionName == null;
    }

    @Override
    public String getTargetName() {
        return this.definitionName == null ? "" : this.definitionName;
    }

    @Override
    public String getQualifiedName(String reference) {
        int lastIndexOfDotInReferece = reference.lastIndexOf(46);
        if (lastIndexOfDotInReferece == -1) {
            if (this.definitionName == null || reference.equals(this.definitionName)) {
                StringBuilder builder = new StringBuilder();
                String uri = this.importedPublicPackageNamespace.getURI();
                if (uri != null && uri.length() > 0) {
                    builder.append(uri);
                    builder.append('.');
                }
                builder.append(reference);
                return builder.toString();
            }
            return null;
        }
        String packageNameInReference = reference.substring(0, lastIndexOfDotInReferece);
        if (!packageNameInReference.equals(this.importedPublicPackageNamespace.getURI())) {
            return null;
        }
        if (this.definitionName == null) {
            return reference;
        }
        String definitionNameInReference = reference.substring(lastIndexOfDotInReferece + 1);
        if (definitionNameInReference.equals(this.definitionName)) {
            return reference;
        }
        return null;
    }

    public String toString() {
        String packageName = this.importedPublicPackageNamespace.getURI();
        int definitionNameLen = this.definitionName == null ? 2 : this.definitionName.length();
        StringBuilder builder = new StringBuilder(packageName.length() + definitionNameLen);
        builder.append(packageName);
        builder.append('.');
        builder.append(this.definitionName == null ? "*" : this.definitionName);
        return builder.toString();
    }

    @Override
    public INamespaceDefinition getNamespace() {
        return this.importedPublicPackageNamespace;
    }
}

