/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.pass;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.AbstractCompilerPass;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;

public class AddMemberPass
extends AbstractCompilerPass {
    public AddMemberPass(ReferenceModel model, AbstractCompiler compiler) {
        super(model, compiler);
    }

    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return n.isRoot() || n.isNormalBlock() || n.isScript();
    }

    public void visit(NodeTraversal t, Node n, Node parent) {
        for (Node child : n.children()) {
            JSDocInfo jsDocInfo;
            Node first;
            if (!child.isExprResult() || (first = child.getFirstChild()).isVar() || first.isFunction()) continue;
            if (first.isAssign()) {
                if (!first.getFirstChild().isGetProp() || !first.getLastChild().isFunction()) continue;
                this.visitMethod(t, first);
                continue;
            }
            if (!first.isGetProp() || (jsDocInfo = first.getJSDocInfo()) != null && jsDocInfo.hasTypedefType()) continue;
            if (jsDocInfo != null && (jsDocInfo.getParameterCount() > 0 || jsDocInfo.getReturnType() != null)) {
                this.visitMethodFromJSDoc(t, first);
                continue;
            }
            this.visitGetProp(t, first);
        }
    }

    private void visitMethod(NodeTraversal t, Node n) {
        String qName = n.getFirstChild().getQualifiedName();
        if (n.getFirstChild().isGetProp()) {
            int protoType = qName.indexOf(".prototype.");
            if (protoType != -1) {
                String className = qName.substring(0, protoType);
                String memberName = qName.substring(protoType + 11, qName.length());
                this.model.addMethod(n, className, memberName);
            } else {
                String className = qName.substring(0, qName.lastIndexOf("."));
                String memberName = qName.substring(qName.lastIndexOf(".") + 1, qName.length());
                this.model.addStaticMethod(n, className, memberName);
            }
        } else if (n.getFirstChild().isName()) {
            this.err("visitMethod() non impl");
            this.log(n);
        }
    }

    private void visitMethodFromJSDoc(NodeTraversal t, Node n) {
        String qName = n.getQualifiedName();
        if (n.isGetProp()) {
            int protoType = qName.indexOf(".prototype.");
            if (protoType != -1) {
                String className = qName.substring(0, protoType);
                String memberName = qName.substring(protoType + 11, qName.length());
                this.model.addMethod(n, className, memberName);
            } else {
                String className = qName.substring(0, qName.lastIndexOf("."));
                String memberName = qName.substring(qName.lastIndexOf(".") + 1, qName.length());
                this.model.addStaticMethod(n, className, memberName);
            }
        } else if (n.isName()) {
            this.err("visitMethod() non impl");
            this.log(n);
        }
    }

    private void visitGetProp(NodeTraversal t, Node n) {
        String qualifiedName = n.getQualifiedName();
        this.log("visitGetProp [" + qualifiedName + "]");
        int protoType = qualifiedName.indexOf(".prototype.");
        if (protoType != -1) {
            String className = qualifiedName.substring(0, protoType);
            String memberName = qualifiedName.substring(protoType + 11, qualifiedName.length());
            this.model.addField(n, className, memberName);
        } else {
            String className = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            String memberName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1, qualifiedName.length());
            this.model.addStaticField(n, className, memberName);
        }
    }
}

