/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.emit;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.jstype.JSType;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.BaseReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ConstantReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.FunctionReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;

public class ReferenceEmitter {
    private ReferenceModel model;

    public ReferenceEmitter(ReferenceModel model) {
        this.model = model;
    }

    public void emit() throws IOException {
        File asRoot = this.model.getConfiguration().getAsRoot();
        if (!asRoot.exists()) {
            asRoot.mkdirs();
        }
        this.emitClasses();
        this.emitInterfaces();
        this.emitTypedefs();
        this.emitFunctions();
        this.emitConstants();
    }

    protected void emitInterfaces() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (ClassReference reference : this.model.getClasses()) {
            if (this.model.isExcludedClass(reference) != null || !reference.isInterface() || this.model.getConfiguration().isExternalTypedef(reference)) continue;
            this.emit(reference, sb);
            File sourceFile = reference.getFile(this.model.getConfiguration().getAsInterfaceRoot());
            if (sourceFile.exists()) {
                sourceFile = reference.getFile(this.model.getConfiguration().getAsDuplicatesRoot());
            }
            FileUtils.write((File)sourceFile, (CharSequence)sb.toString());
            sb.setLength(0);
        }
    }

    protected void emitClasses() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (ClassReference reference : this.model.getClasses()) {
            if (this.model.isExcludedClass(reference) != null || reference.isInterface() || this.model.getConfiguration().isExternalTypedef(reference)) continue;
            this.emit(reference, sb);
            File sourceFile = reference.getFile(this.model.getConfiguration().getAsClassRoot());
            if (sourceFile.exists()) {
                sourceFile = reference.getFile(this.model.getConfiguration().getAsDuplicatesRoot());
            }
            FileUtils.write((File)sourceFile, (CharSequence)sb.toString());
            sb.setLength(0);
        }
    }

    protected void emitTypedefs() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (ClassReference reference : this.model.getTypedefs()) {
            JSType typeDefJSType;
            JSDocInfo comment;
            if (this.model.isExcludedClass(reference) != null || this.model.getConfiguration().isExternalTypedef(reference) || (comment = reference.getComment()) != null && (typeDefJSType = this.model.evaluate(comment.getTypedefType())).isFunctionType()) continue;
            this.emit(reference, sb);
            File sourceFile = reference.getFile(this.model.getConfiguration().getAsTypeDefRoot());
            if (sourceFile.exists()) {
                sourceFile = reference.getFile(this.model.getConfiguration().getAsDuplicatesRoot());
            }
            FileUtils.write((File)sourceFile, (CharSequence)sb.toString());
            sb.setLength(0);
        }
    }

    protected void emitFunctions() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (FunctionReference reference : this.model.getFunctions()) {
            if (this.model.isExcludedClass(reference) != null || this.model.getConfiguration().isExternalTypedef(reference)) continue;
            this.emit(reference, sb);
            File sourceFile = reference.getFile(this.model.getConfiguration().getAsFunctionRoot());
            if (sourceFile.exists()) {
                sourceFile = reference.getFile(this.model.getConfiguration().getAsDuplicatesRoot());
            }
            FileUtils.write((File)sourceFile, (CharSequence)sb.toString());
            sb.setLength(0);
        }
    }

    protected void emitConstants() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (ConstantReference reference : this.model.getConstants()) {
            if (this.model.getConfiguration().isExternalTypedef(reference)) continue;
            this.emit(reference, sb);
            File sourceFile = reference.getFile(this.model.getConfiguration().getAsConstantRoot());
            if (sourceFile.exists()) {
                sourceFile = reference.getFile(this.model.getConfiguration().getAsDuplicatesRoot());
            }
            FileUtils.write((File)sourceFile, (CharSequence)sb.toString());
            sb.setLength(0);
        }
    }

    public void emit(BaseReference reference, StringBuilder sb) {
        reference.emit(sb);
    }

    public String emit(BaseReference reference) {
        StringBuilder sb = new StringBuilder();
        reference.emit(sb);
        return sb.toString();
    }
}

