/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.options.HttpHeader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class RawHeaders {
    private final List<HttpHeader> headersArray;
    private final Map<String, List<String>> headersMap = new LinkedHashMap<String, List<String>>();

    RawHeaders(List<HttpHeader> headers) {
        this.headersArray = headers;
        for (HttpHeader h : headers) {
            String name = h.name.toLowerCase();
            List<String> values = this.headersMap.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headersMap.put(name, values);
            }
            values.add(h.value);
        }
    }

    String get(String name) {
        List<String> values = this.getAll(name);
        if (values == null) {
            return null;
        }
        return String.join((CharSequence)("set-cookie".equals(name.toLowerCase()) ? "\n" : ", "), values);
    }

    List<String> getAll(String name) {
        return this.headersMap.get(name.toLowerCase());
    }

    Map<String, String> headers() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String name : this.headersMap.keySet()) {
            result.put(name, this.get(name));
        }
        return result;
    }

    List<HttpHeader> headersArray() {
        return this.headersArray;
    }
}

