/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;

public class UnknownType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private final boolean isChecked;

    UnknownType(JSTypeRegistry registry, boolean isChecked) {
        super(registry);
        this.isChecked = isChecked;
    }

    @Override
    public boolean isUnknownType() {
        return true;
    }

    @Override
    public boolean isCheckedUnknownType() {
        return this.isChecked;
    }

    @Override
    public boolean canBeCalled() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesSymbolContext() {
        return true;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        return TernaryValue.UNKNOWN;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isVoidable() {
        return true;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, null, JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        return true;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnknownType();
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseUnknownType(this, that);
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return sb.append(this.getReferenceName());
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return true;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public String getReferenceName() {
        return this.isChecked ? "??" : "?";
    }

    @Override
    public String getDisplayName() {
        return "Unknown";
    }

    @Override
    public boolean hasDisplayName() {
        return true;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        return this;
    }

    @Override
    int recursionUnsafeHashCode() {
        return System.identityHashCode(this);
    }
}

