/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Joiner;
import java.util.Arrays;

public class ModuleNames {
    static final String MODULE_SLASH = "/";
    private static final Joiner MODULE_JOINER = Joiner.on("/");

    private ModuleNames() {
    }

    public static String fileToModuleName(String path) {
        return ModuleNames.toModuleName(ModuleNames.escapePath(path));
    }

    public static String fileToJsIdentifier(String path) {
        return ModuleNames.toJSIdentifier(ModuleNames.escapePath(path));
    }

    static String escapePath(String input) {
        String encodedInput = input.replace(':', '-').replace('\\', '/').replace(" ", "%20").replace("[", "%5B").replace("]", "%5D").replace("<", "%3C").replace(">", "%3E");
        return ModuleNames.canonicalizePath(encodedInput);
    }

    static String toJSIdentifier(String path) {
        return ModuleNames.stripJsExtension(path).replaceFirst("^\\./", "").replace(MODULE_SLASH, "$").replace('\\', '$').replace('@', '$').replace('+', '$').replace('-', '_').replace(':', '_').replace('.', '_').replace("%20", "_");
    }

    static String toModuleName(String path) {
        if (path.startsWith(MODULE_SLASH)) {
            path = path.substring(1);
        }
        return "module$" + ModuleNames.toJSIdentifier(path);
    }

    private static String stripJsExtension(String fileName) {
        if (fileName.endsWith(".js") && (fileName = fileName.substring(0, fileName.length() - ".js".length())).endsWith(".js.i")) {
            fileName = fileName.substring(0, fileName.length() - ".js.i".length());
        }
        return fileName;
    }

    static String canonicalizePath(String path) {
        boolean absolutePath;
        String[] parts = path.split(MODULE_SLASH);
        String[] buffer = new String[parts.length];
        int position = 0;
        int available = 0;
        boolean bl = absolutePath = parts.length > 1 && parts[0].isEmpty();
        if (absolutePath) {
            --available;
        }
        for (String part : parts) {
            if (part.equals(".")) continue;
            if (part.equals("..")) {
                if (available > 0) {
                    --available;
                    buffer[--position] = null;
                    continue;
                }
                if (absolutePath) continue;
                buffer[position] = part;
                ++position;
                continue;
            }
            buffer[position] = part;
            ++position;
            ++available;
        }
        if (absolutePath && position == 1) {
            return MODULE_SLASH;
        }
        return MODULE_JOINER.join(Arrays.copyOf(buffer, position));
    }
}

