/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

final class PolymerClassDefinition {
    final DefinitionType defType;
    final Node definition;
    final Node target;
    final Node descriptor;
    final PolymerPass.MemberDefinition constructor;
    @Nullable
    final String nativeBaseElement;
    final List<PolymerPass.MemberDefinition> props;
    @Nullable
    final List<PolymerPass.MemberDefinition> methods;
    @Nullable
    final ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors;
    @Nullable
    final FeatureSet features;

    PolymerClassDefinition(DefinitionType defType, Node definition, Node target, Node descriptor, JSDocInfo classInfo, PolymerPass.MemberDefinition constructor, String nativeBaseElement, List<PolymerPass.MemberDefinition> props, List<PolymerPass.MemberDefinition> methods, ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors, FeatureSet features) {
        this.defType = defType;
        this.definition = definition;
        this.target = target;
        Preconditions.checkState(descriptor == null || descriptor.isObjectLit());
        this.descriptor = descriptor;
        this.constructor = constructor;
        this.nativeBaseElement = nativeBaseElement;
        this.props = props;
        this.methods = methods;
        this.behaviors = behaviors;
        this.features = features;
    }

    @Nullable
    static PolymerClassDefinition extractFromCallNode(Node callNode, AbstractCompiler compiler, GlobalNamespace globalNames) {
        Node target;
        Node descriptor = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (descriptor == null || !descriptor.isObjectLit()) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_DESCRIPTOR_NOT_VALID, new String[0]));
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount != 1) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node elName = NodeUtil.getFirstPropMatchingKey(descriptor, "is");
        if (elName == null) {
            compiler.report(JSError.make(callNode, PolymerPassErrors.POLYMER_MISSING_IS, new String[0]));
            return null;
        }
        if (NodeUtil.isNameDeclaration(callNode.getGrandparent())) {
            target = IR.name(callNode.getParent().getString());
        } else if (callNode.getParent().isAssign()) {
            target = callNode.getParent().getFirstChild().cloneTree();
        } else {
            String elNameStringBase = elName.isQualifiedName() ? elName.getQualifiedName().replace('.', '$') : elName.getString();
            String elNameString = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, elNameStringBase);
            elNameString = elNameString + "Element";
            target = IR.name(elNameString);
        }
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(target);
        JSDocInfo ctorInfo = null;
        Node constructor = NodeUtil.getFirstPropMatchingKey(descriptor, "factoryImpl");
        if (constructor == null) {
            constructor = NodeUtil.emptyFunction();
            compiler.reportChangeToChangeScope(constructor);
            constructor.useSourceInfoFromForTree(callNode);
        } else {
            ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
        }
        Node baseClass = NodeUtil.getFirstPropMatchingKey(descriptor, "extends");
        String nativeBaseElement = baseClass == null ? null : baseClass.getString();
        Node behaviorArray = NodeUtil.getFirstPropMatchingKey(descriptor, "behaviors");
        PolymerBehaviorExtractor behaviorExtractor = new PolymerBehaviorExtractor(compiler, globalNames);
        ImmutableList<PolymerBehaviorExtractor.BehaviorDefinition> behaviors = behaviorExtractor.extractBehaviors(behaviorArray);
        ArrayList<PolymerPass.MemberDefinition> allProperties = new ArrayList<PolymerPass.MemberDefinition>();
        for (PolymerBehaviorExtractor.BehaviorDefinition behavior : behaviors) {
            PolymerClassDefinition.overwriteMembersIfPresent(allProperties, behavior.props);
        }
        PolymerClassDefinition.overwriteMembersIfPresent(allProperties, PolymerPassStaticUtils.extractProperties(descriptor, DefinitionType.ObjectLiteral, compiler, null));
        FeatureSet newFeatures = null;
        if (!behaviors.isEmpty()) {
            newFeatures = ((PolymerBehaviorExtractor.BehaviorDefinition)behaviors.get((int)0)).features;
            for (int i = 1; i < behaviors.size(); ++i) {
                newFeatures = newFeatures.union(((PolymerBehaviorExtractor.BehaviorDefinition)behaviors.get((int)i)).features);
            }
        }
        ArrayList<PolymerPass.MemberDefinition> methods = new ArrayList<PolymerPass.MemberDefinition>();
        for (Node keyNode : descriptor.children()) {
            boolean isFunctionDefinition = keyNode.isMemberFunctionDef() || keyNode.isStringKey() && keyNode.getFirstChild().isFunction();
            if (!isFunctionDefinition) continue;
            methods.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return new PolymerClassDefinition(DefinitionType.ObjectLiteral, callNode, target, descriptor, classInfo, new PolymerPass.MemberDefinition(ctorInfo, null, constructor), nativeBaseElement, allProperties, methods, behaviors, newFeatures);
    }

    @Nullable
    static PolymerClassDefinition extractFromClassNode(Node classNode, AbstractCompiler compiler, GlobalNamespace globalNames) {
        Node target;
        Preconditions.checkState(classNode != null && classNode.isClass());
        Node propertiesDescriptor = null;
        Node propertiesGetter = NodeUtil.getFirstGetterMatchingKey(NodeUtil.getClassMembers(classNode), "properties");
        if (propertiesGetter != null) {
            if (!propertiesGetter.isStaticMember()) {
                compiler.report(JSError.make(classNode, PolymerPassErrors.POLYMER_CLASS_PROPERTIES_NOT_STATIC, new String[0]));
            } else {
                for (Node child : NodeUtil.getFunctionBody(propertiesGetter.getFirstChild()).children()) {
                    if (!child.isReturn()) continue;
                    if (child.hasChildren() && child.getFirstChild().isObjectLit()) {
                        propertiesDescriptor = child.getFirstChild();
                        break;
                    }
                    compiler.report(JSError.make(propertiesGetter, PolymerPassErrors.POLYMER_CLASS_PROPERTIES_INVALID, new String[0]));
                }
            }
        }
        if (NodeUtil.isNameDeclaration(classNode.getGrandparent())) {
            target = IR.name(classNode.getParent().getString());
        } else if (classNode.getParent().isAssign() && classNode.getParent().getFirstChild().isQualifiedName()) {
            target = classNode.getParent().getFirstChild();
        } else if (!classNode.getFirstChild().isEmpty()) {
            target = classNode.getFirstChild();
        } else {
            compiler.report(JSError.make(classNode, PolymerPassErrors.POLYMER_CLASS_UNNAMED, new String[0]));
            return null;
        }
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(classNode);
        JSDocInfo ctorInfo = null;
        Node constructor = NodeUtil.getFirstPropMatchingKey(NodeUtil.getClassMembers(classNode), "constructor");
        if (constructor != null) {
            ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
        }
        ImmutableList<PolymerPass.MemberDefinition> allProperties = PolymerPassStaticUtils.extractProperties(propertiesDescriptor, DefinitionType.ES6Class, compiler, constructor);
        ArrayList<PolymerPass.MemberDefinition> methods = new ArrayList<PolymerPass.MemberDefinition>();
        for (Node keyNode : NodeUtil.getClassMembers(classNode).children()) {
            if (!keyNode.isMemberFunctionDef()) continue;
            methods.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return new PolymerClassDefinition(DefinitionType.ES6Class, classNode, target, propertiesDescriptor, classInfo, new PolymerPass.MemberDefinition(ctorInfo, null, constructor), null, allProperties, methods, null, null);
    }

    private static void overwriteMembersIfPresent(List<PolymerPass.MemberDefinition> list, List<PolymerPass.MemberDefinition> newMembers) {
        for (PolymerPass.MemberDefinition newMember : newMembers) {
            for (PolymerPass.MemberDefinition member : list) {
                if (!member.name.getString().equals(newMember.name.getString())) continue;
                list.remove(member);
                break;
            }
            list.add(newMember);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("defType", (Object)this.defType).add("definition", this.definition).add("target", this.target).add("nativeBaseElement", this.nativeBaseElement).omitNullValues().toString();
    }

    static enum DefinitionType {
        ObjectLiteral,
        ES6Class;

    }
}

