/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.TernaryValue;

class PeepholeFoldConstants
extends AbstractPeepholeOptimization {
    static final DiagnosticType INVALID_GETELEM_INDEX_ERROR = DiagnosticType.warning("JSC_INVALID_GETELEM_INDEX_ERROR", "Array index not integer: {0}");
    static final DiagnosticType INDEX_OUT_OF_BOUNDS_ERROR = DiagnosticType.warning("JSC_INDEX_OUT_OF_BOUNDS_ERROR", "Array index out of bounds: {0}");
    static final DiagnosticType NEGATING_A_NON_NUMBER_ERROR = DiagnosticType.warning("JSC_NEGATING_A_NON_NUMBER_ERROR", "Can''t negate non-numeric value: {0}");
    static final DiagnosticType FRACTIONAL_BITWISE_OPERAND = DiagnosticType.warning("JSC_FRACTIONAL_BITWISE_OPERAND", "Fractional bitwise operand: {0}");
    private static final double MAX_FOLD_NUMBER = Math.pow(2.0, 53.0);
    private final boolean late;
    private final boolean shouldUseTypes;

    PeepholeFoldConstants(boolean late, boolean shouldUseTypes) {
        this.late = late;
        this.shouldUseTypes = shouldUseTypes;
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getToken()) {
            case CALL: {
                return this.tryFoldCall(subtree);
            }
            case NEW: {
                return this.tryFoldCtorCall(subtree);
            }
            case TYPEOF: {
                return this.tryFoldTypeof(subtree);
            }
            case NOT: 
            case POS: 
            case NEG: 
            case BITNOT: {
                this.tryReduceOperandsForOp(subtree);
                return this.tryFoldUnaryOperator(subtree);
            }
            case VOID: {
                return this.tryReduceVoid(subtree);
            }
        }
        this.tryReduceOperandsForOp(subtree);
        return this.tryFoldBinaryOperator(subtree);
    }

    private Node tryFoldBinaryOperator(Node subtree) {
        Node left = subtree.getFirstChild();
        if (left == null) {
            return subtree;
        }
        Node right = left.getNext();
        if (right == null) {
            return subtree;
        }
        switch (subtree.getToken()) {
            case GETPROP: {
                return this.tryFoldGetProp(subtree, left, right);
            }
            case GETELEM: {
                return this.tryFoldGetElem(subtree, left, right);
            }
            case INSTANCEOF: {
                return this.tryFoldInstanceof(subtree, left, right);
            }
            case AND: 
            case OR: {
                return this.tryFoldAndOr(subtree, left, right);
            }
            case LSH: 
            case RSH: 
            case URSH: {
                return this.tryFoldShift(subtree, left, right);
            }
            case ASSIGN: {
                return this.tryFoldAssign(subtree, left, right);
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                return this.tryUnfoldAssignOp(subtree, left, right);
            }
            case ADD: {
                return this.tryFoldAdd(subtree, left, right);
            }
            case SUB: 
            case DIV: 
            case MOD: 
            case EXPONENT: {
                return this.tryFoldArithmeticOp(subtree, left, right);
            }
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                Node result = this.tryFoldArithmeticOp(subtree, left, right);
                if (result != subtree) {
                    return result;
                }
                return this.tryFoldLeftChildOp(subtree, left, right);
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                return this.tryFoldComparison(subtree, left, right);
            }
        }
        return subtree;
    }

    private Node tryReduceVoid(Node n) {
        Node child = n.getFirstChild();
        if (!(child.isNumber() && child.getDouble() == 0.0 || this.mayHaveSideEffects(n))) {
            n.replaceChild(child, IR.number(0.0));
            this.compiler.reportChangeToEnclosingScope(n);
        }
        return n;
    }

    private void tryReduceOperandsForOp(Node n) {
        switch (n.getToken()) {
            case ADD: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                if (NodeUtil.mayBeString(left, this.shouldUseTypes) || NodeUtil.mayBeString(right, this.shouldUseTypes)) break;
                this.tryConvertOperandsToNumber(n);
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                this.tryConvertToNumber(n.getLastChild());
                break;
            }
            case POS: 
            case NEG: 
            case BITNOT: 
            case LSH: 
            case RSH: 
            case URSH: 
            case SUB: 
            case DIV: 
            case MOD: 
            case EXPONENT: 
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                this.tryConvertOperandsToNumber(n);
                break;
            }
        }
    }

    private void tryConvertOperandsToNumber(Node n) {
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            this.tryConvertToNumber(c);
            c = next;
        }
    }

    private void tryConvertToNumber(Node n) {
        switch (n.getToken()) {
            case NUMBER: {
                return;
            }
            case AND: 
            case OR: 
            case COMMA: {
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case HOOK: {
                this.tryConvertToNumber(n.getSecondChild());
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case NAME: {
                if (NodeUtil.isUndefined(n)) break;
                return;
            }
        }
        Double result = NodeUtil.getNumberValue(n);
        if (result == null) {
            return;
        }
        double value = result;
        Node replacement = NodeUtil.numberNode(value, n);
        if (replacement.isEquivalentTo(n)) {
            return;
        }
        n.replaceWith(replacement);
        this.compiler.reportChangeToEnclosingScope(replacement);
    }

    private Node tryFoldTypeof(Node originalTypeofNode) {
        Preconditions.checkArgument(originalTypeofNode.isTypeOf());
        Node argumentNode = originalTypeofNode.getFirstChild();
        if (argumentNode == null || !NodeUtil.isLiteralValue(argumentNode, true)) {
            return originalTypeofNode;
        }
        String typeNameString = null;
        switch (argumentNode.getToken()) {
            case FUNCTION: {
                typeNameString = "function";
                break;
            }
            case STRING: {
                typeNameString = "string";
                break;
            }
            case NUMBER: {
                typeNameString = "number";
                break;
            }
            case TRUE: 
            case FALSE: {
                typeNameString = "boolean";
                break;
            }
            case NULL: 
            case OBJECTLIT: 
            case ARRAYLIT: {
                typeNameString = "object";
                break;
            }
            case VOID: {
                typeNameString = "undefined";
                break;
            }
            case NAME: {
                if (!"undefined".equals(argumentNode.getString())) break;
                typeNameString = "undefined";
                break;
            }
        }
        if (typeNameString != null) {
            Node newNode = IR.string(typeNameString);
            this.compiler.reportChangeToEnclosingScope(originalTypeofNode);
            originalTypeofNode.replaceWith(newNode);
            NodeUtil.markFunctionsDeleted(originalTypeofNode, this.compiler);
            return newNode;
        }
        return originalTypeofNode;
    }

    private Node tryFoldUnaryOperator(Node n) {
        Preconditions.checkState(n.hasOneChild(), n);
        Node left = n.getFirstChild();
        Node parent = n.getParent();
        if (left == null) {
            return n;
        }
        TernaryValue leftVal = NodeUtil.getPureBooleanValue(left);
        if (leftVal == TernaryValue.UNKNOWN) {
            return n;
        }
        switch (n.getToken()) {
            case NOT: {
                double numValue;
                if (this.late && left.isNumber() && ((numValue = left.getDouble()) == 0.0 || numValue == 1.0)) {
                    return n;
                }
                Node replacementNode = NodeUtil.booleanNode(!leftVal.toBoolean(true));
                parent.replaceChild(n, replacementNode);
                this.compiler.reportChangeToEnclosingScope(parent);
                return replacementNode;
            }
            case POS: {
                if (NodeUtil.isNumericResult(left)) {
                    parent.replaceChild(n, left.detach());
                    this.compiler.reportChangeToEnclosingScope(parent);
                    return left;
                }
                return n;
            }
            case NEG: {
                if (left.isName()) {
                    if (left.getString().equals("Infinity")) {
                        return n;
                    }
                    if (left.getString().equals("NaN")) {
                        n.removeChild(left);
                        parent.replaceChild(n, left);
                        this.compiler.reportChangeToEnclosingScope(parent);
                        return left;
                    }
                }
                if (left.isNumber()) {
                    double negNum = -left.getDouble();
                    Node negNumNode = IR.number(negNum);
                    parent.replaceChild(n, negNumNode);
                    this.compiler.reportChangeToEnclosingScope(parent);
                    return negNumNode;
                }
                this.report(NEGATING_A_NON_NUMBER_ERROR, left);
                return n;
            }
            case BITNOT: {
                try {
                    double val = left.getDouble();
                    if (Math.floor(val) == val) {
                        int intVal = this.jsConvertDoubleToBits(val);
                        Node notIntValNode = IR.number(~intVal);
                        parent.replaceChild(n, notIntValNode);
                        this.compiler.reportChangeToEnclosingScope(parent);
                        return notIntValNode;
                    }
                    this.report(FRACTIONAL_BITWISE_OPERAND, left);
                    return n;
                }
                catch (UnsupportedOperationException ex) {
                    this.report(NEGATING_A_NON_NUMBER_ERROR, left);
                    return n;
                }
            }
        }
        return n;
    }

    private int jsConvertDoubleToBits(double d) {
        return (int)((long)Math.floor(d) & 0xFFFFFFFFFFFFFFFFL);
    }

    private Node tryFoldInstanceof(Node n, Node left, Node right) {
        Preconditions.checkArgument(n.isInstanceOf());
        if (NodeUtil.isLiteralValue(left, true) && !this.mayHaveSideEffects(right)) {
            Node replacementNode = null;
            if (NodeUtil.isImmutableValue(left)) {
                replacementNode = IR.falseNode();
            } else if (right.isName() && "Object".equals(right.getString())) {
                replacementNode = IR.trueNode();
            }
            if (replacementNode != null) {
                n.replaceWith(replacementNode);
                this.compiler.reportChangeToEnclosingScope(replacementNode);
                NodeUtil.markFunctionsDeleted(n, this.compiler);
                return replacementNode;
            }
        }
        return n;
    }

    private Node tryFoldAssign(Node n, Node left, Node right) {
        Node newRight;
        Preconditions.checkArgument(n.isAssign());
        if (!this.late) {
            return n;
        }
        if (!right.hasChildren() || right.getSecondChild() != right.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        if (this.areNodesEqualForInlining(left, right.getFirstChild())) {
            newRight = right.getLastChild();
        } else if (NodeUtil.isCommutative(right.getToken()) && this.areNodesEqualForInlining(left, right.getLastChild())) {
            newRight = right.getFirstChild();
        } else {
            return n;
        }
        Token newType = null;
        switch (right.getToken()) {
            case ADD: {
                newType = Token.ASSIGN_ADD;
                break;
            }
            case BITAND: {
                newType = Token.ASSIGN_BITAND;
                break;
            }
            case BITOR: {
                newType = Token.ASSIGN_BITOR;
                break;
            }
            case BITXOR: {
                newType = Token.ASSIGN_BITXOR;
                break;
            }
            case DIV: {
                newType = Token.ASSIGN_DIV;
                break;
            }
            case LSH: {
                newType = Token.ASSIGN_LSH;
                break;
            }
            case MOD: {
                newType = Token.ASSIGN_MOD;
                break;
            }
            case MUL: {
                newType = Token.ASSIGN_MUL;
                break;
            }
            case RSH: {
                newType = Token.ASSIGN_RSH;
                break;
            }
            case SUB: {
                newType = Token.ASSIGN_SUB;
                break;
            }
            case URSH: {
                newType = Token.ASSIGN_URSH;
                break;
            }
            case EXPONENT: {
                newType = Token.ASSIGN_EXPONENT;
                break;
            }
            default: {
                return n;
            }
        }
        Node newNode = new Node(newType, left.detach(), newRight.detach());
        n.replaceWith(newNode);
        this.compiler.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private Node tryUnfoldAssignOp(Node n, Node left, Node right) {
        if (this.late) {
            return n;
        }
        if (!n.hasChildren() || n.getSecondChild() != n.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        Token op = NodeUtil.getOpFromAssignmentOp(n);
        Node replacement = IR.assign(left.detach(), new Node(op, left.cloneTree(), right.detach()).srcref(n));
        n.replaceWith(replacement);
        this.compiler.reportChangeToEnclosingScope(replacement);
        return replacement;
    }

    private Node tryFoldAndOr(Node n, Node left, Node right) {
        Node parent = n.getParent();
        Node result = null;
        Node dropped = null;
        Token type = n.getToken();
        TernaryValue leftVal = NodeUtil.getImpureBooleanValue(left);
        if (leftVal != TernaryValue.UNKNOWN) {
            boolean lval = leftVal.toBoolean(true);
            if (lval && type == Token.OR || !lval && type == Token.AND) {
                result = left;
                dropped = right;
            } else if (!this.mayHaveSideEffects(left)) {
                result = right;
                dropped = left;
            } else {
                n.detachChildren();
                result = IR.comma(left, right);
                dropped = null;
            }
        } else if (parent.getToken() == type && n == parent.getFirstChild()) {
            TernaryValue rightValue = NodeUtil.getImpureBooleanValue(right);
            if (!this.mayHaveSideEffects(right) && (rightValue == TernaryValue.FALSE && type == Token.OR || rightValue == TernaryValue.TRUE && type == Token.AND)) {
                result = left;
                dropped = right;
            }
        }
        if (result != null) {
            n.detachChildren();
            parent.replaceChild(n, result);
            this.compiler.reportChangeToEnclosingScope(result);
            if (dropped != null) {
                NodeUtil.markFunctionsDeleted(dropped, this.compiler);
            }
            return result;
        }
        return n;
    }

    private Node tryFoldChildAddString(Node n, Node left, Node right) {
        String rightString;
        String leftString;
        Node ll;
        Node lr;
        if (NodeUtil.isLiteralValue(right, false) && left.isAdd() && (lr = (ll = left.getFirstChild()).getNext()).isString()) {
            leftString = NodeUtil.getStringValue(lr);
            rightString = NodeUtil.getStringValue(right);
            if (leftString != null && rightString != null) {
                left.removeChild(ll);
                String result = leftString + rightString;
                n.replaceChild(left, ll);
                n.replaceChild(right, IR.string(result));
                this.compiler.reportChangeToEnclosingScope(n);
                return n;
            }
        }
        if (NodeUtil.isLiteralValue(left, false) && right.isAdd()) {
            Node rl = right.getFirstChild();
            Node rr = right.getLastChild();
            if (rl.isString()) {
                leftString = NodeUtil.getStringValue(left);
                rightString = NodeUtil.getStringValue(rl);
                if (leftString != null && rightString != null) {
                    right.removeChild(rr);
                    String result = leftString + rightString;
                    n.replaceChild(right, rr);
                    n.replaceChild(left, IR.string(result));
                    this.compiler.reportChangeToEnclosingScope(n);
                    return n;
                }
            }
        }
        return n;
    }

    private Node tryFoldAddConstantString(Node n, Node left, Node right) {
        if (left.isString() || right.isString() || left.isArrayLit() || right.isArrayLit()) {
            String leftString = NodeUtil.getStringValue(left);
            String rightString = NodeUtil.getStringValue(right);
            if (leftString != null && rightString != null) {
                Node newStringNode = IR.string(leftString + rightString);
                n.replaceWith(newStringNode);
                this.compiler.reportChangeToEnclosingScope(newStringNode);
                return newStringNode;
            }
        }
        return n;
    }

    private Node tryFoldArithmeticOp(Node n, Node left, Node right) {
        Node result = this.performArithmeticOp(n.getToken(), left, right);
        if (result != null) {
            result.useSourceInfoIfMissingFromForTree(n);
            this.compiler.reportChangeToEnclosingScope(n);
            n.replaceWith(result);
            return result;
        }
        return n;
    }

    private Node performArithmeticOp(Token opType, Node left, Node right) {
        double result;
        if (opType == Token.ADD && (NodeUtil.mayBeString(left, this.shouldUseTypes) || NodeUtil.mayBeString(right, this.shouldUseTypes))) {
            return null;
        }
        Double lValObj = NodeUtil.getNumberValue(left);
        Double rValObj = NodeUtil.getNumberValue(right);
        if (lValObj == null && rValObj == null || !this.isNumeric(left) || !this.isNumeric(right)) {
            return null;
        }
        switch (opType) {
            case ADD: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj + rValObj, lValObj, rValObj);
                }
                if (lValObj != null && lValObj == 0.0) {
                    return right.cloneTree(true);
                }
                if (rValObj != null && rValObj == 0.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case SUB: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj - rValObj, lValObj, rValObj);
                }
                if (lValObj != null && lValObj == 0.0) {
                    return IR.neg(right.cloneTree(true));
                }
                if (rValObj != null && rValObj == 0.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case MUL: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj * rValObj, lValObj, rValObj);
                }
                if (lValObj != null) {
                    if (lValObj == 1.0) {
                        return right.cloneTree(true);
                    }
                } else if (rValObj == 1.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case DIV: {
                if (lValObj != null && rValObj != null) {
                    if (rValObj == 0.0) {
                        return null;
                    }
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj / rValObj, lValObj, rValObj);
                }
                if (rValObj != null && rValObj == 1.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case EXPONENT: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(Math.pow(lValObj, rValObj), lValObj, rValObj);
                }
                return null;
            }
        }
        if (lValObj == null || rValObj == null) {
            return null;
        }
        double lval = lValObj;
        double rval = rValObj;
        switch (opType) {
            case BITAND: {
                result = NodeUtil.toInt32(lval) & NodeUtil.toInt32(rval);
                break;
            }
            case BITOR: {
                result = NodeUtil.toInt32(lval) | NodeUtil.toInt32(rval);
                break;
            }
            case BITXOR: {
                result = NodeUtil.toInt32(lval) ^ NodeUtil.toInt32(rval);
                break;
            }
            case MOD: {
                if (rval == 0.0) {
                    return null;
                }
                result = lval % rval;
                break;
            }
            default: {
                throw new Error("Unexpected arithmetic operator: " + (Object)((Object)opType));
            }
        }
        return this.maybeReplaceBinaryOpWithNumericResult(result, lval, rval);
    }

    private boolean isNumeric(Node n) {
        return NodeUtil.isNumericResult(n) || this.shouldUseTypes && n.getJSType() != null && n.getJSType().isNumberValueType();
    }

    private Node maybeReplaceBinaryOpWithNumericResult(double result, double lval, double rval) {
        if (String.valueOf(result).length() <= String.valueOf(lval).length() + String.valueOf(rval).length() + 1 && Math.abs(result) <= MAX_FOLD_NUMBER || Double.isNaN(result) || result == Double.POSITIVE_INFINITY || result == Double.NEGATIVE_INFINITY) {
            return NodeUtil.numberNode(result, null);
        }
        return null;
    }

    private Node tryFoldLeftChildOp(Node n, Node left, Node right) {
        Token opType = n.getToken();
        Preconditions.checkState(NodeUtil.isAssociative(opType) && NodeUtil.isCommutative(opType) || n.isAdd());
        Preconditions.checkState(!n.isAdd() || !NodeUtil.mayBeString(n, this.shouldUseTypes));
        Double rightValObj = NodeUtil.getNumberValue(right);
        if (rightValObj != null && left.getToken() == opType) {
            Preconditions.checkState(left.hasTwoChildren());
            Node ll = left.getFirstChild();
            Node lr = ll.getNext();
            Node valueToCombine = ll;
            Node replacement = this.performArithmeticOp(opType, valueToCombine, right);
            if (replacement == null) {
                valueToCombine = lr;
                replacement = this.performArithmeticOp(opType, valueToCombine, right);
            }
            if (replacement != null) {
                left.removeChild(valueToCombine);
                n.replaceChild(left, left.removeFirstChild());
                replacement.useSourceInfoIfMissingFromForTree(right);
                n.replaceChild(right, replacement);
                this.compiler.reportChangeToEnclosingScope(n);
            }
        }
        return n;
    }

    private Node tryFoldAdd(Node node, Node left, Node right) {
        Preconditions.checkArgument(node.isAdd());
        if (NodeUtil.mayBeString(node, this.shouldUseTypes)) {
            if (NodeUtil.isLiteralValue(left, false) && NodeUtil.isLiteralValue(right, false)) {
                return this.tryFoldAddConstantString(node, left, right);
            }
            if (left.isString() && left.getString().isEmpty() && this.isStringTyped(right)) {
                return this.replace(node, right.cloneTree(true));
            }
            if (right.isString() && right.getString().isEmpty() && this.isStringTyped(left)) {
                return this.replace(node, left.cloneTree(true));
            }
            return this.tryFoldChildAddString(node, left, right);
        }
        Node result = this.tryFoldArithmeticOp(node, left, right);
        if (result != node) {
            return result;
        }
        return this.tryFoldLeftChildOp(node, left, right);
    }

    private Node replace(Node oldNode, Node newNode) {
        oldNode.replaceWith(newNode);
        this.compiler.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private boolean isStringTyped(Node n) {
        return NodeUtil.isStringResult(n) || this.shouldUseTypes && n.getJSType() != null && n.getJSType().isStringValueType();
    }

    private Node tryFoldShift(Node n, Node left, Node right) {
        if (left.isNumber() && right.isNumber()) {
            double result;
            double lval = left.getDouble();
            double rval = right.getDouble();
            if (!(rval >= 0.0) || !(rval < 32.0)) {
                return n;
            }
            int rvalInt = (int)rval;
            if ((double)rvalInt != rval) {
                this.report(FRACTIONAL_BITWISE_OPERAND, right);
                return n;
            }
            if (Math.floor(lval) != lval) {
                this.report(FRACTIONAL_BITWISE_OPERAND, left);
                return n;
            }
            int bits = this.jsConvertDoubleToBits(lval);
            switch (n.getToken()) {
                case LSH: {
                    result = bits << rvalInt;
                    break;
                }
                case RSH: {
                    result = bits >> rvalInt;
                    break;
                }
                case URSH: {
                    result = 0xFFFFFFFFL & (long)(bits >>> rvalInt);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown shift operator: " + (Object)((Object)n.getToken())));
                }
            }
            Node newNumber = IR.number(result);
            this.compiler.reportChangeToEnclosingScope(n);
            n.replaceWith(newNumber);
            return newNumber;
        }
        return n;
    }

    private Node tryFoldComparison(Node n, Node left, Node right) {
        TernaryValue result = PeepholeFoldConstants.evaluateComparison(n.getToken(), left, right);
        if (result == TernaryValue.UNKNOWN) {
            return n;
        }
        Node newNode = NodeUtil.booleanNode(result.toBoolean(true));
        this.compiler.reportChangeToEnclosingScope(n);
        n.replaceWith(newNode);
        NodeUtil.markFunctionsDeleted(n, this.compiler);
        return newNode;
    }

    private static TernaryValue tryAbstractRelationalComparison(Node left, Node right, boolean willNegate) {
        Object rv;
        Object lv;
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType != NodeUtil.ValueType.UNDETERMINED && rightValueType != NodeUtil.ValueType.UNDETERMINED && leftValueType == NodeUtil.ValueType.STRING && rightValueType == NodeUtil.ValueType.STRING) {
            lv = NodeUtil.getStringValue(left);
            rv = NodeUtil.getStringValue(right);
            if (lv != null && rv != null) {
                if (((String)lv).indexOf(11) != -1 || ((String)rv).indexOf(11) != -1) {
                    return TernaryValue.UNKNOWN;
                }
                return TernaryValue.forBoolean(((String)lv).compareTo((String)rv) < 0);
            }
            if (left.isTypeOf() && right.isTypeOf() && left.getFirstChild().isName() && right.getFirstChild().isName() && left.getFirstChild().getString().equals(right.getFirstChild().getString())) {
                return TernaryValue.FALSE;
            }
        }
        lv = NodeUtil.getNumberValue(left);
        rv = NodeUtil.getNumberValue(right);
        if (lv == null || rv == null) {
            if (!willNegate && left.isName() && right.isName() && left.getString().equals(right.getString())) {
                return TernaryValue.FALSE;
            }
            return TernaryValue.UNKNOWN;
        }
        if (Double.isNaN((Double)lv) || Double.isNaN((Double)rv)) {
            return TernaryValue.forBoolean(willNegate);
        }
        return TernaryValue.forBoolean((Double)lv < (Double)rv);
    }

    private static TernaryValue tryAbstractEqualityComparison(Node left, Node right) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType != NodeUtil.ValueType.UNDETERMINED && rightValueType != NodeUtil.ValueType.UNDETERMINED) {
            if (leftValueType == rightValueType) {
                return PeepholeFoldConstants.tryStrictEqualityComparison(left, right);
            }
            if (leftValueType == NodeUtil.ValueType.NULL && rightValueType == NodeUtil.ValueType.VOID || leftValueType == NodeUtil.ValueType.VOID && rightValueType == NodeUtil.ValueType.NULL) {
                return TernaryValue.TRUE;
            }
            if (leftValueType == NodeUtil.ValueType.NUMBER && rightValueType == NodeUtil.ValueType.STRING || rightValueType == NodeUtil.ValueType.BOOLEAN) {
                Double rv = NodeUtil.getNumberValue(right);
                return rv == null ? TernaryValue.UNKNOWN : PeepholeFoldConstants.tryAbstractEqualityComparison(left, IR.number(rv));
            }
            if (leftValueType == NodeUtil.ValueType.STRING && rightValueType == NodeUtil.ValueType.NUMBER || leftValueType == NodeUtil.ValueType.BOOLEAN) {
                Double lv = NodeUtil.getNumberValue(left);
                return lv == null ? TernaryValue.UNKNOWN : PeepholeFoldConstants.tryAbstractEqualityComparison(IR.number(lv), right);
            }
            if ((leftValueType == NodeUtil.ValueType.STRING || leftValueType == NodeUtil.ValueType.NUMBER) && rightValueType == NodeUtil.ValueType.OBJECT) {
                return TernaryValue.UNKNOWN;
            }
            if (leftValueType == NodeUtil.ValueType.OBJECT && (rightValueType == NodeUtil.ValueType.STRING || rightValueType == NodeUtil.ValueType.NUMBER)) {
                return TernaryValue.UNKNOWN;
            }
            return TernaryValue.FALSE;
        }
        return TernaryValue.UNKNOWN;
    }

    private static TernaryValue tryStrictEqualityComparison(Node left, Node right) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType != NodeUtil.ValueType.UNDETERMINED && rightValueType != NodeUtil.ValueType.UNDETERMINED) {
            if (leftValueType != rightValueType) {
                return TernaryValue.FALSE;
            }
            switch (leftValueType) {
                case VOID: 
                case NULL: {
                    return TernaryValue.TRUE;
                }
                case NUMBER: {
                    if (NodeUtil.isNaN(left)) {
                        return TernaryValue.FALSE;
                    }
                    if (NodeUtil.isNaN(right)) {
                        return TernaryValue.FALSE;
                    }
                    Double lv = NodeUtil.getNumberValue(left);
                    Double rv = NodeUtil.getNumberValue(right);
                    if (lv == null || rv == null) break;
                    return TernaryValue.forBoolean(lv.doubleValue() == rv.doubleValue());
                }
                case STRING: {
                    String lv = NodeUtil.getStringValue(left);
                    String rv = NodeUtil.getStringValue(right);
                    if (lv != null && rv != null) {
                        if (lv.indexOf(11) != -1 || rv.indexOf(11) != -1) {
                            return TernaryValue.UNKNOWN;
                        }
                        return lv.equals(rv) ? TernaryValue.TRUE : TernaryValue.FALSE;
                    }
                    if (!left.isTypeOf() || !right.isTypeOf() || !left.getFirstChild().isName() || !right.getFirstChild().isName() || !left.getFirstChild().getString().equals(right.getFirstChild().getString())) break;
                    return TernaryValue.TRUE;
                }
                case BOOLEAN: {
                    TernaryValue lv = NodeUtil.getPureBooleanValue(left);
                    TernaryValue rv = NodeUtil.getPureBooleanValue(right);
                    return lv.and(rv).or(lv.not().and(rv.not()));
                }
                default: {
                    return TernaryValue.UNKNOWN;
                }
            }
        }
        if (NodeUtil.isNaN(left) || NodeUtil.isNaN(right)) {
            return TernaryValue.FALSE;
        }
        return TernaryValue.UNKNOWN;
    }

    static TernaryValue evaluateComparison(Token op, Node left, Node right) {
        if (NodeUtil.mayHaveSideEffects(left) || NodeUtil.mayHaveSideEffects(right)) {
            return TernaryValue.UNKNOWN;
        }
        switch (op) {
            case EQ: {
                return PeepholeFoldConstants.tryAbstractEqualityComparison(left, right);
            }
            case NE: {
                return PeepholeFoldConstants.tryAbstractEqualityComparison(left, right).not();
            }
            case SHEQ: {
                return PeepholeFoldConstants.tryStrictEqualityComparison(left, right);
            }
            case SHNE: {
                return PeepholeFoldConstants.tryStrictEqualityComparison(left, right).not();
            }
            case LT: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(left, right, false);
            }
            case GT: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(right, left, false);
            }
            case LE: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(right, left, true).not();
            }
            case GE: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(left, right, true).not();
            }
        }
        throw new IllegalStateException("Unexpected operator for comparison");
    }

    private Node tryFoldCtorCall(Node n) {
        Preconditions.checkArgument(n.isNew());
        if (PeepholeFoldConstants.inForcedStringContext(n)) {
            return this.tryFoldInForcedStringContext(n);
        }
        return n;
    }

    private Node tryFoldCall(Node n) {
        Node srcObj;
        Preconditions.checkArgument(n.isCall());
        if (NodeUtil.isObjectDefinePropertiesDefinition(n) && (srcObj = n.getLastChild()).isObjectLit() && !srcObj.hasChildren()) {
            Node parent = n.getParent();
            Node destObj = n.getSecondChild().detach();
            parent.replaceChild(n, destObj);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        return n;
    }

    private static boolean inForcedStringContext(Node n) {
        if (n.getParent().isGetElem() && n.getParent().getLastChild() == n) {
            return true;
        }
        return n.getParent().isAdd();
    }

    private Node tryFoldInForcedStringContext(Node n) {
        Preconditions.checkArgument(n.isNew());
        Node objectType = n.getFirstChild();
        if (!objectType.isName()) {
            return n;
        }
        if (objectType.getString().equals("String")) {
            Node value = objectType.getNext();
            String stringValue = null;
            if (value == null) {
                stringValue = "";
            } else {
                if (!NodeUtil.isImmutableValue(value)) {
                    return n;
                }
                stringValue = NodeUtil.getStringValue(value);
            }
            if (stringValue == null) {
                return n;
            }
            Node parent = n.getParent();
            Node newString = IR.string(stringValue);
            parent.replaceChild(n, newString);
            newString.useSourceInfoIfMissingFrom(parent);
            this.compiler.reportChangeToEnclosingScope(parent);
            return newString;
        }
        return n;
    }

    private Node tryFoldGetElem(Node n, Node left, Node right) {
        Preconditions.checkArgument(n.isGetElem());
        if (left.isObjectLit()) {
            return this.tryFoldObjectPropAccess(n, left, right);
        }
        if (left.isArrayLit()) {
            return this.tryFoldArrayAccess(n, left, right);
        }
        if (left.isString()) {
            return this.tryFoldStringArrayAccess(n, left, right);
        }
        return n;
    }

    private Node tryFoldGetProp(Node n, Node left, Node right) {
        Preconditions.checkArgument(n.isGetProp());
        if (left.isObjectLit()) {
            return this.tryFoldObjectPropAccess(n, left, right);
        }
        if (right.isString() && right.getString().equals("length")) {
            int knownLength = -1;
            switch (left.getToken()) {
                case ARRAYLIT: {
                    if (this.mayHaveSideEffects(left)) {
                        return n;
                    }
                    knownLength = left.getChildCount();
                    break;
                }
                case STRING: {
                    knownLength = left.getString().length();
                    break;
                }
                default: {
                    return n;
                }
            }
            Preconditions.checkState(knownLength != -1);
            Node lengthNode = IR.number(knownLength);
            this.compiler.reportChangeToEnclosingScope(n);
            n.replaceWith(lengthNode);
            return lengthNode;
        }
        return n;
    }

    private Node tryFoldArrayAccess(Node n, Node left, Node right) {
        if (NodeUtil.isLValue(n)) {
            return n;
        }
        if (!right.isNumber()) {
            return n;
        }
        double index = right.getDouble();
        int intIndex = (int)index;
        if ((double)intIndex != index) {
            this.report(INVALID_GETELEM_INDEX_ERROR, right);
            return n;
        }
        if (intIndex < 0) {
            this.report(INDEX_OUT_OF_BOUNDS_ERROR, right);
            return n;
        }
        Node current = left.getFirstChild();
        Node elem = null;
        int i = 0;
        while (current != null) {
            if (i != intIndex) {
                if (this.mayHaveSideEffects(current)) {
                    return n;
                }
            } else {
                elem = current;
            }
            current = current.getNext();
            ++i;
        }
        if (elem == null) {
            this.report(INDEX_OUT_OF_BOUNDS_ERROR, right);
            return n;
        }
        if (elem.isEmpty()) {
            elem = NodeUtil.newUndefinedNode(elem);
        } else {
            left.removeChild(elem);
        }
        n.replaceWith(elem);
        this.compiler.reportChangeToEnclosingScope(elem);
        return elem;
    }

    private Node tryFoldStringArrayAccess(Node n, Node left, Node right) {
        if (NodeUtil.isLValue(n)) {
            return n;
        }
        if (!right.isNumber()) {
            return n;
        }
        double index = right.getDouble();
        int intIndex = (int)index;
        if ((double)intIndex != index) {
            this.report(INVALID_GETELEM_INDEX_ERROR, right);
            return n;
        }
        if (intIndex < 0) {
            this.report(INDEX_OUT_OF_BOUNDS_ERROR, right);
            return n;
        }
        Preconditions.checkState(left.isString());
        String value = left.getString();
        if (intIndex >= value.length()) {
            this.report(INDEX_OUT_OF_BOUNDS_ERROR, right);
            return n;
        }
        char c = '\u0000';
        for (int i = 0; i <= intIndex; ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c <= 127) continue;
            return n;
        }
        Node elem = IR.string(Character.toString(c));
        n.replaceWith(elem);
        this.compiler.reportChangeToEnclosingScope(elem);
        return elem;
    }

    private Node tryFoldObjectPropAccess(Node n, Node left, Node right) {
        Preconditions.checkArgument(NodeUtil.isGet(n));
        if (!left.isObjectLit() || !right.isString()) {
            return n;
        }
        if (NodeUtil.isLValue(n)) {
            return n;
        }
        Node key = null;
        Node value = null;
        block5: for (Node c = left.getFirstChild(); c != null; c = c.getNext()) {
            switch (c.getToken()) {
                case SETTER_DEF: {
                    continue block5;
                }
                case COMPUTED_PROP: {
                    Node prop = c.getFirstChild();
                    if (!prop.isString()) {
                        return n;
                    }
                    if (!prop.getString().equals(right.getString())) break;
                    if (value != null && this.mayHaveSideEffects(value)) {
                        return n;
                    }
                    key = c;
                    value = key.getSecondChild();
                    continue block5;
                }
                case GETTER_DEF: 
                case STRING_KEY: 
                case MEMBER_FUNCTION_DEF: {
                    if (!c.getString().equals(right.getString())) break;
                    if (value != null && this.mayHaveSideEffects(value)) {
                        return n;
                    }
                    key = c;
                    value = key.getFirstChild();
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!this.mayHaveSideEffects(c.getFirstChild())) continue;
            return n;
        }
        if (value == null) {
            return n;
        }
        if (key.isMemberFunctionDef()) {
            return n;
        }
        if (n.getParent().isCall() || key.isGetterDef()) {
            if (value.isFunction() && !NodeUtil.referencesThis(value)) {
                if (n.getParent().isCall()) {
                    n.getParent().putBooleanProp(Node.FREE_CALL, true);
                }
            } else {
                return n;
            }
        }
        Node replacement = value.detach();
        if (key.isGetterDef()) {
            replacement = IR.call(replacement, new Node[0]);
            replacement.putBooleanProp(Node.FREE_CALL, true);
        }
        n.replaceWith(replacement);
        this.compiler.reportChangeToEnclosingScope(replacement);
        NodeUtil.markFunctionsDeleted(n, this.compiler);
        return n;
    }
}

