/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

public final class Es7RewriteExponentialOperator
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.EXPONENT_OP);
    private final AbstractCompiler compiler;
    private final Node mathPowCall;
    private final JSType numberType;
    private final JSType stringType;
    private final JSType mathType;
    private final JSType mathPowType;

    public Es7RewriteExponentialOperator(AbstractCompiler compiler) {
        this.compiler = compiler;
        if (compiler.hasTypeCheckingRun()) {
            JSTypeRegistry registry = compiler.getTypeRegistry();
            this.numberType = registry.getNativeType(JSTypeNative.NUMBER_TYPE);
            this.stringType = registry.getNativeType(JSTypeNative.STRING_TYPE);
            this.mathType = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            this.mathPowType = registry.createFunctionType(this.numberType, this.numberType, this.numberType);
        } else {
            this.numberType = null;
            this.stringType = null;
            this.mathType = null;
            this.mathPowType = null;
        }
        this.mathPowCall = this.createMathPowCall();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case EXPONENT: {
                this.visitExponentiationOperator(n);
                break;
            }
            case ASSIGN_EXPONENT: {
                this.visitExponentiationAssignmentOperator(n);
                break;
            }
        }
    }

    private void visitExponentiationOperator(Node operator) {
        Node callClone = this.mathPowCall.cloneTree();
        callClone.addChildToBack(operator.removeFirstChild());
        callClone.addChildToBack(operator.removeFirstChild());
        callClone.useSourceInfoIfMissingFromForTree(operator);
        operator.replaceWith(callClone);
        this.compiler.reportChangeToEnclosingScope(callClone);
    }

    private void visitExponentiationAssignmentOperator(Node operator) {
        Node lValue = operator.removeFirstChild();
        Node callClone = this.mathPowCall.cloneTree();
        callClone.addChildToBack(lValue.cloneTree());
        callClone.addChildToBack(operator.removeFirstChild());
        Node assignment = IR.assign(lValue, callClone).setJSType(this.numberType);
        assignment.useSourceInfoIfMissingFromForTree(operator);
        operator.replaceWith(assignment);
        this.compiler.reportChangeToEnclosingScope(assignment);
    }

    private Node createMathPowCall() {
        return IR.call(IR.getprop(IR.name("Math").setJSType(this.mathType), IR.string("pow").setJSType(this.stringType)).setJSType(this.mathPowType), new Node[0]).setJSType(this.numberType);
    }
}

