/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CheckUnusedPrivateProperties
implements HotSwapCompilerPass,
NodeTraversal.Callback {
    static final DiagnosticType UNUSED_PRIVATE_PROPERTY = DiagnosticType.disabled("JSC_UNUSED_PRIVATE_PROPERTY", "Private property {0} is never read");
    private final AbstractCompiler compiler;
    private final Set<String> used = new HashSet<String>();
    private final List<Node> candidates = new ArrayList<Node>();

    CheckUnusedPrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    private void reportUnused(NodeTraversal t) {
        for (Node n : this.candidates) {
            String propName = this.getPropName(n);
            if (this.used.contains(propName)) continue;
            t.report(n, UNUSED_PRIVATE_PROPERTY, propName);
        }
    }

    private String getPropName(Node n) {
        switch (n.getToken()) {
            case GETPROP: {
                return n.getLastChild().getString();
            }
            case MEMBER_FUNCTION_DEF: {
                return n.getString();
            }
        }
        throw new RuntimeException("Unexpected node type: " + n);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.used.clear();
            this.candidates.clear();
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.reportUnused(t);
                break;
            }
            case GETPROP: {
                String propName = n.getLastChild().getString();
                if (this.compiler.getCodingConvention().isExported(propName) || CheckUnusedPrivateProperties.isPinningPropertyUse(n) || !this.isCandidatePropertyDefinition(n)) {
                    this.used.add(propName);
                    break;
                }
                if (!this.isCheckablePrivatePropDecl(n)) break;
                this.candidates.add(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (!this.isCheckablePrivatePropDecl(n)) break;
                this.candidates.add(n);
                break;
            }
            case OBJECTLIT: {
                for (Node c : n.children()) {
                    if (!c.isStringKey() && !c.isGetterDef() && !c.isSetterDef() && !c.isMemberFunctionDef()) continue;
                    this.used.add(c.getString());
                }
                break;
            }
            case CALL: {
                Node propName;
                Node target = n.getFirstChild();
                if (!n.hasMoreThanOneChild() || !this.compiler.getCodingConvention().isPropertyRenameFunction(target.getOriginalQualifiedName()) || !(propName = target.getNext()).isString()) break;
                this.used.add(propName.getString());
                break;
            }
        }
    }

    private boolean isPrivatePropDecl(Node n) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return info != null && info.getVisibility() == JSDocInfo.Visibility.PRIVATE;
    }

    private boolean isCheckablePrivatePropDecl(Node n) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return this.isPrivatePropDecl(n) && !info.hasTypedefType() && !info.isInterface();
    }

    private boolean isCandidatePropertyDefinition(Node n) {
        Preconditions.checkState(n.isGetProp(), n);
        Node target = n.getFirstChild();
        return target.isThis() || this.isConstructor(target) || target.isGetProp() && target.getLastChild().getString().equals("prototype");
    }

    private boolean isConstructor(Node n) {
        JSType type = n.getJSType();
        return type != null && (type.isConstructor() || type.isInterface());
    }

    private static boolean isPinningPropertyUse(Node n) {
        Node parent = n.getParent();
        if (n == parent.getFirstChild()) {
            if (parent.isExprResult()) {
                return false;
            }
            if (parent.isAssign()) {
                return false;
            }
            if (NodeUtil.isAssignmentOp(parent) || parent.isInc() || parent.isDec()) {
                return NodeUtil.isExpressionResultUsed(parent);
            }
        }
        return true;
    }
}

