/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.IASGlobalFunctionConstants;
import org.apache.royale.compiler.codegen.IEmitterTokens;
import org.apache.royale.compiler.codegen.as.IASEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleDocEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.JSDocEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.TypedExpressionNode;
import org.apache.royale.compiler.problems.PublicVarWarningProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class JSRoyaleDocEmitter
extends JSDocEmitter
implements IJSRoyaleDocEmitter {
    private List<String> classIgnoreList;
    private List<String> ignoreList;
    private List<String> coercionList;
    private Map<String, List<String>> localSettings;
    public boolean emitStringConversions = true;
    private boolean emitExports = true;
    private boolean exportProtected = false;
    private boolean exportInternal = false;
    private boolean suppressClosure = false;
    private boolean usedNames = false;

    public JSRoyaleDocEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    public List<String> getClassIgnoreList() {
        return this.classIgnoreList;
    }

    public void setClassIgnoreList(List<String> value) {
        this.classIgnoreList = value;
    }

    public Boolean getSuppressClosure() {
        return this.suppressClosure;
    }

    public Boolean getEmitExports() {
        return this.emitExports;
    }

    protected String convertASTypeToJS(String name, String pname) {
        if (this.ignoreList != null && this.ignoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.coercionList != null && !this.coercionList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.classIgnoreList != null && this.classIgnoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (name.matches("Vector\\.<.*>")) {
            String vectorClassName;
            RoyaleJSProject fjp = (RoyaleJSProject)((IASEmitter)this.emitter).getWalker().getProject();
            String string = vectorClassName = fjp.config == null ? null : fjp.config.getJsVectorEmulationClass();
            if (vectorClassName != null) {
                return vectorClassName;
            }
            return JSRoyaleDocEmitter.convertASTypeToJSType(name, pname);
        }
        if ((name = JSRoyaleDocEmitter.convertASTypeToJSType(name, pname)).equals("Boolean".toLowerCase()) || name.equals("String".toLowerCase()) || name.equals("Number".toLowerCase())) {
            return name;
        }
        return this.formatQualifiedName(name);
    }

    public static String convertASTypeToJSType(String name, String pname) {
        Object result = "";
        if (((String)name).equals("")) {
            result = ASEmitterTokens.ANY_TYPE.getToken();
        } else if (((String)name).equals("Class")) {
            result = "Object";
        } else if (((String)name).equals("Boolean") || ((String)name).equals("String") || ((String)name).equals("Number")) {
            result = ((String)name).toLowerCase();
        } else if (((String)name).equals("int") || ((String)name).equals("uint")) {
            result = "Number".toLowerCase();
        }
        boolean isBuiltinFunction = ((String)name).matches("Vector\\.<.*>");
        if (isBuiltinFunction) {
            String elementType = ((String)name).substring(8, ((String)name).length() - 1);
            elementType = JSRoyaleDocEmitter.convertASTypeToJSType(elementType, pname);
            name = "Array.<" + elementType + ">";
        } else {
            IASGlobalFunctionConstants.BuiltinType[] builtinTypes;
            for (IASGlobalFunctionConstants.BuiltinType builtinType : builtinTypes = IASGlobalFunctionConstants.BuiltinType.values()) {
                if (!((String)name).equalsIgnoreCase(builtinType.getName())) continue;
                isBuiltinFunction = true;
                break;
            }
        }
        if (result == "") {
            result = pname != "" && !isBuiltinFunction && ((String)name).indexOf(".") < 0 ? pname + ASEmitterTokens.MEMBER_ACCESS.getToken() + (String)name : name;
        }
        return result;
    }

    protected String formatQualifiedName(String name) {
        return ((JSRoyaleEmitter)this.emitter).formatQualifiedName(name, !this.usedNames);
    }

    @Override
    public void emitInterfaceDoc(IInterfaceNode node, ICompilerProject project) {
        IExpressionNode[] inodes;
        this.begin();
        this.emitJSDocLine(JSEmitterTokens.INTERFACE.getToken());
        boolean hasQualifiedNames = true;
        for (IExpressionNode inode : inodes = node.getExtendedInterfaceNodes()) {
            IDefinition dnode = inode.resolve(project);
            if (dnode == null) {
                hasQualifiedNames = false;
                break;
            }
            this.emitJSDocLine(ASEmitterTokens.EXTENDS, this.formatQualifiedName(dnode.getQualifiedName()));
        }
        if (!hasQualifiedNames) {
            String[] inames;
            for (String iname : inames = node.getExtendedInterfaces()) {
                this.emitJSDocLine(ASEmitterTokens.EXTENDS, iname);
            }
        }
        this.end();
    }

    @Override
    public void emitMethodDoc(IFunctionNode node, ICompilerProject project) {
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        this.emitExports = false;
        this.exportProtected = false;
        this.exportInternal = false;
        this.coercionList = null;
        this.ignoreList = null;
        this.localSettings = null;
        this.emitStringConversions = true;
        this.suppressClosure = false;
        IClassDefinition classDefinition = this.resolveClassDefinition(node);
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (node instanceof IFunctionNode) {
            boolean hasDoc = false;
            Boolean override = false;
            if (node.isConstructor()) {
                String qname;
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
                this.emitJSDocLine(JSEmitterTokens.CONSTRUCTOR);
                IClassDefinition parent = (IClassDefinition)node.getDefinition().getParent();
                IClassDefinition superClass = parent.resolveBaseClass(project);
                String string = qname = superClass != null ? project.getActualPackageName(superClass.getQualifiedName()) : null;
                if ((superClass == null || qname.equals("Object")) && ((JSRoyaleEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.EXTENDS) {
                    superClass = (IClassDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_CLASS_QNAME);
                    if (superClass == null) {
                        System.out.println(BindableEmitter.DISPATCHER_CLASS_QNAME + " not resolved for implicit super class in " + classDefinition.getQualifiedName());
                    } else {
                        qname = BindableEmitter.DISPATCHER_CLASS_QNAME;
                    }
                }
                this.usedNames = true;
                if (superClass != null && !qname.equals("Object")) {
                    this.emitExtends(superClass, superClass.getPackageName());
                }
                IReference[] references = classDefinition.getImplementedInterfaceReferences();
                Boolean sawIEventDispatcher = false;
                Boolean needsIEventDispatcher = ((JSRoyaleEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS;
                for (IReference iReference : references) {
                    ITypeDefinition type = (ITypeDefinition)iReference.resolve(project, (IASScope)((ASScope)classDefinition.getContainingScope()), DependencyType.INHERITANCE, true);
                    if (type == null) {
                        System.out.println(iReference.getDisplayString() + " not resolved in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                    if (type.getQualifiedName() != BindableEmitter.DISPATCHER_INTERFACE_QNAME) continue;
                    sawIEventDispatcher = true;
                }
                if (needsIEventDispatcher.booleanValue() && !sawIEventDispatcher.booleanValue()) {
                    ITypeDefinition type = (ITypeDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_INTERFACE_QNAME);
                    if (type == null) {
                        System.out.println(BindableEmitter.DISPATCHER_INTERFACE_QNAME + " not resolved for implicit implementation in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                }
                this.usedNames = false;
            } else {
                override = node.hasModifier(ASModifier.OVERRIDE);
                String ns = node.getNamespace();
                if (ASNodeUtils.hasExportSuppressed((IDocumentableDefinitionNode)node)) {
                    this.emitExports = false;
                    if ("public".equals(ns)) {
                        ((JSRoyaleEmitter)this.emitter).getModel().suppressedExportNodes.add((IASNode)node);
                    }
                }
                if (ns != null) {
                    if (asDoc != null && keepASDoc) {
                        String suppressClosureToken;
                        String suppressVectorIndexCheck;
                        String noResolveUncertain;
                        String noImplicitComplexCoercion;
                        String noStringToken;
                        String ignoreToken;
                        String keepToken;
                        IParameterNode[] docText = asDoc.commentNoEnd();
                        if (docText.contains(keepToken = JSRoyaleEmitterTokens.EMIT_COERCION.getToken())) {
                            this.loadKeepers((String)docText);
                        }
                        if (docText.contains(ignoreToken = JSRoyaleEmitterTokens.IGNORE_COERCION.getToken())) {
                            this.loadIgnores((String)docText);
                        }
                        if (docText.contains(noStringToken = JSRoyaleEmitterTokens.IGNORE_STRING_COERCION.getToken())) {
                            this.emitStringConversions = false;
                        }
                        if (docText.contains(noImplicitComplexCoercion = JSRoyaleEmitterTokens.SUPPRESS_COMPLEX_IMPLICIT_COERCION.getToken())) {
                            this.loadLocalSettings((String)docText, noImplicitComplexCoercion, "true");
                        }
                        if (docText.contains(noResolveUncertain = JSRoyaleEmitterTokens.SUPPRESS_RESOLVE_UNCERTAIN.getToken())) {
                            this.loadLocalSettings((String)docText, noResolveUncertain, "true");
                        }
                        if (docText.contains(suppressVectorIndexCheck = JSRoyaleEmitterTokens.SUPPRESS_VECTOR_INDEX_CHECK.getToken())) {
                            this.loadLocalSettings((String)docText, suppressVectorIndexCheck, "true");
                        }
                        if (docText.contains(suppressClosureToken = JSRoyaleEmitterTokens.SUPPRESS_CLOSURE.getToken())) {
                            this.suppressClosure = true;
                        }
                        this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                    } else {
                        this.begin();
                    }
                    this.emitMethodAccess(node);
                    this.emitMethodNoCollapse(node, fjp);
                    hasDoc = true;
                }
            }
            if (!override.booleanValue()) {
                IParameterNode[] parameters;
                for (IParameterNode pnode : parameters = node.getParameterNodes()) {
                    IExpressionNode enode;
                    ITypeDefinition tdef;
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        this.emitMethodNoCollapse(node, fjp);
                        hasDoc = true;
                    }
                    if ((tdef = (enode = pnode.getNameExpressionNode()).resolveType(project)) == null) continue;
                    this.emitParam(pnode, project.getActualPackageName(tdef.getPackageName()), project);
                }
            }
            if (!node.isConstructor()) {
                if (!override.booleanValue()) {
                    String returnType = node.getReturnType();
                    if (project.getInferTypes() && (returnType == null || returnType.isEmpty())) {
                        ITypeDefinition resolvedTypeDef = SemanticUtils.resolveFunctionInferredReturnType((IFunctionNode)node, (ICompilerProject)project);
                        returnType = resolvedTypeDef != null ? resolvedTypeDef.getQualifiedName() : "*";
                    }
                    if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
                        if (!hasDoc) {
                            if (asDoc != null && keepASDoc) {
                                this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                            } else {
                                this.begin();
                            }
                            this.emitMethodAccess(node);
                            this.emitMethodNoCollapse(node, fjp);
                            hasDoc = true;
                        }
                        ITypeDefinition tdef = node.getDefinition().resolveReturnType(project);
                        String packageName = "";
                        packageName = tdef != null ? tdef.getPackageName() : "";
                        this.emitReturn(node, project.getActualPackageName(packageName), project);
                    }
                }
                if (override.booleanValue()) {
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        this.emitMethodNoCollapse(node, fjp);
                        hasDoc = true;
                    }
                    this.emitOverride(node);
                }
            }
            if (hasDoc) {
                this.end();
            }
        }
    }

    private void loadLocalSettings(String doc, String settingToken, String defaultSetting) {
        List<String> settings;
        if (this.localSettings == null) {
            this.localSettings = new HashMap<String, List<String>>();
        }
        int index = doc.indexOf(settingToken);
        List<String> list = settings = this.localSettings.containsKey(settingToken) ? this.localSettings.get(settingToken) : null;
        while (index != -1) {
            String setting = doc.substring(index + settingToken.length());
            int endIndex = setting.indexOf("\n");
            setting = setting.substring(0, endIndex);
            setting = setting.trim();
            if (settings == null) {
                settings = new ArrayList<String>();
                this.localSettings.put(settingToken, settings);
            }
            List<String> settingItems = null;
            settingItems = setting.length() > 0 ? Arrays.asList(setting.split("\\s*(,\\s*)+")) : Arrays.asList(defaultSetting);
            for (String settingItem : settingItems) {
                if (settings.contains(settingItem)) {
                    settings.remove(settingItem);
                }
                settings.add(settingItem);
            }
            index = doc.indexOf(settingToken, index + settingToken.length());
        }
    }

    public boolean hasLocalSetting(String settingToken) {
        if (this.localSettings == null) {
            return false;
        }
        return this.localSettings.keySet().contains(settingToken);
    }

    public boolean getLocalSettingAsBoolean(JSRoyaleEmitterTokens token, Boolean defaultValue) {
        return this.getLocalSettingAsBoolean(token.getToken(), defaultValue);
    }

    public boolean getLocalSettingAsBoolean(String settingToken, Boolean defaultValue) {
        boolean setting = defaultValue;
        if (this.hasLocalSetting(settingToken)) {
            for (String stringVal : this.localSettings.get(settingToken)) {
                if (stringVal.equals("false")) {
                    setting = false;
                    continue;
                }
                if (!stringVal.equals("true")) continue;
                setting = true;
            }
        }
        return setting;
    }

    public boolean getLocalSettingIncludesString(JSRoyaleEmitterTokens token, String searchValue) {
        return this.getLocalSettingIncludesString(token.getToken(), searchValue);
    }

    public boolean getLocalSettingIncludesString(String settingToken, String searchValue) {
        boolean hasValue = false;
        if (this.hasLocalSetting(settingToken)) {
            for (String stringVal : this.localSettings.get(settingToken)) {
                if (!stringVal.equals(searchValue)) continue;
                hasValue = true;
                break;
            }
        }
        return hasValue;
    }

    private void loadIgnores(String doc) {
        this.ignoreList = new ArrayList<String>();
        String ignoreToken = JSRoyaleEmitterTokens.IGNORE_COERCION.getToken();
        int index = doc.indexOf(ignoreToken);
        while (index != -1) {
            String ignore = doc.substring(index + ignoreToken.length());
            int endIndex = ignore.indexOf("\n");
            ignore = ignore.substring(0, endIndex);
            ignore = ignore.trim();
            this.ignoreList.add(ignore);
            index = doc.indexOf(ignoreToken, index + endIndex);
        }
    }

    public boolean hasIgnore(String qName) {
        return this.ignoreList != null && qName != null && this.ignoreList.contains(qName);
    }

    private void loadKeepers(String doc) {
        this.coercionList = new ArrayList<String>();
        String keepToken = JSRoyaleEmitterTokens.EMIT_COERCION.getToken();
        int index = doc.indexOf(keepToken);
        while (index != -1) {
            String keeper = doc.substring(index + keepToken.length());
            int endIndex = keeper.indexOf("\n");
            keeper = keeper.substring(0, endIndex);
            keeper = keeper.trim();
            this.coercionList.add(keeper);
            index = doc.indexOf(keepToken, index + endIndex);
        }
    }

    private String changeAnnotations(String doc) {
        String pass1 = doc.replaceAll("@param", "@asparam");
        String pass2 = pass1.replaceAll("@return", "@asreturn");
        String pass3 = pass2.replaceAll("@private", "@asprivate");
        return pass3;
    }

    @Override
    public void emitInterfaceMemberDoc(IDefinitionNode node, ICompilerProject project) {
        IParameterNode[] parameters;
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        boolean hasDoc = false;
        ASDocComment asDoc = (ASDocComment)((IFunctionNode)node).getASDocComment();
        String returnType = ((IFunctionNode)node).getReturnType();
        if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
            if (asDoc != null && keepASDoc) {
                this.write(this.changeAnnotations(asDoc.commentNoEnd()));
            } else {
                this.begin();
            }
            hasDoc = true;
            ITypeDefinition tdef = ((IFunctionDefinition)node.getDefinition()).resolveReturnType(project);
            this.emitReturn((IFunctionNode)node, tdef.getPackageName(), project);
        }
        for (IParameterNode pnode : parameters = ((IFunctionNode)node).getParameterNodes()) {
            if (!hasDoc) {
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
            }
            IExpressionNode enode = pnode.getNameExpressionNode();
            this.emitParam(pnode, enode.resolveType(project).getPackageName(), project);
        }
        if (hasDoc) {
            this.end();
        }
    }

    public void emitMethodAccess(IFunctionNode node) {
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        } else if (ns == "internal") {
            this.emitInternal((IASNode)node);
        } else {
            this.emitPublic((IASNode)node);
        }
    }

    protected void emitMethodNoCollapse(IFunctionNode node, RoyaleJSProject fjp) {
        String ns = node.getNamespace();
        if (ns == "protected") {
            boolean preventRenameProtected;
            boolean bl = preventRenameProtected = fjp.config != null && fjp.config.getPreventRenameProtectedSymbols();
            if (preventRenameProtected) {
                this.emitNoCollapse((IDefinitionNode)node);
            }
        } else if (ns == "internal") {
            boolean preventRenameInternal;
            boolean bl = preventRenameInternal = fjp.config != null && fjp.config.getPreventRenameInternalSymbols();
            if (preventRenameInternal) {
                this.emitNoCollapse((IDefinitionNode)node);
            }
        } else if (ns != "private") {
            boolean preventRenamePublic;
            boolean bl = preventRenamePublic = fjp.config != null && fjp.config.getPreventRenamePublicSymbols();
            if (preventRenamePublic) {
                this.emitNoCollapse((IDefinitionNode)node);
            }
        }
    }

    @Override
    public void emitVarDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        if (!node.isConst()) {
            ITypeDefinition type;
            IDefinition ndef = node.getDefinition();
            if (this.emitter != null && this.emitter instanceof JSRoyaleEmitter && (type = ndef.resolveType(project)) != null) {
                packageName = type.getPackageName();
            }
            this.emitTypeShort(node, project.getActualPackageName(packageName), project);
        } else {
            this.writeNewline();
            this.begin();
            this.emitConst(node);
            this.emitType((IASNode)node, project.getActualPackageName(packageName), project);
            this.end();
        }
    }

    @Override
    public void emitConst(IVariableNode node) {
        this.emitJSDocLine(ASEmitterTokens.CONST);
    }

    @Override
    public void emitExtends(IClassDefinition superDefinition, String packageName) {
        this.emitJSDocLine(ASEmitterTokens.EXTENDS, this.formatQualifiedName(superDefinition.getQualifiedName()));
    }

    @Override
    public void emitImplements(ITypeDefinition definition, String packageName) {
        this.emitJSDocLine(ASEmitterTokens.IMPLEMENTS, this.formatQualifiedName(definition.getQualifiedName()));
    }

    @Override
    public void emitOverride(IFunctionNode node) {
        this.emitJSDocLine(ASEmitterTokens.OVERRIDE);
    }

    @Override
    public void emitParam(IParameterNode node, String packageName, ICompilerProject project) {
        String postfix = node.getDefaultValue() == null ? "" : ASEmitterTokens.EQUAL.getToken();
        String paramType = "";
        if (node.isRest()) {
            paramType = ASEmitterTokens.ELLIPSIS.getToken();
        } else {
            String[] parts;
            ITypeDefinition resolvedTypeDef;
            String typeName = node.getVariableType();
            if (project.getInferTypes() && typeName.isEmpty() && (resolvedTypeDef = SemanticUtils.resolveVariableInferredType((IVariableNode)node, (ICompilerProject)project)) != null) {
                typeName = resolvedTypeDef.getQualifiedName();
            }
            if (packageName.length() > 0 && typeName.indexOf(packageName) > -1 && (parts = typeName.split("\\.")).length > 0) {
                typeName = parts[parts.length - 1];
            }
            paramType = this.convertASTypeToJS(typeName, packageName);
        }
        this.emitJSDocLine(JSRoyaleDocEmitterTokens.PARAM, paramType + postfix, node.getName());
    }

    @Override
    public void emitReturn(IFunctionNode node, String packageName, ICompilerProject project) {
        String rtype = node.getReturnType();
        if (project.getInferTypes() && (rtype == null || rtype.isEmpty())) {
            ITypeDefinition resolvedTypeDef = SemanticUtils.resolveFunctionInferredReturnType((IFunctionNode)node, (ICompilerProject)project);
            rtype = resolvedTypeDef != null ? resolvedTypeDef.getQualifiedName() : "*";
        }
        if (rtype != null && rtype != ASEmitterTokens.VOID.getToken()) {
            this.emitJSDocLine(ASEmitterTokens.RETURN, this.convertASTypeToJS(rtype, packageName));
        }
    }

    @Override
    public void emitThis(ITypeDefinition type, String packageName) {
        this.emitJSDocLine(ASEmitterTokens.THIS.getToken(), type.getQualifiedName());
    }

    @Override
    public void emitType(IASNode node, String packageName, ICompilerProject project) {
        ITypeDefinition elemenTypeDef;
        ITypeDefinition resolvedTypeDef;
        IVariableNode varNode = (IVariableNode)node;
        Object type = varNode.getVariableType();
        if (project.getInferTypes() && ((String)type).isEmpty() && (resolvedTypeDef = SemanticUtils.resolveVariableInferredType((IVariableNode)varNode, (ICompilerProject)project)) != null) {
            type = resolvedTypeDef.getQualifiedName();
        }
        if (varNode.getVariableTypeNode() instanceof TypedExpressionNode && (elemenTypeDef = ((TypedExpressionNode)varNode.getVariableTypeNode()).getTypeNode().resolveType(project)) != null) {
            type = "Vector.<" + this.convertASTypeToJS(elemenTypeDef.getQualifiedName(), "") + ">";
            packageName = "";
        }
        this.emitJSDocLine(JSRoyaleDocEmitterTokens.TYPE.getToken(), this.convertASTypeToJS((String)type, packageName));
    }

    @Override
    public void emitType(String type, String packageName) {
        this.emitJSDocLine(JSRoyaleDocEmitterTokens.TYPE.getToken(), this.convertASTypeToJS(type, packageName));
    }

    public void emitTypeShort(IVariableNode node, String packageName, ICompilerProject project) {
        ITypeDefinition elemenTypeDef;
        ITypeDefinition resolvedTypeDef;
        Object type = node.getVariableType();
        if (project.getInferTypes() && ((String)type).isEmpty() && (resolvedTypeDef = SemanticUtils.resolveVariableInferredType((IVariableNode)node, (ICompilerProject)project)) != null) {
            type = resolvedTypeDef.getQualifiedName();
        }
        if (node.getVariableTypeNode() instanceof TypedExpressionNode && (elemenTypeDef = ((TypedExpressionNode)node.getVariableTypeNode()).getTypeNode().resolveType(project)) != null) {
            type = "Vector.<" + this.convertASTypeToJS(elemenTypeDef.getQualifiedName(), "") + ">";
            packageName = "";
        }
        this.writeToken(JSDocEmitterTokens.JSDOC_OPEN);
        this.write(ASEmitterTokens.ATSIGN);
        this.writeToken(JSRoyaleDocEmitterTokens.TYPE);
        this.writeBlockOpen();
        this.write(this.convertASTypeToJS((String)type, packageName));
        this.writeBlockClose();
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(JSDocEmitterTokens.JSDOC_CLOSE);
    }

    private JSSessionModel getModel() {
        if (this.emitter instanceof IJSEmitter) {
            return ((IJSEmitter)this.emitter).getModel();
        }
        return null;
    }

    protected void emitNoCollapse(IDefinitionNode node) {
        if (!node.hasModifier(ASModifier.STATIC) || node instanceof IAccessorNode || "private".equals(node.getNamespace())) {
            return;
        }
        if (this.getModel() != null && (this.getModel().suppressExports || this.getModel().suppressedExportNodes.contains(node))) {
            return;
        }
        this.emitJSDocLine(JSRoyaleDocEmitterTokens.NOCOLLAPSE);
    }

    @Override
    public void emitFieldDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        boolean preventRename;
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        this.emitExports = false;
        this.exportProtected = false;
        this.exportInternal = false;
        this.begin();
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
            boolean bl = preventRename = fjp.config != null && fjp.config.getPreventRenameProtectedSymbols();
            if (preventRename) {
                this.emitNoCollapse((IDefinitionNode)node);
            }
        } else if (ns == "internal") {
            this.emitInternal((IASNode)node);
            boolean bl = preventRename = fjp.config != null && fjp.config.getPreventRenameInternalSymbols();
            if (preventRename) {
                this.emitNoCollapse((IDefinitionNode)node);
            }
        } else {
            boolean avoidExport;
            IMetaTagNode tag;
            boolean warnPublicVars = fjp.config != null && fjp.config.getWarnPublicVars() && !fjp.config.getPreventRenamePublicSymbols() && !fjp.config.getMxmlReflectObjectProperty();
            IMetaTagsNode meta = node.getMetaTags();
            boolean bindable = false;
            if (meta != null && (tag = meta.getTagByName("Bindable")) != null) {
                bindable = true;
            }
            if (warnPublicVars && !node.isConst() && !bindable && ns.contentEquals("public")) {
                IVariableNode warningNode = node;
                int childCount = node.getChildCount();
                for (int index = 0; index < childCount; ++index) {
                    IASNode child = node.getChild(index);
                    if (!(child instanceof IIdentifierNode) || !((IIdentifierNode)child).getName().equals("public")) continue;
                    warningNode = child;
                    break;
                }
                if (!this.suppressedWarning(node, fjp)) {
                    fjp.getProblems().add(new PublicVarWarningProblem(node.getSourcePath(), node.getStart(), node.getEnd(), warningNode.getLine(), warningNode.getColumn(), node.getEndLine(), node.getEndColumn()));
                }
            }
            if (!(avoidExport = ASNodeUtils.hasExportSuppressed((IDocumentableDefinitionNode)node))) {
                if (ns.equals("public")) {
                    boolean preventRename2;
                    this.emitPublic((IASNode)node);
                    boolean bl = preventRename2 = fjp.config != null && fjp.config.getPreventRenamePublicSymbols();
                    if (preventRename2) {
                        this.emitNoCollapse((IDefinitionNode)node);
                    }
                }
            } else {
                ((JSRoyaleEmitter)this.emitter).getModel().suppressedExportNodes.add((IASNode)node);
            }
        }
        if (node.isConst()) {
            this.emitConst(node);
        }
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        this.emitType((IASNode)node, project.getActualPackageName(packageName), project);
        this.end();
    }

    @Override
    public void emitPrivate(IASNode node) {
        this.emitJSDocLine(ASEmitterTokens.PRIVATE);
    }

    @Override
    public void emitProtected(IASNode node) {
        if (this.exportProtected) {
            this.emitPublic(node);
        } else {
            this.emitJSDocLine(ASEmitterTokens.PROTECTED);
        }
    }

    @Override
    public void emitInternal(IASNode node) {
        if (this.exportInternal) {
            this.emitPublic(node);
        } else {
            this.emitJSDocLine(JSRoyaleDocEmitterTokens.PACKAGE);
        }
    }

    @Override
    public void emitPublic(IASNode node) {
        if (this.emitExports) {
            this.emitJSDocLine(JSRoyaleDocEmitterTokens.EXPORT);
        }
    }

    private boolean suppressedWarning(IVariableNode node, RoyaleJSProject fjp) {
        String docText;
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        String suppressToken = JSRoyaleEmitterTokens.SUPPRESS_PUBLIC_VAR_WARNING.getToken();
        if (asDoc != null && keepASDoc && (docText = asDoc.commentNoEnd()).contains(suppressToken)) {
            return true;
        }
        IASNode classNode = node.getParent().getParent();
        if (classNode == null) {
            return false;
        }
        if (classNode.getNodeID() == ASTNodeID.ClassID) {
            String docText2;
            asDoc = (ASDocComment)((IClassNode)classNode).getASDocComment();
            if (asDoc != null && keepASDoc && (docText2 = asDoc.commentNoEnd()).contains(suppressToken)) {
                return true;
            }
            IClassDefinition cdef = ((IClassNode)classNode).getDefinition();
            if (cdef.isBindable()) {
                return true;
            }
            if (!cdef.isPublic()) {
                return true;
            }
        }
        return false;
    }

    public void emitPackageHeader(IPackageNode node) {
        this.begin();
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(JSDocEmitterTokens.JSDOC_LINE_START);
        this.write(JSRoyaleDocEmitter.getTimeStampString());
        this.end();
    }

    protected void emitJSDocLine(IEmitterTokens name) {
        this.emitJSDocLine(name.getToken(), "");
    }

    private void emitJSDocLine(String name) {
        this.emitJSDocLine(name, "");
    }

    protected void emitJSDocLine(IEmitterTokens name, String type) {
        this.emitJSDocLine(name.getToken(), type, "");
    }

    private void emitJSDocLine(String name, String type) {
        this.emitJSDocLine(name, type, "");
    }

    private void emitJSDocLine(IEmitterTokens name, String type, String param) {
        this.emitJSDocLine(name.getToken(), type, param);
    }

    private void emitJSDocLine(String name, String type, String param) {
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(JSDocEmitterTokens.JSDOC_LINE_START);
        this.write(ASEmitterTokens.ATSIGN);
        this.write(name);
        if (type != "") {
            this.write(ASEmitterTokens.SPACE);
            this.writeBlockOpen();
            this.write(type);
            this.writeBlockClose();
        }
        if (param != "") {
            this.write(ASEmitterTokens.SPACE);
            this.write(param);
        }
        this.writeNewline();
    }

    protected IClassDefinition resolveClassDefinition(IFunctionNode node) {
        IScopedNode scope = node.getContainingScope();
        if (scope instanceof IMXMLDocumentNode) {
            return ((IMXMLDocumentNode)scope).getClassDefinition();
        }
        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        if (cnode == null) {
            return null;
        }
        return cnode.getDefinition();
    }

    public static String now() {
        String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(cal.getTime());
    }

    public static String getTimeStampString() {
        return "CROSS-COMPILED BY MXMLJSC (329449.1) ON " + JSRoyaleDocEmitter.now() + "\n";
    }
}

