/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;

public class ForEachEmitter
extends JSSubEmitter
implements ISubEmitter<IForLoopNode> {
    public ForEachEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IForLoopNode node) {
        IContainerNode cnode = node.getConditionalsContainerNode();
        IBinaryOperatorNode bnode = (IBinaryOperatorNode)cnode.getChild(0);
        IExpressionNode childNode = bnode.getLeftOperandNode();
        IExpressionNode rnode = bnode.getRightOperandNode();
        String iterName = this.getModel().getCurrentForeachName();
        this.getModel().incForeachLoopCount();
        String targetName = iterName + "_target";
        this.startMapping((ISourceLocation)rnode);
        this.write(ASEmitterTokens.VAR);
        this.write(ASEmitterTokens.SPACE);
        this.write(targetName);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.endMapping((ISourceLocation)rnode);
        IASNode obj = bnode.getChild(1);
        this.getWalker().walk(obj);
        this.startMapping((ISourceLocation)rnode);
        this.write(ASEmitterTokens.SEMICOLON);
        this.endMapping((ISourceLocation)rnode);
        this.writeNewline();
        if (node.getParent().getNodeID() == ASTNodeID.BlockID && node.getParent().getParent().getNodeID() == ASTNodeID.LabledStatementID) {
            LabeledStatementNode labelNode = (LabeledStatementNode)node.getParent().getParent();
            this.writeToken(labelNode.getLabel());
            this.writeToken(ASEmitterTokens.COLON);
        }
        this.startMapping((ISourceLocation)node);
        this.write(ASEmitterTokens.FOR);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        this.startMapping((ISourceLocation)rnode);
        this.write(ASEmitterTokens.VAR);
        this.write(ASEmitterTokens.SPACE);
        this.write(iterName);
        this.endMapping((ISourceLocation)rnode);
        this.startMapping((ISourceLocation)bnode, (ISourceLocation)childNode);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.IN);
        this.write(ASEmitterTokens.SPACE);
        this.endMapping((ISourceLocation)bnode);
        this.startMapping((ISourceLocation)rnode);
        this.write(targetName);
        boolean isXML = false;
        boolean isProxy = false;
        if (obj.getNodeID() == ASTNodeID.IdentifierID) {
            if (((JSRoyaleEmitter)this.getEmitter()).isXMLish((IExpressionNode)((IdentifierNode)obj))) {
                this.write(".elementNames()");
                isXML = true;
            }
            if (((JSRoyaleEmitter)this.getEmitter()).isProxy((IExpressionNode)((IdentifierNode)obj))) {
                this.emitNullSafeProxyTarget(targetName);
                isProxy = true;
            }
        } else if (obj.getNodeID() == ASTNodeID.Op_DescendantsID) {
            if (((JSRoyaleEmitter)this.getEmitter()).isXMLList((IMemberAccessExpressionNode)obj)) {
                this.write(".elementNames()");
                isXML = true;
            }
        } else if (obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            if (((JSRoyaleEmitter)this.getEmitter()).isXMLList((IMemberAccessExpressionNode)obj)) {
                this.write(".elementNames()");
                isXML = true;
            }
            if (((JSRoyaleEmitter)this.getEmitter()).isProxy((IExpressionNode)((IMemberAccessExpressionNode)obj))) {
                this.emitNullSafeProxyTarget(targetName);
                isProxy = true;
            }
        } else if (obj.getNodeID() == ASTNodeID.Op_AsID) {
            IASNode asChild = obj.getChild(1);
            if (asChild.getNodeID() == ASTNodeID.IdentifierID) {
                String asName = ((IdentifierNode)asChild).getName();
                if (asName.equals("XML") || asName.equals("XMLList")) {
                    this.write(".elementNames()");
                    isXML = true;
                } else {
                    RoyaleProject project;
                    IClassDefinition asTarget = (IClassDefinition)((IdentifierNode)asChild).resolve(this.getProject());
                    if (asTarget != null && asTarget.isInstanceOf((project = (RoyaleProject)this.getProject()).getProxyBaseClass(), (ICompilerProject)project)) {
                        this.emitNullSafeProxyTarget(targetName);
                        isProxy = true;
                    }
                }
            }
        } else if (obj.getNodeID() == ASTNodeID.FunctionCallID) {
            FunctionCallNode func = (FunctionCallNode)obj;
            ExpressionNodeBase funcName = func.getNameNode();
            if (funcName.getNodeID() == ASTNodeID.IdentifierID) {
                String asName = ((IdentifierNode)funcName).getName();
                if (asName.equals("XML") || asName.equals("XMLList")) {
                    this.write(".elementNames()");
                    isXML = true;
                } else {
                    RoyaleProject project;
                    IDefinition funcNameDef = funcName.resolve(this.getProject());
                    if (funcNameDef instanceof IFunctionDefinition) {
                        funcNameDef = ((IFunctionDefinition)funcNameDef).resolveReturnType(this.getProject());
                    }
                    if (funcNameDef instanceof IClassDefinition && ((IClassDefinition)funcNameDef).isInstanceOf((project = (RoyaleProject)this.getProject()).getProxyBaseClass(), (ICompilerProject)project)) {
                        this.emitNullSafeProxyTarget(targetName);
                        isProxy = true;
                    }
                }
            } else if (funcName instanceof IMemberAccessExpressionNode) {
                IFunctionDefinition funcDef = (IFunctionDefinition)((IMemberAccessExpressionNode)funcName).getRightOperandNode().resolve(this.getProject());
                if (funcDef == null) {
                    IDefinitionSet matchingDefinitions = null;
                    if (EmitterUtils.isLeftNodeXML(((IMemberAccessExpressionNode)funcName).getLeftOperandNode(), this.getProject())) {
                        if (((IMemberAccessExpressionNode)funcName).getRightOperandNode().getNodeID() == ASTNodeID.IdentifierID) {
                            matchingDefinitions = this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.XML).getContainedScope().getLocalDefinitionSetByName(((IIdentifierNode)((IMemberAccessExpressionNode)funcName).getRightOperandNode()).getName());
                        }
                    } else if (EmitterUtils.isLeftNodeXMLList(((IMemberAccessExpressionNode)funcName).getLeftOperandNode(), this.getProject()) && ((IMemberAccessExpressionNode)funcName).getRightOperandNode().getNodeID() == ASTNodeID.IdentifierID) {
                        matchingDefinitions = this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST).getContainedScope().getLocalDefinitionSetByName(((IIdentifierNode)((IMemberAccessExpressionNode)funcName).getRightOperandNode()).getName());
                    }
                    if (matchingDefinitions != null) {
                        for (int i = 0; i < matchingDefinitions.getSize(); ++i) {
                            IDefinition functionDefinition = matchingDefinitions.getDefinition(i);
                            if (!(functionDefinition instanceof IFunctionDefinition) || !functionDefinition.isPublic()) continue;
                            isXML = SemanticUtils.isXMLish((IDefinition)((IFunctionDefinition)functionDefinition).resolveReturnType(this.getProject()), (ICompilerProject)this.getProject());
                            break;
                        }
                    }
                } else {
                    RoyaleProject project;
                    IClassDefinition returnType = (IClassDefinition)funcDef.resolveReturnType(this.getProject());
                    isXML = SemanticUtils.isXMLish((IDefinition)returnType, (ICompilerProject)this.getProject());
                    if (!isXML && returnType.isInstanceOf((project = (RoyaleProject)this.getProject()).getProxyBaseClass(), (ICompilerProject)project)) {
                        this.emitNullSafeProxyTarget(targetName);
                        isProxy = true;
                    }
                }
                if (isXML) {
                    this.write(".elementNames()");
                }
            }
        }
        this.endMapping((ISourceLocation)rnode);
        this.startMapping((ISourceLocation)node, (ISourceLocation)cnode);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.endMapping((ISourceLocation)node);
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.writeNewline();
        if (childNode instanceof IVariableExpressionNode) {
            this.startMapping((ISourceLocation)childNode);
            this.write(ASEmitterTokens.VAR);
            this.write(ASEmitterTokens.SPACE);
            this.write(((IVariableNode)childNode.getChild(0)).getName());
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.SPACE);
            this.endMapping((ISourceLocation)childNode);
        } else {
            this.getWalker().walk((IASNode)childNode);
            this.startMapping((ISourceLocation)childNode);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.SPACE);
            this.endMapping((ISourceLocation)childNode);
        }
        this.startMapping((ISourceLocation)rnode);
        this.write(targetName);
        if (isXML) {
            this.write("[");
            this.write(iterName);
            this.write("]");
        } else if (isProxy) {
            this.write(".getProperty(");
            this.write(iterName);
            this.write(")");
        } else {
            this.write(ASEmitterTokens.SQUARE_OPEN);
            this.write(iterName);
            this.write(ASEmitterTokens.SQUARE_CLOSE);
        }
        this.write(ASEmitterTokens.SEMICOLON);
        this.endMapping((ISourceLocation)rnode);
        this.writeNewline();
        this.getWalker().walk(node.getStatementContentsNode());
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.writeNewline();
    }

    void emitNullSafeProxyTarget(String targetName) {
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.LOGICAL_AND);
        this.write(targetName);
        this.write(".propertyNames()");
    }
}

