/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.tools.oem.VirtualLocalFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class VirtualLocalFileSystem {
    private final Map<String, VirtualLocalFile> files = new HashMap<String, VirtualLocalFile>();

    public final VirtualLocalFile create(String name, String text, File parent, long lastModified) {
        VirtualLocalFile f = new VirtualLocalFile(name, text, parent, lastModified, this);
        this.files.put(name, f);
        return f;
    }

    public final boolean update(String name, String text, long lastModified) {
        VirtualLocalFile f = this.files.get(name);
        if (f != null) {
            f.text = text;
            f.lastModified = lastModified;
            return true;
        }
        return false;
    }

    final VirtualFile resolve(VirtualLocalFile base, String name) {
        VirtualLocalFile f = this.files.get(name);
        if (f != null) {
            return f;
        }
        String fullName = this.constructName(base, name);
        f = this.files.get(fullName);
        if (f != null) {
            return f;
        }
        File absolute = FileUtil.openFile(name);
        if (absolute != null && absolute.exists()) {
            return new LocalFile(absolute);
        }
        File relative = FileUtil.openFile(fullName);
        if (relative != null && relative.exists()) {
            return new LocalFile(relative);
        }
        return null;
    }

    private String constructName(VirtualLocalFile base, String relativeName) {
        return FileUtil.getCanonicalPath(FileUtil.openFile(base.getParent() + File.separator + relativeName));
    }
}

