/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ConsoleLogger;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.URLPathResolver;
import java.io.File;
import java.io.IOException;

public final class CompilerAPI {
    public static void useAS3() {
        System.setProperty("AS3", "");
        System.setProperty("AVMPLUS", "");
    }

    public static void useConsoleLogger() {
        CompilerAPI.useConsoleLogger(true, true, true, true);
    }

    public static void useConsoleLogger(boolean isInfoEnabled, boolean isDebugEnabled, boolean isWarningEnabled, boolean isErrorEnabled) {
        ThreadLocalToolkit.setLogger(new ConsoleLogger(isInfoEnabled, isDebugEnabled, isWarningEnabled, isErrorEnabled));
    }

    public static void usePathResolver() {
        CompilerAPI.usePathResolver(null);
    }

    public static void usePathResolver(SinglePathResolver resolver) {
        PathResolver pathResolver = new PathResolver();
        if (resolver != null) {
            pathResolver.addSinglePathResolver(resolver);
        }
        pathResolver.addSinglePathResolver(LocalFilePathResolver.getSingleton());
        pathResolver.addSinglePathResolver(URLPathResolver.getSingleton());
        ThreadLocalToolkit.setPathResolver(pathResolver);
    }

    public static void removePathResolver() {
        ThreadLocalToolkit.setPathResolver(null);
        ThreadLocalToolkit.resetResolvedPaths();
    }

    static String constructClassName(String namespaceURI, String localPart) {
        return namespaceURI.length() == 0 ? localPart : new StringBuilder(namespaceURI.length() + localPart.length() + 1).append(namespaceURI).append(":").append(localPart).toString();
    }

    public static VirtualFile getVirtualFile(String path) throws ConfigurationException {
        return CompilerAPI.getVirtualFile(path, true);
    }

    public static VirtualFile getVirtualFile(String path, boolean reportError) throws ConfigurationException {
        VirtualFile result = null;
        File file = new File(path);
        if (file.exists()) {
            try {
                result = new LocalFile(file.getCanonicalFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            result = resolver.resolve(path);
            if (result == null && reportError) {
                throw new ConfigurationException.IOError(path);
            }
        }
        return result;
    }
}

