/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.java.example.ProducerSingleton;
import org.apache.rocketmq.client.java.exception.LiteTopicQuotaExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteProducerExample {
    static final Logger log = LoggerFactory.getLogger(LiteProducerExample.class);

    private LiteProducerExample() {
    }

    public static void main(String[] args) throws ClientException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String topic = "yourParentTopic";
        Producer producer = ProducerSingleton.getInstance(topic);
        byte[] body = "This is a lite message for Apache RocketMQ".getBytes(StandardCharsets.UTF_8);
        Message message = provider.newMessageBuilder().setTopic(topic).setKeys(new String[]{"yourMessageKey-3ee439f945d7"}).setLiteTopic("lite-topic-1").setBody(body).build();
        try {
            SendReceipt sendReceipt = producer.send(message);
            log.info("Send message successfully, messageId={}", (Object)sendReceipt.getMessageId());
        }
        catch (LiteTopicQuotaExceededException e) {
            log.error("Lite topic quota exceeded", (Throwable)((Object)e));
        }
        catch (Throwable t) {
            log.error("Failed to send message", t);
        }
    }
}

