/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.proxy.remoting.protocol.ProtocolHandler;

public class ProtocolNegotiationHandler
extends ByteToMessageDecoder {
    private final List<ProtocolHandler> protocolHandlerList = new ArrayList<ProtocolHandler>();
    private final ProtocolHandler fallbackProtocolHandler;

    public ProtocolNegotiationHandler(ProtocolHandler fallbackProtocolHandler) {
        this.fallbackProtocolHandler = fallbackProtocolHandler;
    }

    public ProtocolNegotiationHandler addProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandlerList.add(protocolHandler);
        return this;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        ProtocolHandler protocolHandler = null;
        for (ProtocolHandler curProtocolHandler : this.protocolHandlerList) {
            if (!curProtocolHandler.match(in)) continue;
            protocolHandler = curProtocolHandler;
            break;
        }
        if (protocolHandler == null) {
            protocolHandler = this.fallbackProtocolHandler;
        }
        protocolHandler.config(ctx, in);
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

