/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.statictopic;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.remoting.protocol.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingOne;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicRemappingDetailWrapper;

public class TopicQueueMappingUtils {
    public static final int DEFAULT_BLOCK_SEQ_SIZE = 10000;

    public static MappingAllocator buildMappingAllocator(Map<Integer, String> idToBroker, Map<String, Integer> brokerNumMap, Map<String, Integer> brokerNumMapBeforeRemapping) {
        return new MappingAllocator(idToBroker, brokerNumMap, brokerNumMapBeforeRemapping);
    }

    public static Map.Entry<Long, Integer> findMaxEpochAndQueueNum(List<TopicQueueMappingDetail> mappingDetailList) {
        long epoch = -1L;
        int queueNum = 0;
        for (TopicQueueMappingDetail mappingDetail : mappingDetailList) {
            if (mappingDetail.getEpoch() > epoch) {
                epoch = mappingDetail.getEpoch();
            }
            if (mappingDetail.getTotalQueues() <= queueNum) continue;
            queueNum = mappingDetail.getTotalQueues();
        }
        return new AbstractMap.SimpleImmutableEntry<Long, Integer>(epoch, queueNum);
    }

    public static List<TopicQueueMappingDetail> getMappingDetailFromConfig(Collection<TopicConfigAndQueueMapping> configs) {
        ArrayList<TopicQueueMappingDetail> detailList = new ArrayList<TopicQueueMappingDetail>();
        for (TopicConfigAndQueueMapping configMapping : configs) {
            if (configMapping.getMappingDetail() == null) continue;
            detailList.add(configMapping.getMappingDetail());
        }
        return detailList;
    }

    public static Map.Entry<Long, Integer> checkNameEpochNumConsistence(String topic, Map<String, TopicConfigAndQueueMapping> brokerConfigMap) {
        if (brokerConfigMap == null || brokerConfigMap.isEmpty()) {
            return null;
        }
        long maxEpoch = -1L;
        int maxNum = -1;
        String scope = null;
        for (Map.Entry<String, TopicConfigAndQueueMapping> entry : brokerConfigMap.entrySet()) {
            String broker = entry.getKey();
            TopicConfigAndQueueMapping configMapping = entry.getValue();
            if (configMapping.getMappingDetail() == null) {
                throw new RuntimeException("Mapping info should not be null in broker " + broker);
            }
            TopicQueueMappingDetail mappingDetail = configMapping.getMappingDetail();
            if (!broker.equals(mappingDetail.getBname())) {
                throw new RuntimeException(String.format("The broker name is not equal %s != %s ", broker, mappingDetail.getBname()));
            }
            if (mappingDetail.isDirty()) {
                throw new RuntimeException("The mapping info is dirty in broker  " + broker);
            }
            if (!configMapping.getTopicName().equals(mappingDetail.getTopic())) {
                throw new RuntimeException("The topic name is inconsistent in broker  " + broker);
            }
            if (topic != null && !topic.equals(mappingDetail.getTopic())) {
                throw new RuntimeException("The topic name is not match for broker  " + broker);
            }
            if (scope != null && !scope.equals(mappingDetail.getScope())) {
                throw new RuntimeException(String.format("scope does not match %s != %s in %s", mappingDetail.getScope(), scope, broker));
            }
            scope = mappingDetail.getScope();
            if (maxEpoch != -1L && maxEpoch != mappingDetail.getEpoch()) {
                throw new RuntimeException(String.format("epoch does not match %d != %d in %s", maxEpoch, mappingDetail.getEpoch(), mappingDetail.getBname()));
            }
            maxEpoch = mappingDetail.getEpoch();
            if (maxNum != -1 && maxNum != mappingDetail.getTotalQueues()) {
                throw new RuntimeException(String.format("total queue number does not match %d != %d in %s", maxNum, mappingDetail.getTotalQueues(), mappingDetail.getBname()));
            }
            maxNum = mappingDetail.getTotalQueues();
        }
        return new AbstractMap.SimpleEntry<Long, Integer>(maxEpoch, maxNum);
    }

    public static String getMockBrokerName(String scope) {
        assert (scope != null);
        if (scope.equals("__global__")) {
            return "__syslo__" + scope.substring(2);
        }
        return "__syslo__" + scope;
    }

    public static void makeSureLogicQueueMappingItemImmutable(List<LogicQueueMappingItem> oldItems, List<LogicQueueMappingItem> newItems, boolean epochEqual, boolean isCLean) {
        if (oldItems == null || oldItems.isEmpty()) {
            return;
        }
        if (newItems == null || newItems.isEmpty()) {
            throw new RuntimeException("The new item list is null or empty");
        }
        int iold = 0;
        int inew = 0;
        while (iold < oldItems.size() && inew < newItems.size()) {
            LogicQueueMappingItem newItem = newItems.get(inew);
            LogicQueueMappingItem oldItem = oldItems.get(iold);
            if (newItem.getGen() < oldItem.getGen()) {
                ++inew;
                continue;
            }
            if (oldItem.getGen() < newItem.getGen()) {
                ++iold;
                continue;
            }
            assert (oldItem.getBname().equals(newItem.getBname()));
            assert (oldItem.getQueueId() == newItem.getQueueId());
            assert (oldItem.getStartOffset() == newItem.getStartOffset());
            if (oldItem.getLogicOffset() != -1L) assert (oldItem.getLogicOffset() == newItem.getLogicOffset());
            ++iold;
            ++inew;
        }
        if (epochEqual) {
            LogicQueueMappingItem oldLeader = oldItems.get(oldItems.size() - 1);
            LogicQueueMappingItem newLeader = newItems.get(newItems.size() - 1);
            if (newLeader.getGen() != oldLeader.getGen() || !newLeader.getBname().equals(oldLeader.getBname()) || newLeader.getQueueId() != oldLeader.getQueueId() || newLeader.getStartOffset() != oldLeader.getStartOffset()) {
                throw new RuntimeException("The new leader is different but epoch equal");
            }
        }
    }

    public static void checkLogicQueueMappingItemOffset(List<LogicQueueMappingItem> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        int lastGen = -1;
        long lastOffset = -1L;
        for (int i = items.size() - 1; i >= 0; --i) {
            LogicQueueMappingItem item = items.get(i);
            if (item.getStartOffset() < 0L || item.getGen() < 0 || item.getQueueId() < 0) {
                throw new RuntimeException("The field is illegal, should not be negative");
            }
            if (items.size() >= 2 && i <= items.size() - 2 && items.get(i).getLogicOffset() < 0L) {
                throw new RuntimeException("The non-latest item has negative logic offset");
            }
            if (lastGen != -1 && item.getGen() >= lastGen) {
                throw new RuntimeException("The gen does not increase monotonically");
            }
            if (item.getEndOffset() != -1L && item.getEndOffset() < item.getStartOffset()) {
                throw new RuntimeException("The endOffset is smaller than the start offset");
            }
            if (lastOffset != -1L && item.getLogicOffset() != -1L) {
                if (item.getLogicOffset() >= lastOffset) {
                    throw new RuntimeException("The base logic offset does not increase monotonically");
                }
                if (item.computeMaxStaticQueueOffset() >= lastOffset) {
                    throw new RuntimeException("The max logic offset does not increase monotonically");
                }
            }
            lastGen = item.getGen();
            lastOffset = item.getLogicOffset();
        }
    }

    public static void checkIfReusePhysicalQueue(Collection<TopicQueueMappingOne> mappingOnes) {
        HashMap<String, TopicQueueMappingOne> physicalQueueIdMap = new HashMap<String, TopicQueueMappingOne>();
        for (TopicQueueMappingOne mappingOne : mappingOnes) {
            for (LogicQueueMappingItem item : mappingOne.items) {
                String physicalQueueId = item.getBname() + "-" + item.getQueueId();
                if (physicalQueueIdMap.containsKey(physicalQueueId)) {
                    throw new RuntimeException(String.format("Topic %s global queue id %d and %d shared the same physical queue %s", mappingOne.topic, mappingOne.globalId, ((TopicQueueMappingOne)physicalQueueIdMap.get((Object)physicalQueueId)).globalId, physicalQueueId));
                }
                physicalQueueIdMap.put(physicalQueueId, mappingOne);
            }
        }
    }

    public static void checkLeaderInTargetBrokers(Collection<TopicQueueMappingOne> mappingOnes, Set<String> targetBrokers) {
        for (TopicQueueMappingOne mappingOne : mappingOnes) {
            if (targetBrokers.contains(mappingOne.bname)) continue;
            throw new RuntimeException("The leader broker does not in target broker");
        }
    }

    public static void checkPhysicalQueueConsistence(Map<String, TopicConfigAndQueueMapping> brokerConfigMap) {
        for (Map.Entry<String, TopicConfigAndQueueMapping> entry : brokerConfigMap.entrySet()) {
            TopicConfigAndQueueMapping configMapping = entry.getValue();
            assert (configMapping != null);
            assert (configMapping.getMappingDetail() != null);
            if (configMapping.getReadQueueNums() < configMapping.getWriteQueueNums()) {
                throw new RuntimeException("Read queues is smaller than write queues");
            }
            for (List items : configMapping.getMappingDetail().getHostedQueues().values()) {
                for (LogicQueueMappingItem item : items) {
                    if (item.getStartOffset() != 0L) {
                        throw new RuntimeException("The start offset does not begin from 0");
                    }
                    TopicConfig topicConfig = brokerConfigMap.get(item.getBname());
                    if (topicConfig == null) {
                        throw new RuntimeException("The broker of item does not exist");
                    }
                    if (item.getQueueId() < topicConfig.getWriteQueueNums()) continue;
                    throw new RuntimeException("The physical queue id is overflow the write queues");
                }
            }
        }
    }

    public static Map<Integer, TopicQueueMappingOne> checkAndBuildMappingItems(List<TopicQueueMappingDetail> mappingDetailList, boolean replace, boolean checkConsistence) {
        mappingDetailList.sort((o1, o2) -> (int)(o2.getEpoch() - o1.getEpoch()));
        int maxNum = 0;
        HashMap<Integer, TopicQueueMappingOne> globalIdMap = new HashMap<Integer, TopicQueueMappingOne>();
        for (TopicQueueMappingDetail mappingDetail : mappingDetailList) {
            if (mappingDetail.totalQueues > maxNum) {
                maxNum = mappingDetail.totalQueues;
            }
            for (Map.Entry entry : mappingDetail.getHostedQueues().entrySet()) {
                Integer globalid = (Integer)entry.getKey();
                TopicQueueMappingUtils.checkLogicQueueMappingItemOffset((List)entry.getValue());
                String leaderBrokerName = TopicQueueMappingUtils.getLeaderBroker((List)entry.getValue());
                if (!leaderBrokerName.equals(mappingDetail.getBname())) continue;
                if (globalIdMap.containsKey(globalid)) {
                    if (replace) continue;
                    throw new RuntimeException(String.format("The queue id is duplicated in broker %s %s", leaderBrokerName, mappingDetail.getBname()));
                }
                globalIdMap.put(globalid, new TopicQueueMappingOne(mappingDetail, mappingDetail.topic, mappingDetail.bname, globalid, (List)entry.getValue()));
            }
        }
        if (checkConsistence) {
            if (maxNum != globalIdMap.size()) {
                throw new RuntimeException(String.format("The total queue number in config does not match the real hosted queues %d != %d", maxNum, globalIdMap.size()));
            }
            for (int i = 0; i < maxNum; ++i) {
                if (globalIdMap.containsKey(i)) continue;
                throw new RuntimeException(String.format("The queue number %s is not in globalIdMap", i));
            }
        }
        TopicQueueMappingUtils.checkIfReusePhysicalQueue(globalIdMap.values());
        return globalIdMap;
    }

    public static String getLeaderBroker(List<LogicQueueMappingItem> items) {
        return TopicQueueMappingUtils.getLeaderItem(items).getBname();
    }

    public static LogicQueueMappingItem getLeaderItem(List<LogicQueueMappingItem> items) {
        assert (items.size() > 0);
        return items.get(items.size() - 1);
    }

    public static String writeToTemp(TopicRemappingDetailWrapper wrapper, boolean after) {
        String topic = wrapper.getTopic();
        String data = wrapper.toJson();
        String suffix = ".before";
        if (after) {
            suffix = ".after";
        }
        String fileName = System.getProperty("java.io.tmpdir") + File.separator + topic + "-" + wrapper.getEpoch() + suffix;
        try {
            MixAll.string2File((String)data, (String)fileName);
            return fileName;
        }
        catch (Exception e) {
            throw new RuntimeException("write file failed " + fileName, e);
        }
    }

    public static long blockSeqRoundUp(long offset, long blockSeqSize) {
        long num = offset / blockSeqSize;
        long left = offset % blockSeqSize;
        if (left < blockSeqSize / 2L) {
            return (num + 1L) * blockSeqSize;
        }
        return (num + 2L) * blockSeqSize;
    }

    public static void checkTargetBrokersComplete(Set<String> targetBrokers, Map<String, TopicConfigAndQueueMapping> brokerConfigMap) {
        for (String broker : brokerConfigMap.keySet()) {
            if (brokerConfigMap.get(broker).getMappingDetail().getHostedQueues().isEmpty() || targetBrokers.contains(broker)) continue;
            throw new RuntimeException("The existed broker " + broker + " does not in target brokers ");
        }
    }

    public static void checkNonTargetBrokers(Set<String> targetBrokers, Set<String> nonTargetBrokers) {
        for (String broker : nonTargetBrokers) {
            if (!targetBrokers.contains(broker)) continue;
            throw new RuntimeException("The non-target broker exist in target broker");
        }
    }

    public static TopicRemappingDetailWrapper createTopicConfigMapping(String topic, int queueNum, Set<String> targetBrokers, Map<String, TopicConfigAndQueueMapping> brokerConfigMap) {
        TopicQueueMappingUtils.checkTargetBrokersComplete(targetBrokers, brokerConfigMap);
        Map<Object, Object> globalIdMap = new HashMap();
        Map.Entry<Long, Integer> maxEpochAndNum = new AbstractMap.SimpleImmutableEntry<Long, Integer>(System.currentTimeMillis(), queueNum);
        if (!brokerConfigMap.isEmpty()) {
            maxEpochAndNum = TopicQueueMappingUtils.checkNameEpochNumConsistence(topic, brokerConfigMap);
            globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(new ArrayList<TopicQueueMappingDetail>(TopicQueueMappingUtils.getMappingDetailFromConfig(brokerConfigMap.values())), false, true);
            TopicQueueMappingUtils.checkIfReusePhysicalQueue(globalIdMap.values());
            TopicQueueMappingUtils.checkPhysicalQueueConsistence(brokerConfigMap);
        }
        if (queueNum < globalIdMap.size()) {
            throw new RuntimeException(String.format("Cannot decrease the queue num for static topic %d < %d", queueNum, globalIdMap.size()));
        }
        if (queueNum == globalIdMap.size()) {
            throw new RuntimeException("The topic queue num is equal the existed queue num, do nothing");
        }
        HashMap<String, Integer> brokerNumMap = new HashMap<String, Integer>();
        for (String string : targetBrokers) {
            brokerNumMap.put(string, 0);
        }
        HashMap<Integer, String> oldIdToBroker = new HashMap<Integer, String>();
        for (Map.Entry<Object, Object> entry : globalIdMap.entrySet()) {
            String leaderbroker = ((TopicQueueMappingOne)entry.getValue()).getBname();
            oldIdToBroker.put((Integer)entry.getKey(), leaderbroker);
            if (!brokerNumMap.containsKey(leaderbroker)) {
                brokerNumMap.put(leaderbroker, 1);
                continue;
            }
            brokerNumMap.put(leaderbroker, (Integer)brokerNumMap.get(leaderbroker) + 1);
        }
        MappingAllocator mappingAllocator = TopicQueueMappingUtils.buildMappingAllocator(oldIdToBroker, brokerNumMap, null);
        mappingAllocator.upToNum(queueNum);
        Map<Integer, String> map = mappingAllocator.getIdToBroker();
        long newEpoch = Math.max(maxEpochAndNum.getKey() + 1000L, System.currentTimeMillis());
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            TopicConfigAndQueueMapping configMapping;
            Integer queueId = entry.getKey();
            String broker = entry.getValue();
            if (globalIdMap.containsKey(queueId)) continue;
            if (!brokerConfigMap.containsKey(broker)) {
                configMapping = new TopicConfigAndQueueMapping(new TopicConfig(topic), new TopicQueueMappingDetail(topic, 0, broker, System.currentTimeMillis()));
                configMapping.setWriteQueueNums(1);
                configMapping.setReadQueueNums(1);
                brokerConfigMap.put(broker, configMapping);
            } else {
                configMapping = brokerConfigMap.get(broker);
                configMapping.setWriteQueueNums(configMapping.getWriteQueueNums() + 1);
                configMapping.setReadQueueNums(configMapping.getReadQueueNums() + 1);
            }
            LogicQueueMappingItem mappingItem = new LogicQueueMappingItem(0, configMapping.getWriteQueueNums() - 1, broker, 0L, 0L, -1L, -1L, -1L);
            TopicQueueMappingDetail.putMappingInfo(configMapping.getMappingDetail(), queueId, new ArrayList<LogicQueueMappingItem>(Collections.singletonList(mappingItem)));
        }
        for (Map.Entry<Object, Object> entry : brokerConfigMap.entrySet()) {
            TopicConfigAndQueueMapping configMapping = (TopicConfigAndQueueMapping)((Object)entry.getValue());
            configMapping.getMappingDetail().setEpoch(newEpoch);
            configMapping.getMappingDetail().setTotalQueues(queueNum);
        }
        TopicQueueMappingUtils.checkNameEpochNumConsistence(topic, brokerConfigMap);
        globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(TopicQueueMappingUtils.getMappingDetailFromConfig(brokerConfigMap.values()), false, true);
        TopicQueueMappingUtils.checkIfReusePhysicalQueue(globalIdMap.values());
        TopicQueueMappingUtils.checkPhysicalQueueConsistence(brokerConfigMap);
        return new TopicRemappingDetailWrapper(topic, "CREATE_OR_UPDATE", newEpoch, brokerConfigMap, new HashSet<String>(), new HashSet<String>());
    }

    public static TopicRemappingDetailWrapper remappingStaticTopic(String topic, Map<String, TopicConfigAndQueueMapping> brokerConfigMap, Set<String> targetBrokers) {
        Map.Entry<Long, Integer> maxEpochAndNum = TopicQueueMappingUtils.checkNameEpochNumConsistence(topic, brokerConfigMap);
        Map<Integer, TopicQueueMappingOne> globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(TopicQueueMappingUtils.getMappingDetailFromConfig(brokerConfigMap.values()), false, true);
        TopicQueueMappingUtils.checkPhysicalQueueConsistence(brokerConfigMap);
        TopicQueueMappingUtils.checkIfReusePhysicalQueue(globalIdMap.values());
        int maxNum = maxEpochAndNum.getValue();
        HashMap<String, Integer> brokerNumMap = new HashMap<String, Integer>();
        for (String string : targetBrokers) {
            brokerNumMap.put(string, 0);
        }
        HashMap<String, Integer> brokerNumMapBeforeRemapping = new HashMap<String, Integer>();
        for (TopicQueueMappingOne mappingOne : globalIdMap.values()) {
            if (brokerNumMapBeforeRemapping.containsKey(mappingOne.bname)) {
                brokerNumMapBeforeRemapping.put(mappingOne.bname, (Integer)brokerNumMapBeforeRemapping.get(mappingOne.bname) + 1);
                continue;
            }
            brokerNumMapBeforeRemapping.put(mappingOne.bname, 1);
        }
        MappingAllocator mappingAllocator = TopicQueueMappingUtils.buildMappingAllocator(new HashMap<Integer, String>(), brokerNumMap, brokerNumMapBeforeRemapping);
        mappingAllocator.upToNum(maxNum);
        Map<String, Integer> expectedBrokerNumMap = mappingAllocator.getBrokerNumMap();
        ArrayDeque<Integer> waitAssignQueues = new ArrayDeque<Integer>();
        HashMap<Integer, String> expectedIdToBroker = new HashMap<Integer, String>();
        for (Map.Entry<Integer, TopicQueueMappingOne> entry : globalIdMap.entrySet()) {
            Integer queueId = entry.getKey();
            TopicQueueMappingOne mappingOne = entry.getValue();
            String leaderBroker = mappingOne.getBname();
            if (expectedBrokerNumMap.containsKey(leaderBroker)) {
                if (expectedBrokerNumMap.get(leaderBroker) > 0) {
                    expectedIdToBroker.put(queueId, leaderBroker);
                    expectedBrokerNumMap.put(leaderBroker, expectedBrokerNumMap.get(leaderBroker) - 1);
                    continue;
                }
                waitAssignQueues.add(queueId);
                expectedBrokerNumMap.remove(leaderBroker);
                continue;
            }
            waitAssignQueues.add(queueId);
        }
        for (Map.Entry<Object, Object> entry : expectedBrokerNumMap.entrySet()) {
            String broker = (String)entry.getKey();
            Integer queueNum = (Integer)entry.getValue();
            for (int i = 0; i < queueNum; ++i) {
                Integer n = (Integer)waitAssignQueues.poll();
                assert (n != null);
                expectedIdToBroker.put(n, broker);
            }
        }
        long newEpoch = Math.max(maxEpochAndNum.getKey() + 1000L, System.currentTimeMillis());
        HashSet<String> brokersToMapOut = new HashSet<String>();
        HashSet<String> brokersToMapIn = new HashSet<String>();
        for (Map.Entry entry : expectedIdToBroker.entrySet()) {
            Integer queueId = (Integer)entry.getKey();
            String broker = (String)entry.getValue();
            TopicQueueMappingOne topicQueueMappingOne = globalIdMap.get(queueId);
            assert (topicQueueMappingOne != null);
            if (topicQueueMappingOne.getBname().equals(broker)) continue;
            String mapInBroker = broker;
            String mapOutBroker = topicQueueMappingOne.getBname();
            brokersToMapIn.add(mapInBroker);
            brokersToMapOut.add(mapOutBroker);
            TopicConfigAndQueueMapping mapInConfig = brokerConfigMap.get(mapInBroker);
            TopicConfigAndQueueMapping mapOutConfig = brokerConfigMap.get(mapOutBroker);
            if (mapInConfig == null) {
                mapInConfig = new TopicConfigAndQueueMapping(new TopicConfig(topic, 0, 0), new TopicQueueMappingDetail(topic, maxNum, mapInBroker, newEpoch));
                brokerConfigMap.put(mapInBroker, mapInConfig);
            }
            mapInConfig.setWriteQueueNums(mapInConfig.getWriteQueueNums() + 1);
            mapInConfig.setReadQueueNums(mapInConfig.getReadQueueNums() + 1);
            ArrayList<LogicQueueMappingItem> items = new ArrayList<LogicQueueMappingItem>(topicQueueMappingOne.getItems());
            LogicQueueMappingItem last = (LogicQueueMappingItem)items.get(items.size() - 1);
            items.add(new LogicQueueMappingItem(last.getGen() + 1, mapInConfig.getWriteQueueNums() - 1, mapInBroker, -1L, 0L, -1L, -1L, -1L));
            TopicQueueMappingDetail.putMappingInfo(mapInConfig.getMappingDetail(), queueId, items);
            TopicQueueMappingDetail.putMappingInfo(mapOutConfig.getMappingDetail(), queueId, items);
        }
        for (Map.Entry<Object, Object> entry : brokerConfigMap.entrySet()) {
            TopicConfigAndQueueMapping configMapping = (TopicConfigAndQueueMapping)((Object)entry.getValue());
            configMapping.getMappingDetail().setEpoch(newEpoch);
            configMapping.getMappingDetail().setTotalQueues(maxNum);
        }
        TopicQueueMappingUtils.checkNameEpochNumConsistence(topic, brokerConfigMap);
        globalIdMap = TopicQueueMappingUtils.checkAndBuildMappingItems(TopicQueueMappingUtils.getMappingDetailFromConfig(brokerConfigMap.values()), false, true);
        TopicQueueMappingUtils.checkPhysicalQueueConsistence(brokerConfigMap);
        TopicQueueMappingUtils.checkIfReusePhysicalQueue(globalIdMap.values());
        TopicQueueMappingUtils.checkLeaderInTargetBrokers(globalIdMap.values(), targetBrokers);
        return new TopicRemappingDetailWrapper(topic, "REMAPPING", newEpoch, brokerConfigMap, brokersToMapIn, brokersToMapOut);
    }

    public static LogicQueueMappingItem findLogicQueueMappingItem(List<LogicQueueMappingItem> mappingItems, long logicOffset, boolean ignoreNegative) {
        LogicQueueMappingItem item;
        int i;
        if (mappingItems == null || mappingItems.isEmpty()) {
            return null;
        }
        for (i = mappingItems.size() - 1; i >= 0; --i) {
            item = mappingItems.get(i);
            if (ignoreNegative && item.getLogicOffset() < 0L || logicOffset < item.getLogicOffset()) continue;
            return item;
        }
        for (i = 0; i < mappingItems.size(); ++i) {
            item = mappingItems.get(i);
            if (ignoreNegative && item.getLogicOffset() < 0L) continue;
            return item;
        }
        return null;
    }

    public static LogicQueueMappingItem findNext(List<LogicQueueMappingItem> items, LogicQueueMappingItem currentItem, boolean ignoreNegative) {
        if (items == null || currentItem == null) {
            return null;
        }
        for (int i = 0; i < items.size(); ++i) {
            LogicQueueMappingItem item = items.get(i);
            if (ignoreNegative && item.getLogicOffset() < 0L || item.getGen() != currentItem.getGen()) continue;
            if (i < items.size() - 1) {
                item = items.get(i + 1);
                if (ignoreNegative && item.getLogicOffset() < 0L) {
                    return null;
                }
                return item;
            }
            return null;
        }
        return null;
    }

    public static boolean checkIfLeader(List<LogicQueueMappingItem> items, TopicQueueMappingDetail mappingDetail) {
        if (items == null || mappingDetail == null || items.isEmpty()) {
            return false;
        }
        return items.get(items.size() - 1).getBname().equals(mappingDetail.getBname());
    }

    public static class MappingAllocator {
        Map<String, Integer> brokerNumMap = new HashMap<String, Integer>();
        Map<Integer, String> idToBroker = new HashMap<Integer, String>();
        Map<String, Integer> brokerNumMapBeforeRemapping;
        int currentIndex = 0;
        List<String> leastBrokers = new ArrayList<String>();

        private MappingAllocator(Map<Integer, String> idToBroker, Map<String, Integer> brokerNumMap, Map<String, Integer> brokerNumMapBeforeRemapping) {
            this.idToBroker.putAll(idToBroker);
            this.brokerNumMap.putAll(brokerNumMap);
            this.brokerNumMapBeforeRemapping = brokerNumMapBeforeRemapping;
        }

        private void freshState() {
            int minNum = Integer.MAX_VALUE;
            for (Map.Entry<String, Integer> entry : this.brokerNumMap.entrySet()) {
                if (entry.getValue() < minNum) {
                    this.leastBrokers.clear();
                    this.leastBrokers.add(entry.getKey());
                    minNum = entry.getValue();
                    continue;
                }
                if (entry.getValue() != minNum) continue;
                this.leastBrokers.add(entry.getKey());
            }
            if (this.brokerNumMapBeforeRemapping != null && !this.brokerNumMapBeforeRemapping.isEmpty()) {
                this.leastBrokers.sort((o1, o2) -> {
                    int i1 = 0;
                    int i2 = 0;
                    if (this.brokerNumMapBeforeRemapping.containsKey(o1)) {
                        i1 = this.brokerNumMapBeforeRemapping.get(o1);
                    }
                    if (this.brokerNumMapBeforeRemapping.containsKey(o2)) {
                        i2 = this.brokerNumMapBeforeRemapping.get(o2);
                    }
                    return i1 - i2;
                });
            } else {
                Collections.shuffle(this.leastBrokers);
            }
            this.currentIndex = this.leastBrokers.size() - 1;
        }

        private String nextBroker() {
            if (this.leastBrokers.isEmpty()) {
                this.freshState();
            }
            int tmpIndex = this.currentIndex % this.leastBrokers.size();
            return this.leastBrokers.remove(tmpIndex);
        }

        public Map<String, Integer> getBrokerNumMap() {
            return this.brokerNumMap;
        }

        public void upToNum(int maxQueueNum) {
            int currSize = this.idToBroker.size();
            if (maxQueueNum <= currSize) {
                return;
            }
            for (int i = currSize; i < maxQueueNum; ++i) {
                String nextBroker = this.nextBroker();
                if (this.brokerNumMap.containsKey(nextBroker)) {
                    this.brokerNumMap.put(nextBroker, this.brokerNumMap.get(nextBroker) + 1);
                } else {
                    this.brokerNumMap.put(nextBroker, 1);
                }
                this.idToBroker.put(i, nextBroker);
            }
        }

        public Map<Integer, String> getIdToBroker() {
            return this.idToBroker;
        }
    }
}

