/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.writer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonUtil;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerJsonWriter
implements JsonWriter {
    private final Logger logger;
    private final String type;

    public LoggerJsonWriter(Logger logger, String type) {
        this.logger = logger;
        this.type = type;
    }

    @Override
    public CompletableResultCode write(Marshaler exportRequest) {
        SegmentedStringWriter sw = new SegmentedStringWriter(JsonUtil.JSON_FACTORY._getBufferRecycler());
        try (JsonGenerator gen = JsonUtil.create(sw);){
            exportRequest.writeJsonTo(gen);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Unable to write OTLP JSON " + this.type, e);
            return CompletableResultCode.ofFailure();
        }
        try {
            this.logger.log(Level.INFO, sw.getAndClear());
            return CompletableResultCode.ofSuccess();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Unable to write OTLP JSON " + this.type, e);
            return CompletableResultCode.ofFailure();
        }
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode close() {
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        return "LoggerJsonWriter";
    }
}

