/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.Timestamp;

class LeaderLease {
    private final AtomicBoolean enabled;
    private final long leaseTimeoutMs;
    private final AtomicReference<Timestamp> lease = new AtomicReference<Timestamp>(Timestamp.currentTime());

    LeaderLease(RaftProperties properties) {
        this.enabled = new AtomicBoolean(RaftServerConfigKeys.Read.leaderLeaseEnabled(properties));
        double leaseRatio = RaftServerConfigKeys.Read.leaderLeaseTimeoutRatio(properties);
        Preconditions.assertTrue(leaseRatio > 0.0 && leaseRatio <= 1.0, "leader ratio should sit in (0,1], now is " + leaseRatio);
        this.leaseTimeoutMs = RaftServerConfigKeys.Rpc.timeoutMin(properties).multiply(leaseRatio).toIntExact(TimeUnit.MILLISECONDS);
    }

    boolean getAndSetEnabled(boolean newValue) {
        return this.enabled.getAndSet(newValue);
    }

    boolean isEnabled() {
        return this.enabled.get();
    }

    boolean isValid() {
        return this.isEnabled() && this.lease.get().elapsedTimeMs() < this.leaseTimeoutMs;
    }

    void extend(List<FollowerInfo> current, List<FollowerInfo> old, Predicate<List<RaftPeerId>> hasMajority) {
        List activePeers = Stream.concat(current.stream(), Optional.ofNullable(old).map(Collection::stream).orElse(Stream.empty())).filter(f -> f.getLastRespondedAppendEntriesSendTime().elapsedTimeMs() < this.leaseTimeoutMs).map(FollowerInfo::getId).collect(Collectors.toList());
        if (!hasMajority.test(activePeers)) {
            return;
        }
        Timestamp newLease = Timestamp.earliest(this.getMaxTimestampWithMajorityAck(current), this.getMaxTimestampWithMajorityAck(old));
        this.lease.set(newLease);
    }

    private Timestamp getMaxTimestampWithMajorityAck(List<FollowerInfo> followers) {
        if (followers == null || followers.isEmpty()) {
            return Timestamp.currentTime();
        }
        long mid = followers.size() / 2;
        return (Timestamp)followers.stream().map(FollowerInfo::getLastRespondedAppendEntriesSendTime).sorted().limit(mid + 1L).skip(mid).iterator().next();
    }
}

