/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.membership.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.counter.CounterCommand;
import org.apache.ratis.examples.membership.server.CServer;
import org.apache.ratis.netty.NettyFactory;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.Preconditions;

public class RaftCluster {
    private Map<Integer, CServer> members = new HashMap<Integer, CServer>();

    public void init(Collection<Integer> initPorts) throws IOException {
        RaftGroup group = this.initGroup(initPorts);
        for (int port : initPorts) {
            CServer server = new CServer(group, RaftCluster.peerId(port), port);
            server.start();
            this.members.put(port, server);
        }
    }

    public void update(Collection<Integer> newPorts) throws IOException {
        Preconditions.assertTrue(this.members.size() > 0, "Cluster is empty.");
        Collection<CServer> oldPeers = this.members.values();
        ArrayList<CServer> newPeers = new ArrayList<CServer>();
        ArrayList<CServer> peerToStart = new ArrayList<CServer>();
        ArrayList<CServer> peerToStop = new ArrayList<CServer>();
        for (Integer n : newPorts) {
            CServer server = this.members.get(n);
            if (server == null) {
                RaftGroup group = RaftGroup.valueOf(CServer.GROUP_ID, new RaftPeer[0]);
                server = new CServer(group, RaftCluster.peerId(n), n);
                peerToStart.add(server);
            }
            newPeers.add(server);
        }
        for (CServer cServer : oldPeers) {
            if (newPeers.contains(cServer)) continue;
            peerToStop.add(cServer);
        }
        System.out.println("Update membership ...... Step 1: start new peers.");
        System.out.println(RaftCluster.peersInfo(peerToStart, "Peers_to_start"));
        for (CServer cServer : peerToStart) {
            cServer.start();
        }
        System.out.println("Update membership ...... Step 2: update membership from C_old to C_new.");
        System.out.println(RaftCluster.peersInfo(oldPeers, "C_old"));
        System.out.println(RaftCluster.peersInfo(newPeers, "C_new"));
        if (this.members.size() > 0) {
            Throwable throwable = null;
            try (RaftClient client = this.createClient();){
                RaftClientReply reply = client.admin().setConfiguration(newPeers.stream().map(CServer::getPeer).collect(Collectors.toList()));
                if (!reply.isSuccess()) {
                    throw reply.getException();
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        System.out.println("Update membership ...... Step 3: stop outdated peers.");
        System.out.println(RaftCluster.peersInfo(peerToStop, "Peers_to_stop"));
        for (CServer cServer : peerToStop) {
            cServer.close();
            this.members.remove(cServer.getPort());
        }
        for (CServer cServer : peerToStart) {
            this.members.put(cServer.getPort(), cServer);
        }
    }

    public void show() {
        Collection<CServer> peers = this.members.values();
        System.out.println(RaftCluster.peersInfo(peers, "Cluster members"));
    }

    public void counterIncrement() throws IOException {
        try (RaftClient client = this.createClient();){
            RaftClientReply reply = client.io().send(CounterCommand.INCREMENT.getMessage());
            if (!reply.isSuccess()) {
                throw reply.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryCounter() throws IOException {
        try (RaftClient client = this.createClient();){
            RaftClientReply reply = client.io().sendReadOnly(CounterCommand.GET.getMessage());
            String count = reply.getMessage().getContent().toStringUtf8();
            System.out.println("Current counter value: " + count);
        }
    }

    private RaftGroup initGroup(Collection<Integer> ports) {
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>();
        for (int port : ports) {
            peers.add(RaftPeer.newBuilder().setId(RaftCluster.peerId(port)).setAddress("0.0.0.0:" + port).build());
        }
        this.members.values().stream().map(CServer::getPeer).forEach(peers::add);
        return RaftGroup.valueOf(CServer.GROUP_ID, peers);
    }

    public Collection<Integer> ports() {
        return this.members.keySet();
    }

    public void close() throws IOException {
        for (CServer server : this.members.values()) {
            server.close();
        }
    }

    private RaftClient createClient() {
        RaftProperties properties = new RaftProperties();
        RaftClient.Builder builder = RaftClient.newBuilder().setProperties(properties);
        builder.setRaftGroup(RaftGroup.valueOf(CServer.GROUP_ID, this.members.values().stream().map(s2 -> s2.getPeer()).collect(Collectors.toList())));
        builder.setClientRpc(new NettyFactory(new Parameters()).newRaftClientRpc(ClientId.randomId(), properties));
        return builder.build();
    }

    private static RaftPeerId peerId(int port) {
        return RaftPeerId.valueOf("p" + port);
    }

    private static String peersInfo(Collection<CServer> peers, String prefix) {
        StringBuilder msgBuilder = new StringBuilder(prefix).append("={");
        if (peers.size() == 0) {
            msgBuilder.append("}");
        } else {
            peers.forEach(p -> msgBuilder.append("\n\t").append(p));
            msgBuilder.append("\n}");
        }
        return msgBuilder.toString();
    }
}

