/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore.cli;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.examples.common.SubCommandBase;
import org.apache.ratis.examples.filestore.FileStoreClient;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

public abstract class Client
extends SubCommandBase {
    @Parameter(names={"--size"}, description="Size of each file in bytes", required=true)
    private long fileSizeInBytes;
    @Parameter(names={"--bufferSize"}, description="Size of buffer in bytes, should less than 4MB, i.e BUFFER_BYTE_LIMIT_DEFAULT", required=false)
    private int bufferSizeInBytes = 1024;
    @Parameter(names={"--numFiles"}, description="Number of files to be written", required=true)
    private int numFiles;
    @Parameter(names={"--numClients"}, description="Number of clients to write", required=true)
    private int numClients;
    @Parameter(names={"--storage", "-s"}, description="Storage dir, eg. --storage dir1 --storage dir2", required=true)
    private List<File> storageDir = new ArrayList<File>();
    private static final int MAX_THREADS_NUM = 1000;

    public int getNumThread() {
        return this.numFiles < 1000 ? this.numFiles : 1000;
    }

    public long getFileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public int getBufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    @Override
    public void run() throws Exception {
        int raftSegmentPreallocatedSize = 0x40000000;
        RaftProperties raftProperties = new RaftProperties();
        RaftConfigKeys.Rpc.setType(raftProperties, SupportedRpcType.GRPC);
        GrpcConfigKeys.setMessageSizeMax(raftProperties, SizeInBytes.valueOf(raftSegmentPreallocatedSize));
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit(raftProperties, SizeInBytes.valueOf(raftSegmentPreallocatedSize));
        RaftServerConfigKeys.Log.setWriteBufferSize(raftProperties, SizeInBytes.valueOf(raftSegmentPreallocatedSize));
        RaftServerConfigKeys.Log.setPreallocatedSize(raftProperties, SizeInBytes.valueOf(raftSegmentPreallocatedSize));
        RaftServerConfigKeys.Log.setSegmentSizeMax(raftProperties, SizeInBytes.valueOf(0x40000000L));
        RaftConfigKeys.DataStream.setType(raftProperties, SupportedDataStreamType.NETTY);
        RaftServerConfigKeys.Log.setSegmentCacheNumMax(raftProperties, 2);
        RaftClientConfigKeys.Rpc.setRequestTimeout(raftProperties, TimeDuration.valueOf(50000L, TimeUnit.MILLISECONDS));
        RaftClientConfigKeys.Async.setOutstandingRequestsMax(raftProperties, 1000);
        for (File dir : this.storageDir) {
            FileUtils.createDirectories(dir);
        }
        this.operation(this.getClients(raftProperties));
    }

    public List<FileStoreClient> getClients(RaftProperties raftProperties) {
        ArrayList<FileStoreClient> fileStoreClients = new ArrayList<FileStoreClient>();
        for (int i = 0; i < this.numClients; ++i) {
            RaftGroup raftGroup = RaftGroup.valueOf(RaftGroupId.valueOf(ByteString.copyFromUtf8(this.getRaftGroupId())), this.getPeers());
            RaftClient.Builder builder = RaftClient.newBuilder().setProperties(raftProperties);
            builder.setRaftGroup(raftGroup);
            builder.setClientRpc(new GrpcFactory(new Parameters()).newRaftClientRpc(ClientId.randomId(), raftProperties));
            RaftPeer[] peers = this.getPeers();
            builder.setPrimaryDataStreamServer(peers[0]);
            RaftClient client = builder.build();
            fileStoreClients.add(new FileStoreClient(client));
        }
        return fileStoreClients;
    }

    protected void close(List<FileStoreClient> clients) throws IOException {
        for (FileStoreClient client : clients) {
            client.close();
        }
    }

    public String getPath(String fileName) {
        int hash = fileName.hashCode() % this.storageDir.size();
        return new File(this.storageDir.get(Math.abs(hash)), fileName).getAbsolutePath();
    }

    protected void dropCache() {
        Object[] cmds = new String[]{"/bin/sh", "-c", "echo 3 > /proc/sys/vm/drop_caches"};
        try {
            Process pro = Runtime.getRuntime().exec((String[])cmds);
            pro.waitFor();
        }
        catch (Throwable t2) {
            if (t2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            System.err.println("Failed to run command:" + Arrays.toString(cmds) + ":" + t2.getMessage());
        }
    }

    private CompletableFuture<Long> writeFileAsync(String path, ExecutorService executor) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        CompletableFuture.supplyAsync(() -> {
            try {
                future.complete(this.writeFile(path, this.fileSizeInBytes, this.bufferSizeInBytes));
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
            return future;
        }, executor);
        return future;
    }

    protected List<String> generateFiles(ExecutorService executor) {
        int i;
        UUID uuid = UUID.randomUUID();
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<CompletableFuture<Long>> futures = new ArrayList<CompletableFuture<Long>>();
        for (i = 0; i < this.numFiles; ++i) {
            String path = this.getPath("file-" + uuid + "-" + i);
            paths.add(path);
            futures.add(this.writeFileAsync(path, executor));
        }
        for (i = 0; i < futures.size(); ++i) {
            long size = (Long)((CompletableFuture)futures.get(i)).join();
            if (size == this.fileSizeInBytes) continue;
            System.err.println("Error: path:" + (String)paths.get(i) + " write:" + size + " mismatch expected size:" + this.fileSizeInBytes);
        }
        return paths;
    }

    protected long writeFile(String path, long fileSize, long bufferSize) throws IOException {
        long offset;
        byte[] buffer = new byte[Math.toIntExact(bufferSize)];
        try (RandomAccessFile raf = new RandomAccessFile(path, "rw");){
            long chunkSize;
            for (offset = 0L; offset < fileSize; offset += chunkSize) {
                long remaining = fileSize - offset;
                chunkSize = Math.min(remaining, bufferSize);
                ThreadLocalRandom.current().nextBytes(buffer);
                raf.write(buffer, 0, Math.toIntExact(chunkSize));
            }
        }
        return offset;
    }

    protected abstract void operation(List<FileStoreClient> var1) throws IOException, ExecutionException, InterruptedException;
}

