/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerInlinePolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String grantor;
    private Mode mode;
    private List<Grant> grants;
    private String createdBy;
    private long createTime;

    public RangerInlinePolicy() {
        this.mode = Mode.INLINE;
    }

    public RangerInlinePolicy(String grantor, Mode mode, List<Grant> grants, String createdBy) {
        this.grantor = grantor;
        this.mode = mode;
        this.grants = grants;
        this.createdBy = createdBy;
        this.createTime = System.currentTimeMillis();
    }

    public String getGrantor() {
        return this.grantor;
    }

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public List<Grant> getGrants() {
        return this.grants;
    }

    public void setGrants(List<Grant> grants) {
        this.grants = grants;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        return "RangerInlinePolicy{grantor=" + this.grantor + ",mode=" + (Object)((Object)this.mode) + ",grants=" + this.grants + ",createdBy=" + this.createdBy + ",createTime=" + this.createTime + "}";
    }

    public static class Grant {
        private Set<String> principals;
        private Set<String> resources;
        private Set<String> permissions;

        public Grant() {
        }

        public Grant(Set<String> principals, Set<String> resources, Set<String> permissions) {
            this.principals = principals;
            this.resources = resources;
            this.permissions = permissions;
        }

        public Set<String> getPrincipals() {
            return this.principals;
        }

        public void setPrincipals(Set<String> principals) {
            this.principals = principals;
        }

        public Set<String> getResources() {
            return this.resources;
        }

        public void setResources(Set<String> resources) {
            this.resources = resources;
        }

        public Set<String> getPermissions() {
            return this.permissions;
        }

        public void setPermissions(Set<String> permissions) {
            this.permissions = permissions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Grant that = (Grant)o;
            return Objects.equals(this.principals, that.principals) && Objects.equals(this.resources, that.resources) && Objects.equals(this.permissions, that.permissions);
        }

        public int hashCode() {
            return Objects.hash(this.principals, this.resources, this.permissions);
        }

        public String toString() {
            return "Grant{principals=" + this.principals + ", resources=" + this.resources + ", permissions=" + this.permissions + '}';
        }
    }

    public static enum Mode {
        INLINE,
        RANGER_AND_INLINE,
        RANGER_OR_INLINE;

    }
}

