/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import org.apache.ranger.ugsyncutil.transform.Mapper;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserGroupSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUserGroupSource.class);
    protected final UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    protected final Mapper userNameRegExInst;
    protected final Mapper groupNameRegExInst;

    public AbstractUserGroupSource() {
        Class<?> regExClass;
        String mappingUserNameHandler = this.config.getUserSyncMappingUserNameHandler();
        String mappingGroupNameHandler = this.config.getUserSyncMappingGroupNameHandler();
        Mapper userNameRegExInst = null;
        Mapper groupNameRegExInst = null;
        if (mappingUserNameHandler != null) {
            try {
                regExClass = Class.forName(mappingUserNameHandler);
                userNameRegExInst = (Mapper)regExClass.newInstance();
                userNameRegExInst.init("ranger.usersync.mapping.username.regex", this.config.getAllRegexPatterns("ranger.usersync.mapping.username.regex"), this.config.getRegexSeparator());
            }
            catch (ClassNotFoundException cne) {
                LOG.error("Failed to load {}: {}", (Object)mappingUserNameHandler, (Object)cne);
            }
            catch (Throwable te) {
                LOG.error("Failed to instantiate {}: {}", (Object)mappingUserNameHandler, (Object)te);
            }
        }
        if (mappingGroupNameHandler != null) {
            try {
                regExClass = Class.forName(mappingGroupNameHandler);
                groupNameRegExInst = (Mapper)regExClass.newInstance();
                groupNameRegExInst.init("ranger.usersync.mapping.groupname.regex", this.config.getAllRegexPatterns("ranger.usersync.mapping.groupname.regex"), this.config.getRegexSeparator());
            }
            catch (ClassNotFoundException cne) {
                LOG.error("Failed to load {}: {}", (Object)mappingGroupNameHandler, (Object)cne);
            }
            catch (Throwable te) {
                LOG.error("Failed to instantiate {}: {}", (Object)mappingGroupNameHandler, (Object)te);
            }
        }
        this.userNameRegExInst = userNameRegExInst;
        this.groupNameRegExInst = groupNameRegExInst;
    }
}

