/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.apache.ranger.authz.model.RangerAccessContext;
import org.apache.ranger.authz.model.RangerAccessInfo;
import org.apache.ranger.authz.model.RangerUserInfo;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerAuthzRequest {
    private String requestId;
    private RangerUserInfo user;
    private RangerAccessInfo access;
    private RangerAccessContext context;

    public RangerAuthzRequest() {
    }

    public RangerAuthzRequest(RangerUserInfo user, RangerAccessInfo access, RangerAccessContext context) {
        this(null, user, access, context);
    }

    public RangerAuthzRequest(String requestId, RangerUserInfo user, RangerAccessInfo access, RangerAccessContext context) {
        this.requestId = requestId;
        this.user = user;
        this.access = access;
        this.context = context;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public RangerUserInfo getUser() {
        return this.user;
    }

    public void setUser(RangerUserInfo user) {
        this.user = user;
    }

    public RangerAccessInfo getAccess() {
        return this.access;
    }

    public void setAccess(RangerAccessInfo access) {
        this.access = access;
    }

    public RangerAccessContext getContext() {
        return this.context;
    }

    public void setContext(RangerAccessContext context) {
        this.context = context;
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.user, this.access, this.context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangerAuthzRequest that = (RangerAuthzRequest)o;
        return Objects.equals(this.requestId, that.requestId) && Objects.equals(this.user, that.user) && Objects.equals(this.access, that.access) && Objects.equals(this.context, that.context);
    }

    public String toString() {
        return "RangerAuthzRequest{requestId='" + this.requestId + '\'' + ", user=" + this.user + ", access=" + this.access + ", context=" + this.context + '}';
    }
}

