/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HAConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HAConfiguration.class);
    public static final String RANGER_SERVICE_ACTIVE_SERVER_INFO = "/active_server_info";
    public static final String RANGER_SERVICE_NAME = "ranger.service.name";
    public static final String RANGER_SERVER_ZK_ROOT_DEFAULT = "/apacheranger.service.name_zkroot";
    private static final String RANGER_SERVER_HA_PREFIX = ".server.ha.";
    private static final String ZOOKEEPER_PREFIX = "zookeeper.";
    public static final String RANGER_SERVER_HA_ADDRESS_PREFIX = ".server.ha.address.";
    private static final String RANGER_SERVER_HA_ZK_ROOT_KEY = ".server.ha.zookeeper.zkroot";
    private static final String RANGER_SERVER_HA_ENABLED_KEY = ".server.ha.enabled";
    public static final String RANGER_SERVER_HA_IDS = ".server.ha.ids";
    private static final String HA_ZOOKEEPER_CONNECT = ".server.ha.zookeeper.connect";
    private static final int DEFAULT_ZOOKEEPER_CONNECT_SLEEPTIME_MILLIS = 1000;
    private static final String HA_ZOOKEEPER_RETRY_SLEEPTIME_MILLIS = ".server.ha.zookeeper.retry.sleeptime.ms";
    private static final String HA_ZOOKEEPER_NUM_RETRIES = ".server.ha.zookeeper.num.retries";
    private static final int DEFAULT_ZOOKEEPER_CONNECT_NUM_RETRIES = 3;
    private static final String HA_ZOOKEEPER_SESSION_TIMEOUT_MS = ".server.ha.zookeeper.session.timeout.ms";
    private static final int DEFAULT_ZOOKEEPER_SESSION_TIMEOUT_MILLIS = 20000;
    private static final String HA_ZOOKEEPER_ACL = ".server.ha.zookeeper.acl";
    private static final String HA_ZOOKEEPER_AUTH = ".server.ha.zookeeper.auth";
    public static final String RANGER_HA_SERVICE_HTTPS_PORT = ".service.https.port";
    public static final String RANGER_HA_SERVICE_HTTP_PORT = ".service.http.port";
    public static final String RANGER_SERVICE_SSL_ENABLED = ".server.ha.ssl.enabled";

    private HAConfiguration() {
    }

    public static boolean isHAEnabled(Configuration configuration) {
        String[] ids;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HAConfiguration.isHAEnabled() RANGER_SERVER_HA_ENABLED_KEY :  " + HAConfiguration.getStringConfig(configuration, RANGER_SERVER_HA_ENABLED_KEY, null));
        }
        boolean ret = HAConfiguration.getStringConfig(configuration, RANGER_SERVER_HA_ENABLED_KEY, null) != null ? HAConfiguration.getBooleanConfig(configuration, RANGER_SERVER_HA_ENABLED_KEY, false) : (ids = HAConfiguration.getStringsConfig(configuration, RANGER_SERVER_HA_IDS, null)) != null && ids.length > 1;
        LOG.info("<== HAConfiguration.isHAEnabled() ret :" + ret);
        return ret;
    }

    public static String getBoundAddressForId(Configuration configuration, String serverId) {
        String hostPort = HAConfiguration.getStringConfig(configuration, RANGER_SERVER_HA_ADDRESS_PREFIX + serverId, null);
        boolean isSecure = HAConfiguration.getBooleanConfig(configuration, RANGER_SERVICE_SSL_ENABLED, false);
        String protocol = isSecure ? "https://" : "http://";
        return protocol + hostPort;
    }

    public static List<String> getServerInstances(Configuration configuration) {
        String[] serverIds = HAConfiguration.getStringsConfig(configuration, RANGER_SERVER_HA_IDS, null);
        ArrayList<String> serverInstances = new ArrayList<String>(serverIds.length);
        for (String serverId : serverIds) {
            serverInstances.add(HAConfiguration.getBoundAddressForId(configuration, serverId));
        }
        return serverInstances;
    }

    public static ZookeeperProperties getZookeeperProperties(Configuration configuration) {
        Object[] zkServers = null;
        if (HAConfiguration.getStringConfig(configuration, HA_ZOOKEEPER_CONNECT, null) != null) {
            zkServers = HAConfiguration.getStringsConfig(configuration, HA_ZOOKEEPER_CONNECT, null);
        }
        String zkRoot = HAConfiguration.getStringConfig(configuration, RANGER_SERVER_HA_ZK_ROOT_KEY, RANGER_SERVER_ZK_ROOT_DEFAULT);
        int retriesSleepTimeMillis = HAConfiguration.getIntConfig(configuration, HA_ZOOKEEPER_RETRY_SLEEPTIME_MILLIS, 1000);
        int numRetries = HAConfiguration.getIntConfig(configuration, HA_ZOOKEEPER_NUM_RETRIES, 3);
        int sessionTimeout = HAConfiguration.getIntConfig(configuration, HA_ZOOKEEPER_SESSION_TIMEOUT_MS, 20000);
        String acl = HAConfiguration.getStringConfig(configuration, HA_ZOOKEEPER_ACL, null);
        String auth = HAConfiguration.getStringConfig(configuration, HA_ZOOKEEPER_AUTH, null);
        LOG.info(" ==> HAConfiguration.ZookeeperProperties zkServers: " + Arrays.toString(zkServers) + " zkRoot:{" + zkRoot + "} retriesSleepTimeMillis:{" + retriesSleepTimeMillis + "} numRetries:{" + numRetries + "} sessionTimeout:{" + sessionTimeout + "} acl:{" + acl + "} auth:{" + auth + "}");
        return new ZookeeperProperties(StringUtils.join((Object[])zkServers, (char)','), zkRoot, retriesSleepTimeMillis, numRetries, sessionTimeout, acl, auth);
    }

    public static String getPrefix(Configuration configuration) {
        String serverPrefix = null;
        serverPrefix = configuration.get(RANGER_SERVICE_NAME, RANGER_SERVICE_NAME);
        return serverPrefix;
    }

    public static String getStringConfig(Configuration configuration, String confStr, String confDefaultValue) {
        String value = null;
        String key = HAConfiguration.getPrefix(configuration) + confStr;
        value = configuration.get(key, confDefaultValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HAConfiguration.getConfigString() key :{" + key + "} value :{" + value + "} confDefaultValue :{" + confDefaultValue + "}");
        }
        return value;
    }

    public static int getIntConfig(Configuration configuration, String confStr, int confDefaultValue) {
        String key = HAConfiguration.getPrefix(configuration) + confStr;
        int value = configuration.getInt(key, confDefaultValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HAConfiguration.getConfigString() key :{" + key + "} value :{" + value + "} confDefaultValue :{" + confDefaultValue + "}");
        }
        return value;
    }

    public static String[] getStringsConfig(Configuration configuration, String confStr, String confDefaultValue) {
        String[] value = null;
        String key = HAConfiguration.getPrefix(configuration) + confStr;
        value = configuration.getStrings(key, new String[]{confDefaultValue});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HAConfiguration getConfigString() key :{" + key + "} value :{" + value + "} confDefaultValue :{" + confDefaultValue + "}");
        }
        return value;
    }

    public static boolean getBooleanConfig(Configuration configuration, String confStr, boolean confDefaultValue) {
        String key = HAConfiguration.getPrefix(configuration) + confStr;
        boolean value = configuration.getBoolean(key, confDefaultValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HAConfiguration getConfigString() key :{" + key + "} value :{" + value + "} confDefaultValue :{" + confDefaultValue + "}");
        }
        return value;
    }

    public static class ZookeeperProperties {
        private String connectString;
        private String zkRoot;
        private int retriesSleepTimeMillis;
        private int numRetries;
        private int sessionTimeout;
        private String acl;
        private String auth;

        public ZookeeperProperties(String connectString, String zkRoot, int retriesSleepTimeMillis, int numRetries, int sessionTimeout, String acl, String auth) {
            this.connectString = connectString;
            this.zkRoot = zkRoot;
            this.retriesSleepTimeMillis = retriesSleepTimeMillis;
            this.numRetries = numRetries;
            this.sessionTimeout = sessionTimeout;
            this.acl = acl;
            this.auth = auth;
        }

        public String getConnectString() {
            return this.connectString;
        }

        public int getRetriesSleepTimeMillis() {
            return this.retriesSleepTimeMillis;
        }

        public int getNumRetries() {
            return this.numRetries;
        }

        public int getSessionTimeout() {
            return this.sessionTimeout;
        }

        public String getAcl() {
            return this.acl;
        }

        public String getAuth() {
            return this.auth;
        }

        public String getZkRoot() {
            return this.zkRoot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZookeeperProperties that = (ZookeeperProperties)o;
            return this.retriesSleepTimeMillis == that.retriesSleepTimeMillis && this.numRetries == that.numRetries && this.sessionTimeout == that.sessionTimeout && Objects.equals(this.connectString, that.connectString) && Objects.equals(this.zkRoot, that.zkRoot) && Objects.equals(this.acl, that.acl) && Objects.equals(this.auth, that.auth);
        }

        public int hashCode() {
            return Objects.hash(this.connectString, this.zkRoot, this.retriesSleepTimeMillis, this.numRetries, this.sessionTimeout, this.acl, this.auth);
        }

        public boolean hasAcl() {
            return StringUtils.isNotBlank((CharSequence)this.getAcl());
        }

        public boolean hasAuth() {
            return StringUtils.isNotBlank((CharSequence)this.getAuth());
        }
    }
}

