/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.geo;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeolocationMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(GeolocationMetadata.class);
    private String[] locationDataItemNames = new String[0];

    public static GeolocationMetadata create(String[] fields, int index) {
        GeolocationMetadata ret = null;
        if (fields.length > 2) {
            String[] metadataNames = new String[fields.length - 2];
            for (int i = 2; i < fields.length; ++i) {
                metadataNames[i - 2] = fields[i];
            }
            ret = new GeolocationMetadata(metadataNames);
        } else {
            LOG.error("GeolocationMetadata.createMetadata() - Not enough fields specified, need {start, end, location} at " + index);
        }
        return ret;
    }

    GeolocationMetadata() {
    }

    GeolocationMetadata(String[] locationDataItemNames) {
        this.locationDataItemNames = locationDataItemNames;
    }

    public int getDataItemNameIndex(String dataItemName) {
        int ret = -1;
        if (!StringUtils.isBlank((CharSequence)dataItemName)) {
            for (int i = 0; i < this.locationDataItemNames.length; ++i) {
                if (!this.locationDataItemNames[i].equals(dataItemName)) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    public String[] getLocationDataItemNames() {
        return this.locationDataItemNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringDump(sb);
        return sb.toString();
    }

    private StringBuilder toStringDump(StringBuilder sb) {
        sb.append("FROM_IP,TO_IP,");
        for (String locationDataItemName : this.locationDataItemNames) {
            sb.append(locationDataItemName).append(", ");
        }
        return sb;
    }
}

