/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.RangerRoles;

public class RangerRolesUtil {
    private final long roleVersion;
    private final Map<String, Set<String>> userRoleMapping = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> groupRoleMapping = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> roleRoleMapping = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> roleToUserMapping = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> roleToGroupMapping = new HashMap<String, Set<String>>();
    private RangerRoles roles = null;

    public RangerRolesUtil(RangerRoles roles) {
        if (roles != null) {
            this.roles = roles;
            long l = this.roleVersion = roles.getRoleVersion() != null ? roles.getRoleVersion() : -1L;
            if (CollectionUtils.isNotEmpty(roles.getRangerRoles())) {
                for (RangerRole role : roles.getRangerRoles()) {
                    Set<RangerRole> containedRoles = this.getAllContainedRoles(roles.getRangerRoles(), role);
                    this.buildMap(this.userRoleMapping, role, containedRoles, ROLES_FOR.USER);
                    this.buildMap(this.groupRoleMapping, role, containedRoles, ROLES_FOR.GROUP);
                    this.buildMap(this.roleRoleMapping, role, containedRoles, ROLES_FOR.ROLE);
                    HashSet<String> roleUsers = new HashSet<String>();
                    HashSet<String> roleGroups = new HashSet<String>();
                    this.addMemberNames(role.getUsers(), roleUsers);
                    this.addMemberNames(role.getGroups(), roleGroups);
                    for (RangerRole containedRole : containedRoles) {
                        this.addMemberNames(containedRole.getUsers(), roleUsers);
                        this.addMemberNames(containedRole.getGroups(), roleGroups);
                    }
                    this.roleToUserMapping.put(role.getName(), roleUsers);
                    this.roleToGroupMapping.put(role.getName(), roleGroups);
                }
            }
        } else {
            this.roleVersion = -1L;
        }
    }

    public long getRoleVersion() {
        return this.roleVersion;
    }

    public RangerRoles getRoles() {
        return this.roles;
    }

    public Map<String, Set<String>> getUserRoleMapping() {
        return this.userRoleMapping;
    }

    public Map<String, Set<String>> getGroupRoleMapping() {
        return this.groupRoleMapping;
    }

    public Map<String, Set<String>> getRoleRoleMapping() {
        return this.roleRoleMapping;
    }

    public Map<String, Set<String>> getRoleToUserMapping() {
        return this.roleToUserMapping;
    }

    public Map<String, Set<String>> getRoleToGroupMapping() {
        return this.roleToGroupMapping;
    }

    private Set<RangerRole> getAllContainedRoles(Set<RangerRole> roles, RangerRole role) {
        HashSet<RangerRole> allRoles = new HashSet<RangerRole>();
        allRoles.add(role);
        this.addContainedRoles(allRoles, roles, role);
        return allRoles;
    }

    private void addContainedRoles(Set<RangerRole> allRoles, Set<RangerRole> roles, RangerRole role) {
        List<RangerRole.RoleMember> roleMembers = role.getRoles();
        for (RangerRole.RoleMember roleMember : roleMembers) {
            RangerRole containedRole = this.getContainedRole(roles, roleMember.getName());
            if (containedRole == null || allRoles.contains(containedRole)) continue;
            allRoles.add(containedRole);
            this.addContainedRoles(allRoles, roles, containedRole);
        }
    }

    private void buildMap(Map<String, Set<String>> map, RangerRole role, Set<RangerRole> containedRoles, ROLES_FOR roleFor) {
        this.buildMap(map, role, role.getName(), roleFor);
        for (RangerRole containedRole : containedRoles) {
            this.buildMap(map, containedRole, role.getName(), roleFor);
        }
    }

    private void buildMap(Map<String, Set<String>> map, RangerRole role, String roleName, ROLES_FOR roles_for) {
        List<RangerRole.RoleMember> userOrGroupOrRole = null;
        switch (roles_for) {
            case USER: {
                userOrGroupOrRole = role.getUsers();
                break;
            }
            case GROUP: {
                userOrGroupOrRole = role.getGroups();
                break;
            }
            case ROLE: {
                userOrGroupOrRole = role.getRoles();
            }
        }
        if (CollectionUtils.isNotEmpty(userOrGroupOrRole)) {
            this.getRoleMap(map, roleName, userOrGroupOrRole);
        }
    }

    private void getRoleMap(Map<String, Set<String>> map, String roleName, List<RangerRole.RoleMember> userOrGroupOrRole) {
        for (RangerRole.RoleMember roleMember : userOrGroupOrRole) {
            if (!StringUtils.isNotEmpty((CharSequence)roleMember.getName())) continue;
            Set roleNames = map.computeIfAbsent(roleMember.getName(), k -> new HashSet());
            roleNames.add(roleName);
        }
    }

    private RangerRole getContainedRole(Set<RangerRole> roles, String role) {
        return roles.stream().filter(containedRole -> role.equals(containedRole.getName())).findAny().orElse(null);
    }

    private void addMemberNames(List<RangerRole.RoleMember> members, Set<String> names) {
        for (RangerRole.RoleMember member : members) {
            names.add(member.getName());
        }
    }

    public static enum ROLES_FOR {
        USER,
        GROUP,
        ROLE;

    }
}

