/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.types.transport.Attach;
import org.apache.qpid.protonj2.types.transport.Begin;
import org.apache.qpid.protonj2.types.transport.Close;
import org.apache.qpid.protonj2.types.transport.Detach;
import org.apache.qpid.protonj2.types.transport.Disposition;
import org.apache.qpid.protonj2.types.transport.End;
import org.apache.qpid.protonj2.types.transport.Flow;
import org.apache.qpid.protonj2.types.transport.Open;
import org.apache.qpid.protonj2.types.transport.Transfer;

public interface Performative {
    public PerformativeType getPerformativeType();

    public Performative copy();

    public <E> void invoke(PerformativeHandler<E> var1, ProtonBuffer var2, int var3, E var4);

    public static interface PerformativeHandler<E> {
        default public void handleOpen(Open open, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleBegin(Begin begin, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleAttach(Attach attach, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleFlow(Flow flow, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleTransfer(Transfer transfer, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleDisposition(Disposition disposition, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleDetach(Detach detach, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleEnd(End end, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleClose(Close close, ProtonBuffer payload, int channel, E context) {
        }
    }

    public static enum PerformativeType {
        ATTACH,
        BEGIN,
        CLOSE,
        DETACH,
        DISPOSITION,
        END,
        FLOW,
        OPEN,
        TRANSFER;

    }
}

