/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.ProtonEncoder;
import org.apache.qpid.protonj2.codec.encoders.UTF8Encoder;

public final class ProtonEncoderState
implements EncoderState {
    private final ProtonEncoder encoder;
    private UTF8Encoder utf8Encoder;

    public ProtonEncoderState(ProtonEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public ProtonEncoder getEncoder() {
        return this.encoder;
    }

    public UTF8Encoder getUTF8Encoder() {
        return this.utf8Encoder;
    }

    public ProtonEncoderState setUTF8Encoder(UTF8Encoder utf8Encoder) {
        this.utf8Encoder = utf8Encoder;
        return this;
    }

    @Override
    public ProtonEncoderState reset() {
        return this;
    }

    @Override
    public ProtonBuffer encodeUTF8(ProtonBuffer buffer, CharSequence sequence) {
        if (this.utf8Encoder == null) {
            ProtonEncoderState.encodeUTF8Sequence(buffer, sequence);
        } else {
            this.utf8Encoder.encodeUTF8(buffer, sequence);
        }
        return buffer;
    }

    private static void encodeUTF8Sequence(ProtonBuffer buffer, CharSequence sequence) {
        int index;
        int length = sequence.length();
        int position = buffer.getWriteOffset();
        char ch = '\u0000';
        buffer.ensureWritable(length);
        for (index = 0; index < length && (ch = sequence.charAt(index)) < '\u0080'; ++index) {
            buffer.setByte(position++, (byte)ch);
        }
        if (index < length) {
            position = ProtonEncoderState.extendedEncodeUTF8Sequence(buffer, sequence, index, position);
        }
        buffer.setWriteOffset(position);
    }

    private static int extendedEncodeUTF8Sequence(ProtonBuffer buffer, CharSequence value, int index, int position) {
        buffer.ensureWritable(ProtonEncoderState.calculateUTF8Length(index, value));
        int remaining = value.length();
        for (int i = index; i < remaining; ++i) {
            char low;
            int c = value.charAt(i);
            if ((c & 0xFF80) == 0) {
                buffer.setByte(position++, (byte)c);
                continue;
            }
            if ((c & 0xF800) == 0) {
                buffer.setByte(position++, (byte)(0xC0 | c >> 6 & 0x1F));
                buffer.setByte(position++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if ((c & 0xD800) != 55296 || c > 56319) {
                buffer.setByte(position++, (byte)(0xE0 | c >> 12 & 0xF));
                buffer.setByte(position++, (byte)(0x80 | c >> 6 & 0x3F));
                buffer.setByte(position++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (++i == remaining || ((low = value.charAt(i)) & 0xDC00) != 56320) {
                throw new IllegalArgumentException("String contains invalid Unicode code points");
            }
            c = 65536 + ((c & 0x3FF) << 10) + (low & 0x3FF);
            buffer.setByte(position++, (byte)(0xF0 | c >> 18 & 7));
            buffer.setByte(position++, (byte)(0x80 | c >> 12 & 0x3F));
            buffer.setByte(position++, (byte)(0x80 | c >> 6 & 0x3F));
            buffer.setByte(position++, (byte)(0x80 | c & 0x3F));
        }
        return position;
    }

    private static int calculateUTF8Length(int startPos, CharSequence sequence) {
        int encodedSize;
        int length = encodedSize = sequence.length();
        for (int i = 0; i < length; ++i) {
            char c = sequence.charAt(i);
            if ((c & 0xFF80) == 0) continue;
            ++encodedSize;
            if ((c & 0xF800) == 0) continue;
            ++encodedSize;
            if ((c & 0xD800) != 55296 || c >= '\udc00') continue;
            ++i;
        }
        return encodedSize;
    }
}

