/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.deser.std.StdConvertingDeserializer;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.type.ArrayType;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.databind.type.MapLikeType;
import tools.jackson.databind.type.MapType;
import tools.jackson.databind.type.ReferenceType;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;
import tools.jackson.databind.util.LookupCache;
import tools.jackson.databind.util.SimpleLookupCache;

public final class DeserializerCache
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    private final LookupCache<JavaType, ValueDeserializer<Object>> _cachedDeserializers;
    private final transient HashMap<JavaType, ValueDeserializer<Object>> _incompleteDeserializers = new HashMap(8);
    private final ReentrantLock _incompleteDeserializersLock = new ReentrantLock();

    public DeserializerCache() {
        this(new SimpleLookupCache<JavaType, ValueDeserializer<Object>>(64, 1000));
    }

    public DeserializerCache(LookupCache<JavaType, ValueDeserializer<Object>> cache) {
        this._cachedDeserializers = cache;
    }

    public DeserializerCache emptyCopy() {
        return new DeserializerCache(this._cachedDeserializers.emptyCopy());
    }

    protected Object readResolve() {
        return new DeserializerCache(this._cachedDeserializers);
    }

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public ValueDeserializer<Object> findValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType propertyType) {
        Objects.requireNonNull(propertyType, "Null 'propertyType' passed");
        ValueDeserializer<Object> deser = this._findCachedDeserializer(propertyType);
        if (deser == null && (deser = this._createAndCacheValueDeserializer(ctxt, factory, propertyType)) == null) {
            deser = this._handleUnknownValueDeserializer(ctxt, propertyType);
        }
        return deser;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) {
        Objects.requireNonNull(type, "Null 'type' passed");
        KeyDeserializer kd = factory.createKeyDeserializer(ctxt, type);
        if (kd == null) {
            return this._handleUnknownKeyDeserializer(ctxt, type);
        }
        kd.resolve(ctxt);
        return kd;
    }

    protected ValueDeserializer<Object> _findCachedDeserializer(JavaType type) {
        if (this._hasCustomHandlers(type)) {
            return null;
        }
        return this._cachedDeserializers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) {
        ValueDeserializer<Object> deser;
        boolean isCustom = this._hasCustomHandlers(type);
        if (!isCustom && (deser = this._cachedDeserializers.get(type)) != null) {
            return deser;
        }
        this._incompleteDeserializersLock.lock();
        try {
            ValueDeserializer<Object> deser2;
            if (!isCustom && (deser = this._cachedDeserializers.get(type)) != null) {
                ValueDeserializer<Object> valueDeserializer = deser;
                return valueDeserializer;
            }
            int count = this._incompleteDeserializers.size();
            if (count > 0 && (deser2 = this._incompleteDeserializers.get(type)) != null) {
                ValueDeserializer<Object> valueDeserializer = deser2;
                return valueDeserializer;
            }
            try {
                ValueDeserializer<Object> valueDeserializer = this._createAndCache2(ctxt, factory, type, isCustom);
                if (count == 0 && this._incompleteDeserializers.size() > 0) {
                    this._incompleteDeserializers.clear();
                }
                return valueDeserializer;
            }
            catch (Throwable throwable) {
                if (count == 0 && this._incompleteDeserializers.size() > 0) {
                    this._incompleteDeserializers.clear();
                }
                throw throwable;
            }
        }
        finally {
            this._incompleteDeserializersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueDeserializer<Object> _createAndCache2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type, boolean isCustom) {
        ValueDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(ctxt, factory, type);
        }
        catch (IllegalArgumentException iae) {
            ctxt.reportBadDefinition(type, ClassUtil.exceptionMessage(iae));
            deser = null;
        }
        if (deser == null) {
            return null;
        }
        boolean addToCache = !isCustom && deser.isCachable();
        this._incompleteDeserializers.put(type, deser);
        try {
            deser.resolve(ctxt);
        }
        finally {
            this._incompleteDeserializers.remove(type);
        }
        if (addToCache) {
            this._cachedDeserializers.put(type, deser);
        }
        return deser;
    }

    protected ValueDeserializer<Object> _createDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) {
        Class<?> builder;
        BeanDescription.Supplier beanDescRef;
        ValueDeserializer<Object> deser;
        DeserializationConfig config = ctxt.getConfig();
        if (type.isAbstract() || type.isMapLikeType() || type.isCollectionLikeType()) {
            type = config.mapAbstractType(type);
        }
        if ((deser = this.findDeserializerFromAnnotation(ctxt, (beanDescRef = ctxt.lazyIntrospectBeanDescription(type)).getClassInfo())) != null) {
            return deser;
        }
        JavaType newType = this.modifyTypeByAnnotation(ctxt, beanDescRef.getClassInfo(), type);
        if (newType != type) {
            type = newType;
            beanDescRef = ctxt.lazyIntrospectBeanDescription(newType);
        }
        if ((builder = ctxt.getAnnotationIntrospector().findPOJOBuilder(config, beanDescRef.getClassInfo())) != null) {
            return factory.createBuilderBasedDeserializer(ctxt, type, beanDescRef, builder);
        }
        Converter<Object, Object> conv = config.findDeserializationConverter(beanDescRef.getClassInfo());
        if (conv != null) {
            JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
            if (!delegateType.hasRawClass(type.getRawClass())) {
                beanDescRef = ctxt.lazyIntrospectBeanDescription(delegateType);
            }
            return new StdConvertingDeserializer<Object>(conv, delegateType, this._createDeserializer2(ctxt, factory, delegateType, beanDescRef));
        }
        return this._createDeserializer2(ctxt, factory, type, beanDescRef);
    }

    protected ValueDeserializer<?> _createDeserializer2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type, BeanDescription.Supplier beanDescRef) {
        DeserializationConfig config = ctxt.getConfig();
        if (type.isEnumType()) {
            return factory.createEnumDeserializer(ctxt, type, beanDescRef);
        }
        if (type.isContainerType()) {
            JsonFormat.Value format;
            if (type.isArrayType()) {
                return factory.createArrayDeserializer(ctxt, (ArrayType)type, beanDescRef);
            }
            if (type.isMapLikeType() && (format = beanDescRef.findExpectedFormat(type.getRawClass())).getShape() != JsonFormat.Shape.POJO) {
                MapLikeType mlt = (MapLikeType)type;
                if (mlt instanceof MapType) {
                    return factory.createMapDeserializer(ctxt, (MapType)mlt, beanDescRef);
                }
                return factory.createMapLikeDeserializer(ctxt, mlt, beanDescRef);
            }
            if (type.isCollectionLikeType() && (format = beanDescRef.findExpectedFormat(type.getRawClass())).getShape() != JsonFormat.Shape.POJO) {
                CollectionLikeType clt = (CollectionLikeType)type;
                if (clt instanceof CollectionType) {
                    return factory.createCollectionDeserializer(ctxt, (CollectionType)clt, beanDescRef);
                }
                return factory.createCollectionLikeDeserializer(ctxt, clt, beanDescRef);
            }
        }
        if (type.isReferenceType()) {
            return factory.createReferenceDeserializer(ctxt, (ReferenceType)type, beanDescRef);
        }
        if (JsonNode.class.isAssignableFrom(type.getRawClass())) {
            return factory.createTreeDeserializer(config, type, beanDescRef);
        }
        return factory.createBeanDeserializer(ctxt, type, beanDescRef);
    }

    protected ValueDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) {
        Object deserDef = ctxt.getAnnotationIntrospector().findDeserializer(ctxt.getConfig(), ann);
        if (deserDef == null) {
            return null;
        }
        ValueDeserializer<Object> deser = ctxt.deserializerInstance(ann, deserDef);
        return this.findConvertingDeserializer(ctxt, ann, deser);
    }

    protected ValueDeserializer<Object> findConvertingDeserializer(DeserializationContext ctxt, Annotated a, ValueDeserializer<Object> deser) {
        Converter<Object, Object> conv = this.findConverter(ctxt, a);
        if (conv == null) {
            return deser;
        }
        JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
        return new StdConvertingDeserializer<Object>(conv, delegateType, deser);
    }

    protected Converter<Object, Object> findConverter(DeserializationContext ctxt, Annotated a) {
        Object convDef = ctxt.getAnnotationIntrospector().findDeserializationConverter(ctxt.getConfig(), a);
        if (convDef == null) {
            return null;
        }
        return ctxt.converterInstance(a, convDef);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext ctxt, Annotated a, JavaType type) {
        Object cdDef;
        JavaType contentType;
        KeyDeserializer kd;
        Object kdDef;
        JavaType keyType;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr == null) {
            return type;
        }
        DeserializationConfig config = ctxt.getConfig();
        if (type.isMapLikeType() && (keyType = type.getKeyType()) != null && keyType.getValueHandler() == null && (kdDef = intr.findKeyDeserializer(config, a)) != null && (kd = ctxt.keyDeserializerInstance(a, kdDef)) != null) {
            type = ((MapLikeType)type).withKeyValueHandler(kd);
        }
        if ((contentType = type.getContentType()) != null && contentType.getValueHandler() == null && (cdDef = intr.findContentDeserializer(config, a)) != null) {
            ValueDeserializer<Object> cd = null;
            if (cdDef instanceof ValueDeserializer) {
                cd = (ValueDeserializer<Object>)cdDef;
            } else {
                Class<?> cdClass = this._verifyAsClass(cdDef, "findContentDeserializer", ValueDeserializer.None.class);
                if (cdClass != null) {
                    cd = ctxt.deserializerInstance(a, cdClass);
                }
            }
            if (cd != null) {
                type = type.withContentValueHandler(cd);
            }
        }
        type = intr.refineDeserializationType(config, a, type);
        return type;
    }

    private boolean _hasCustomHandlers(JavaType t) {
        if (t.isContainerType()) {
            JavaType kt;
            JavaType ct = t.getContentType();
            if (ct != null && (ct.getValueHandler() != null || ct.getTypeHandler() != null)) {
                return true;
            }
            if (t.isMapLikeType() && (kt = t.getKeyType()).getValueHandler() != null) {
                return true;
            }
        }
        return false;
    }

    private Class<?> _verifyAsClass(Object src, String methodName, Class<?> noneClass) {
        if (src == null) {
            return null;
        }
        if (!(src instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + methodName + "() returned value of type " + src.getClass().getName() + ": expected type `ValueSerializer` or `Class<ValueSerializer>` instead");
        }
        Class cls = (Class)src;
        if (cls == noneClass || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    protected ValueDeserializer<Object> _handleUnknownValueDeserializer(DeserializationContext ctxt, JavaType type) {
        Class<?> rawClass = type.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            return (ValueDeserializer)ctxt.reportBadDefinition(type, "Cannot find a Value deserializer for abstract type " + String.valueOf(type));
        }
        return (ValueDeserializer)ctxt.reportBadDefinition(type, "Cannot find a Value deserializer for type " + String.valueOf(type));
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(DeserializationContext ctxt, JavaType type) {
        return (KeyDeserializer)ctxt.reportBadDefinition(type, "Cannot find a (Map) Key deserializer for type " + String.valueOf(type));
    }
}

