/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Collection;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;

public class OpenTelemetryConsumerStats
implements AutoCloseable {
    public static final String MESSAGE_OUT_COUNTER = "pulsar.broker.consumer.message.outgoing.count";
    private final ObservableLongMeasurement messageOutCounter;
    public static final String BYTES_OUT_COUNTER = "pulsar.broker.consumer.message.outgoing.size";
    private final ObservableLongMeasurement bytesOutCounter;
    public static final String MESSAGE_ACK_COUNTER = "pulsar.broker.consumer.message.ack.count";
    private final ObservableLongMeasurement messageAckCounter;
    public static final String MESSAGE_REDELIVER_COUNTER = "pulsar.broker.consumer.message.redeliver.count";
    private final ObservableLongMeasurement messageRedeliverCounter;
    public static final String MESSAGE_UNACKNOWLEDGED_COUNTER = "pulsar.broker.consumer.message.unack.count";
    private final ObservableLongMeasurement messageUnacknowledgedCounter;
    public static final String CONSUMER_BLOCKED_COUNTER = "pulsar.broker.consumer.blocked";
    private final ObservableLongMeasurement consumerBlockedCounter;
    public static final String MESSAGE_PERMITS_COUNTER = "pulsar.broker.consumer.permit.count";
    private final ObservableLongMeasurement messagePermitsCounter;
    private final BatchCallback batchCallback;

    public OpenTelemetryConsumerStats(PulsarService pulsar) {
        Meter meter = pulsar.getOpenTelemetry().getMeter();
        this.messageOutCounter = meter.counterBuilder(MESSAGE_OUT_COUNTER).setUnit("{message}").setDescription("The total number of messages dispatched to this consumer.").buildObserver();
        this.bytesOutCounter = meter.counterBuilder(BYTES_OUT_COUNTER).setUnit("By").setDescription("The total number of messages bytes dispatched to this consumer.").buildObserver();
        this.messageAckCounter = meter.counterBuilder(MESSAGE_ACK_COUNTER).setUnit("{ack}").setDescription("The total number of message acknowledgments received from this consumer.").buildObserver();
        this.messageRedeliverCounter = meter.counterBuilder(MESSAGE_REDELIVER_COUNTER).setUnit("{message}").setDescription("The total number of messages that have been redelivered to this consumer.").buildObserver();
        this.messageUnacknowledgedCounter = meter.upDownCounterBuilder(MESSAGE_UNACKNOWLEDGED_COUNTER).setUnit("{message}").setDescription("The total number of messages unacknowledged by this consumer.").buildObserver();
        this.consumerBlockedCounter = meter.upDownCounterBuilder(CONSUMER_BLOCKED_COUNTER).setUnit("1").setDescription("Indicates whether the consumer is currently blocked due to unacknowledged messages.").buildObserver();
        this.messagePermitsCounter = meter.upDownCounterBuilder(MESSAGE_PERMITS_COUNTER).setUnit("{permit}").setDescription("The number of permits currently available for this consumer.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> pulsar.getBrokerService().getTopics().values().stream().map(topicFuture -> topicFuture.getNow(Optional.empty())).filter(Optional::isPresent).map(Optional::get).map(Topic::getSubscriptions).flatMap(s -> s.values().stream()).map(Subscription::getConsumers).flatMap(Collection::stream).forEach(this::recordMetricsForConsumer), (ObservableMeasurement)this.messageOutCounter, new ObservableMeasurement[]{this.bytesOutCounter, this.messageAckCounter, this.messageRedeliverCounter, this.messageUnacknowledgedCounter, this.consumerBlockedCounter, this.messagePermitsCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetricsForConsumer(Consumer consumer) {
        Attributes attributes = consumer.getOpenTelemetryAttributes();
        this.messageOutCounter.record(consumer.getMsgOutCounter(), attributes);
        this.bytesOutCounter.record(consumer.getBytesOutCounter(), attributes);
        this.messageAckCounter.record(consumer.getMessageAckCounter(), attributes);
        this.messageRedeliverCounter.record(consumer.getMessageRedeliverCounter(), attributes);
        this.messageUnacknowledgedCounter.record((long)consumer.getUnackedMessages(), attributes);
        this.consumerBlockedCounter.record(consumer.isBlocked() ? 1L : 0L, attributes);
        this.messagePermitsCounter.record((long)consumer.getAvailablePermits(), attributes);
    }
}

