/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.InMemoryDelayedDeliveryTracker;
import org.apache.pulsar.broker.service.persistent.AbstractPersistentDispatcherMultipleConsumers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDelayedDeliveryTrackerFactory
implements DelayedDeliveryTrackerFactory {
    private static final Logger log = LoggerFactory.getLogger(InMemoryDelayedDeliveryTrackerFactory.class);
    private Timer timer;
    private long tickTimeMillis;
    private boolean isDelayedDeliveryDeliverAtTimeStrict;
    private long fixedDelayDetectionLookahead;

    @Override
    public void initialize(PulsarService pulsarService) {
        ServiceConfiguration config = pulsarService.getConfig();
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("pulsar-delayed-delivery"), config.getDelayedDeliveryTickTimeMillis(), TimeUnit.MILLISECONDS);
        this.tickTimeMillis = config.getDelayedDeliveryTickTimeMillis();
        this.isDelayedDeliveryDeliverAtTimeStrict = config.isDelayedDeliveryDeliverAtTimeStrict();
        this.fixedDelayDetectionLookahead = config.getDelayedDeliveryFixedDelayDetectionLookahead();
    }

    @Override
    public DelayedDeliveryTracker newTracker(AbstractPersistentDispatcherMultipleConsumers dispatcher) {
        String topicName = dispatcher.getTopic().getName();
        String subscriptionName = dispatcher.getSubscription().getName();
        DelayedDeliveryTracker tracker = DelayedDeliveryTracker.DISABLE;
        try {
            tracker = this.newTracker0(dispatcher);
        }
        catch (Exception e) {
            log.warn("Failed to create InMemoryDelayedDeliveryTracker, topic {}, subscription {}", new Object[]{topicName, subscriptionName, e});
        }
        return tracker;
    }

    @VisibleForTesting
    InMemoryDelayedDeliveryTracker newTracker0(AbstractPersistentDispatcherMultipleConsumers dispatcher) {
        return new InMemoryDelayedDeliveryTracker(dispatcher, this.timer, this.tickTimeMillis, this.isDelayedDeliveryDeliverAtTimeStrict, this.fixedDelayDetectionLookahead);
    }

    @Override
    public void close() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }
}

