/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import io.trino.Session;
import io.trino.metadata.TableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.NodeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.NodeAndMappings;
import io.trino.sql.planner.PlanBuilder;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.RelationPlan;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.SubqueryPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.planner.rowpattern.RowPatternToIrRewriter;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinCriteria;
import io.trino.sql.tree.JoinUsing;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.SetOperation;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDefinition;
import io.trino.type.TypeCoercion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

class RelationPlanner
extends AstVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final PlannerContext plannerContext;
    private final TypeCoercion typeCoercion;
    private final Optional<TranslationMap> outerContext;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, PlannerContext plannerContext, Optional<TranslationMap> outerContext, Session session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.plannerContext = plannerContext;
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        this.outerContext = outerContext;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, lambdaDeclarationToSymbolMap, plannerContext, this.typeCoercion, outerContext, session, recursiveSubqueries);
        this.recursiveSubqueries = recursiveSubqueries;
    }

    protected RelationPlan visitNode(Node node, Void context) {
        throw new IllegalStateException("Unsupported node type: " + node.getClass().getName());
    }

    protected RelationPlan visitTable(Table node, Void context) {
        RelationPlan plan;
        RelationPlan expansion = this.recursiveSubqueries.get(NodeRef.of((Node)node));
        if (expansion != null) {
            return new RelationPlan(expansion.getRoot(), expansion.getScope(), expansion.getFieldMappings(), this.outerContext);
        }
        Query namedQuery = this.analysis.getNamedQuery(node);
        Scope scope = this.analysis.getScope((Node)node);
        if (namedQuery != null) {
            RelationPlan subPlan = this.analysis.isExpandableQuery(namedQuery) ? new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).planExpand(namedQuery) : (RelationPlan)this.process((Node)namedQuery, null);
            List types = (List)this.analysis.getOutputDescriptor((Node)node).getAllFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            NodeAndMappings coerced = QueryPlanner.coerce(subPlan, types, this.symbolAllocator, this.idAllocator);
            plan = new RelationPlan(coerced.getNode(), scope, coerced.getFields(), this.outerContext);
        } else {
            TableHandle handle = this.analysis.getTableHandle(node);
            ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
            ImmutableMap.Builder columns = ImmutableMap.builder();
            for (Field field : scope.getRelationType().getAllFields()) {
                Symbol symbol = this.symbolAllocator.newSymbol(field);
                outputSymbolsBuilder.add((Object)symbol);
                columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
            }
            ImmutableList outputSymbols = outputSymbolsBuilder.build();
            boolean updateTarget = this.analysis.isUpdateTarget(node);
            TableScanNode root = TableScanNode.newInstance(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnHandle>)columns.build(), updateTarget, Optional.empty());
            plan = new RelationPlan(root, scope, (List<Symbol>)outputSymbols, this.outerContext);
            List<Type> types = this.analysis.getRelationCoercion((Relation)node);
            if (types != null) {
                NodeAndMappings coerced = QueryPlanner.coerce(plan, types, this.symbolAllocator, this.idAllocator);
                plan = new RelationPlan(coerced.getNode(), scope, coerced.getFields(), this.outerContext);
            }
        }
        plan = this.addRowFilters(node, plan);
        plan = this.addColumnMasks(node, plan);
        return plan;
    }

    private RelationPlan addRowFilters(Table node, RelationPlan plan) {
        return this.addRowFilters(node, plan, Function.identity());
    }

    public RelationPlan addRowFilters(Table node, RelationPlan plan, Function<Expression, Expression> predicateTransformation) {
        return this.addRowFilters(node, plan, predicateTransformation, this.analysis::getAccessControlScope);
    }

    public RelationPlan addRowFilters(Table node, RelationPlan plan, Function<Expression, Expression> predicateTransformation, Function<Table, Scope> accessControlScope) {
        List<Expression> filters = this.analysis.getRowFilters(node);
        if (filters.isEmpty()) {
            return plan;
        }
        PlanBuilder planBuilder = PlanBuilder.newPlanBuilder(plan, this.analysis, this.lambdaDeclarationToSymbolMap).withScope(accessControlScope.apply(node), plan.getFieldMappings());
        for (Expression filter : filters) {
            planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, filter, this.analysis.getSubqueries((Node)filter));
            Expression predicate = planBuilder.rewrite(filter);
            predicate = predicateTransformation.apply(predicate);
            planBuilder = planBuilder.withNewRoot(new FilterNode(this.idAllocator.getNextId(), planBuilder.getRoot(), predicate));
        }
        return new RelationPlan(planBuilder.getRoot(), plan.getScope(), plan.getFieldMappings(), this.outerContext);
    }

    private RelationPlan addColumnMasks(Table table, RelationPlan plan) {
        Map<String, List<Expression>> columnMasks = this.analysis.getColumnMasks(table);
        if (columnMasks.isEmpty()) {
            return plan;
        }
        PlanBuilder planBuilder = PlanBuilder.newPlanBuilder(plan, this.analysis, this.lambdaDeclarationToSymbolMap).withScope(this.analysis.getAccessControlScope(table), plan.getFieldMappings());
        for (int i = 0; i < plan.getDescriptor().getAllFieldCount(); ++i) {
            Field field = plan.getDescriptor().getFieldByIndex(i);
            for (Expression mask : columnMasks.getOrDefault(field.getName().orElseThrow(), (List<Expression>)ImmutableList.of())) {
                planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, mask, this.analysis.getSubqueries((Node)mask));
                LinkedHashMap<Symbol, Expression> assignments = new LinkedHashMap<Symbol, Expression>();
                for (Symbol symbol : planBuilder.getRoot().getOutputSymbols()) {
                    assignments.put(symbol, (Expression)symbol.toSymbolReference());
                }
                assignments.put(plan.getFieldMappings().get(i), QueryPlanner.coerceIfNecessary(this.analysis, mask, planBuilder.rewrite(mask)));
                planBuilder = planBuilder.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), planBuilder.getRoot(), Assignments.copyOf(assignments)));
            }
        }
        return new RelationPlan(planBuilder.getRoot(), plan.getScope(), plan.getFieldMappings(), this.outerContext);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        PlanNode root = subPlan.getRoot();
        ImmutableList mappings = subPlan.getFieldMappings();
        if (node.getColumnNames() != null) {
            ImmutableList.Builder newMappings = ImmutableList.builder();
            for (int i = 0; i < subPlan.getDescriptor().getAllFieldCount(); ++i) {
                if (subPlan.getDescriptor().getFieldByIndex(i).isHidden()) continue;
                newMappings.add((Object)subPlan.getFieldMappings().get(i));
            }
            mappings = newMappings.build();
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)mappings, this.outerContext);
    }

    protected RelationPlan visitPatternRecognitionRelation(PatternRecognitionRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getInput(), context);
        ImmutableList inputs = ImmutableList.builder().addAll((Iterable)node.getPartitionBy()).addAll((Iterable)NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()).stream().map(SortItem::getSortKey).collect(ImmutableList.toImmutableList())).build();
        PlanBuilder planBuilder = PlanBuilder.newPlanBuilder(subPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        planBuilder = planBuilder.appendProjections((Iterable<Expression>)inputs, this.symbolAllocator, this.idAllocator);
        ImmutableList.Builder outputLayout = ImmutableList.builder();
        boolean oneRowOutput = node.getRowsPerMatch().isEmpty() || ((PatternRecognitionRelation.RowsPerMatch)node.getRowsPerMatch().get()).isOneRow();
        WindowNode.Specification specification = QueryPlanner.planWindowSpecification(node.getPartitionBy(), node.getOrderBy(), planBuilder::translate);
        outputLayout.addAll(specification.getPartitionBy());
        if (!oneRowOutput) {
            NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()).stream().map(SortItem::getSortKey).map(planBuilder::translate).forEach(arg_0 -> ((ImmutableList.Builder)outputLayout).add(arg_0));
        }
        planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, QueryPlanner.extractPatternRecognitionExpressions(node.getVariableDefinitions(), node.getMeasures()), this.analysis.getSubqueries((Node)node));
        PatternRecognitionComponents components = this.planPatternRecognitionComponents(planBuilder::rewrite, node.getSubsets(), node.getMeasures(), node.getAfterMatchSkipTo(), node.getPatternSearchMode(), node.getPattern(), node.getVariableDefinitions());
        outputLayout.addAll(components.getMeasureOutputs());
        if (!oneRowOutput) {
            ImmutableSet inputSymbolsOnOutput = ImmutableSet.copyOf((Collection)outputLayout.build());
            subPlan.getFieldMappings().stream().filter(arg_0 -> RelationPlanner.lambda$visitPatternRecognitionRelation$0((Set)inputSymbolsOnOutput, arg_0)).forEach(arg_0 -> ((ImmutableList.Builder)outputLayout).add(arg_0));
        }
        PatternRecognitionNode planNode = new PatternRecognitionNode(this.idAllocator.getNextId(), planBuilder.getRoot(), specification, Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0, (Map<Symbol, WindowNode.Function>)ImmutableMap.of(), components.getMeasures(), Optional.empty(), node.getRowsPerMatch().orElse(PatternRecognitionRelation.RowsPerMatch.ONE), components.getSkipToLabel(), components.getSkipToPosition(), components.isInitial(), components.getPattern(), components.getSubsets(), components.getVariableDefinitions());
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), (List<Symbol>)outputLayout.build(), this.outerContext);
    }

    public PatternRecognitionComponents planPatternRecognitionComponents(Function<Expression, Expression> expressionRewrite, List<SubsetDefinition> subsets, List<MeasureDefinition> measures, Optional<SkipTo> skipTo, Optional<PatternSearchMode> searchMode, RowPattern pattern, List<VariableDefinition> variableDefinitions) {
        ImmutableMap.Builder rewrittenSubsets = ImmutableMap.builder();
        for (SubsetDefinition subsetDefinition : subsets) {
            IrLabel label = RelationPlanner.irLabel(subsetDefinition.getName());
            Set elements = (Set)subsetDefinition.getIdentifiers().stream().map(RelationPlanner::irLabel).collect(ImmutableSet.toImmutableSet());
            rewrittenSubsets.put((Object)label, (Object)elements);
        }
        ImmutableMap.Builder rewrittenMeasures = ImmutableMap.builder();
        ImmutableList.Builder measureOutputs = ImmutableList.builder();
        for (MeasureDefinition measureDefinition : measures) {
            Type type = this.analysis.getType(measureDefinition.getExpression());
            Symbol symbol = this.symbolAllocator.newSymbol(measureDefinition.getName().getValue().toLowerCase(Locale.ENGLISH), type);
            Expression expression = expressionRewrite.apply(measureDefinition.getExpression());
            LogicalIndexExtractor.ExpressionAndValuePointers measure = LogicalIndexExtractor.rewrite(expression, (Map<IrLabel, Set<IrLabel>>)rewrittenSubsets.build(), this.symbolAllocator, this.plannerContext.getMetadata());
            rewrittenMeasures.put((Object)symbol, (Object)new PatternRecognitionNode.Measure(measure, type));
            measureOutputs.add((Object)symbol);
        }
        IrRowPattern rewrittenPattern = RowPatternToIrRewriter.rewrite(pattern, this.analysis);
        ImmutableMap.Builder rewrittenVariableDefinitions = ImmutableMap.builder();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            IrLabel label = RelationPlanner.irLabel(variableDefinition.getName());
            Expression expression = expressionRewrite.apply(variableDefinition.getExpression());
            LogicalIndexExtractor.ExpressionAndValuePointers definition = LogicalIndexExtractor.rewrite(expression, (Map<IrLabel, Set<IrLabel>>)rewrittenSubsets.build(), this.symbolAllocator, this.plannerContext.getMetadata());
            rewrittenVariableDefinitions.put((Object)label, (Object)definition);
        }
        for (String label : this.analysis.getUndefinedLabels(pattern)) {
            rewrittenVariableDefinitions.put((Object)RelationPlanner.irLabel(label), (Object)LogicalIndexExtractor.ExpressionAndValuePointers.TRUE);
        }
        return new PatternRecognitionComponents((Map<IrLabel, Set<IrLabel>>)rewrittenSubsets.build(), (Map<Symbol, PatternRecognitionNode.Measure>)rewrittenMeasures.build(), (List<Symbol>)measureOutputs.build(), skipTo.flatMap(SkipTo::getIdentifier).map(RelationPlanner::irLabel), skipTo.map(SkipTo::getPosition).orElse(SkipTo.Position.PAST_LAST), searchMode.map(mode -> mode.getMode() == PatternSearchMode.Mode.INITIAL).orElse(Boolean.TRUE), rewrittenPattern, (Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers>)rewrittenVariableDefinitions.build());
    }

    private static IrLabel irLabel(Identifier identifier) {
        return new IrLabel(identifier.getCanonicalValue());
    }

    private static IrLabel irLabel(String label) {
        return new IrLabel(label);
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        double ratio = this.analysis.getSampleRatio(node);
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNode.Type.fromType(node.getType()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), subPlan.getFieldMappings(), this.outerContext);
    }

    protected RelationPlan visitLateral(Lateral node, Void context) {
        RelationPlan plan = (RelationPlan)this.process((Node)node.getQuery(), context);
        return new RelationPlan(plan.getRoot(), this.analysis.getScope((Node)node), plan.getFieldMappings(), this.outerContext);
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
        Optional<Unnest> unnest = RelationPlanner.getUnnest(node.getRight());
        if (unnest.isPresent()) {
            return this.planJoinUnnest(leftPlan, node, unnest.get());
        }
        Optional<Lateral> lateral = RelationPlanner.getLateral(node.getRight());
        if (lateral.isPresent()) {
            return this.planCorrelatedJoin(node, leftPlan, lateral.get());
        }
        RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
        if (node.getCriteria().isPresent() && node.getCriteria().get() instanceof JoinUsing) {
            return this.planJoinUsing(node, leftPlan, rightPlan);
        }
        return this.planJoin(this.analysis.getJoinCriteria(node), node.getType(), this.analysis.getScope((Node)node), leftPlan, rightPlan, this.analysis.getSubqueries((Node)node));
    }

    private RelationPlan planJoin(Expression criteria, Join.Type type, Scope scope, RelationPlan leftPlan, RelationPlan rightPlan, Analysis.SubqueryAnalysis subqueries) {
        RelationType left;
        ArrayList<Expression> postInnerJoinConditions;
        ArrayList<Expression> complexJoinExpressions;
        ImmutableList.Builder equiClauses;
        PlanBuilder rightPlanBuilder;
        PlanBuilder leftPlanBuilder;
        ImmutableList outputSymbols;
        block19: {
            outputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
            leftPlanBuilder = PlanBuilder.newPlanBuilder(leftPlan, this.analysis, this.lambdaDeclarationToSymbolMap).withScope(scope, (List<Symbol>)outputSymbols);
            rightPlanBuilder = PlanBuilder.newPlanBuilder(rightPlan, this.analysis, this.lambdaDeclarationToSymbolMap).withScope(scope, (List<Symbol>)outputSymbols);
            equiClauses = ImmutableList.builder();
            complexJoinExpressions = new ArrayList<Expression>();
            postInnerJoinConditions = new ArrayList<Expression>();
            left = leftPlan.getDescriptor();
            RelationType right = rightPlan.getDescriptor();
            if (type == Join.Type.CROSS || type == Join.Type.IMPLICIT) break block19;
            ArrayList<Expression> leftComparisonExpressions = new ArrayList<Expression>();
            ArrayList<Expression> rightComparisonExpressions = new ArrayList<Expression>();
            ArrayList<ComparisonExpression.Operator> joinConditionComparisonOperators = new ArrayList<ComparisonExpression.Operator>();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(criteria)) {
                block21: {
                    block20: {
                        if (!RelationPlanner.isEqualComparisonExpression(conjunct) && type != Join.Type.INNER) {
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        Set<QualifiedName> dependencies = SymbolsExtractor.extractNames(conjunct, this.analysis.getColumnReferences());
                        if (dependencies.stream().allMatch(left::canResolve)) break block20;
                        if (!dependencies.stream().allMatch(right::canResolve)) break block21;
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                if (conjunct instanceof ComparisonExpression) {
                    Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                    Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                    ComparisonExpression.Operator comparisonOperator = ((ComparisonExpression)conjunct).getOperator();
                    Set<QualifiedName> firstDependencies = SymbolsExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                    Set<QualifiedName> secondDependencies = SymbolsExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                    if (firstDependencies.stream().allMatch(left::canResolve)) {
                        if (secondDependencies.stream().allMatch(right::canResolve)) {
                            leftComparisonExpressions.add(firstExpression);
                            rightComparisonExpressions.add(secondExpression);
                            joinConditionComparisonOperators.add(comparisonOperator);
                            continue;
                        }
                    }
                    if (firstDependencies.stream().allMatch(right::canResolve)) {
                        if (secondDependencies.stream().allMatch(left::canResolve)) {
                            leftComparisonExpressions.add(secondExpression);
                            rightComparisonExpressions.add(firstExpression);
                            joinConditionComparisonOperators.add(comparisonOperator.flip());
                            continue;
                        }
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                complexJoinExpressions.add(conjunct);
            }
            leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, leftComparisonExpressions, subqueries);
            rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, rightComparisonExpressions, subqueries);
            leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.symbolAllocator, this.idAllocator);
            rightPlanBuilder = rightPlanBuilder.appendProjections((Iterable<Expression>)rightComparisonExpressions, this.symbolAllocator, this.idAllocator);
            QueryPlanner.PlanAndMappings leftCoercions = QueryPlanner.coerce(leftPlanBuilder, leftComparisonExpressions, this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
            leftPlanBuilder = leftCoercions.getSubPlan();
            QueryPlanner.PlanAndMappings rightCoercions = QueryPlanner.coerce(rightPlanBuilder, (List<Expression>)rightComparisonExpressions, this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
            rightPlanBuilder = rightCoercions.getSubPlan();
            for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                if (joinConditionComparisonOperators.get(i) == ComparisonExpression.Operator.EQUAL) {
                    Symbol leftSymbol = leftCoercions.get((Expression)leftComparisonExpressions.get(i));
                    Symbol rightSymbol = rightCoercions.get((Expression)rightComparisonExpressions.get(i));
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                postInnerJoinConditions.add((Expression)new ComparisonExpression((ComparisonExpression.Operator)joinConditionComparisonOperators.get(i), (Expression)leftCoercions.get((Expression)leftComparisonExpressions.get(i)).toSymbolReference(), (Expression)rightCoercions.get((Expression)rightComparisonExpressions.get(i)).toSymbolReference()));
            }
        }
        PlanNode root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(type), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        if (type != Join.Type.INNER) {
            for (Expression complexExpression : complexJoinExpressions) {
                Set<QualifiedName> dependencies = SymbolsExtractor.extractNamesNoSubqueries(complexExpression, this.analysis.getColumnReferences());
                if (dependencies.stream().allMatch(left::canResolve)) {
                    leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, complexExpression, subqueries);
                    continue;
                }
                rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, complexExpression, subqueries);
            }
        }
        TranslationMap translationMap = new TranslationMap(this.outerContext, scope, this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)outputSymbols).withAdditionalMappings(leftPlanBuilder.getTranslations().getMappings()).withAdditionalMappings(rightPlanBuilder.getTranslations().getMappings());
        if (type != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            Expression joinedFilterCondition = ExpressionUtils.and(complexJoinExpressions);
            Expression rewrittenFilterCondition = translationMap.rewrite(joinedFilterCondition);
            root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(type), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), false, Optional.of(rewrittenFilterCondition), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        }
        if (type == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root);
            rootPlanBuilder = this.subqueryPlanner.handleSubqueries(rootPlanBuilder, complexJoinExpressions, subqueries);
            for (Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(rootPlanBuilder.rewrite(expression));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = ExpressionUtils.and(postInnerJoinConditions);
                root = new FilterNode(this.idAllocator.getNextId(), root, postInnerJoinCriteria);
            }
        }
        return new RelationPlan(root, scope, (List<Symbol>)outputSymbols, this.outerContext);
    }

    private RelationPlan planJoinUsing(Join node, RelationPlan left, RelationPlan right) {
        Symbol symbol;
        List joinColumns = ((JoinUsing)node.getCriteria().orElseThrow()).getColumns();
        Analysis.JoinUsingAnalysis joinAnalysis = this.analysis.getJoinUsing(node);
        ImmutableList.Builder clauses = ImmutableList.builder();
        HashMap<Identifier, Symbol> leftJoinColumns = new HashMap<Identifier, Symbol>();
        HashMap<Identifier, Symbol> rightJoinColumns = new HashMap<Identifier, Symbol>();
        Assignments.Builder leftCoercions = Assignments.builder();
        Assignments.Builder rightCoercions = Assignments.builder();
        leftCoercions.putIdentities(left.getRoot().getOutputSymbols());
        rightCoercions.putIdentities(right.getRoot().getOutputSymbols());
        for (int i = 0; i < joinColumns.size(); ++i) {
            Identifier identifier = (Identifier)joinColumns.get(i);
            Type type = this.analysis.getType((Expression)identifier);
            Symbol leftOutput = this.symbolAllocator.newSymbol((Expression)identifier, type);
            int leftField = joinAnalysis.getLeftJoinFields().get(i);
            leftCoercions.put(leftOutput, (Expression)new Cast((Expression)left.getSymbol(leftField).toSymbolReference(), TypeSignatureTranslator.toSqlType(type), false, this.typeCoercion.isTypeOnlyCoercion(left.getDescriptor().getFieldByIndex(leftField).getType(), type)));
            leftJoinColumns.put(identifier, leftOutput);
            Symbol rightOutput = this.symbolAllocator.newSymbol((Expression)identifier, type);
            int rightField = joinAnalysis.getRightJoinFields().get(i);
            rightCoercions.put(rightOutput, (Expression)new Cast((Expression)right.getSymbol(rightField).toSymbolReference(), TypeSignatureTranslator.toSqlType(type), false, this.typeCoercion.isTypeOnlyCoercion(right.getDescriptor().getFieldByIndex(rightField).getType(), type)));
            rightJoinColumns.put(identifier, rightOutput);
            clauses.add((Object)new JoinNode.EquiJoinClause(leftOutput, rightOutput));
        }
        ProjectNode leftCoercion = new ProjectNode(this.idAllocator.getNextId(), left.getRoot(), leftCoercions.build());
        ProjectNode rightCoercion = new ProjectNode(this.idAllocator.getNextId(), right.getRoot(), rightCoercions.build());
        JoinNode join = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftCoercion, rightCoercion, (List<JoinNode.EquiJoinClause>)clauses.build(), leftCoercion.getOutputSymbols(), rightCoercion.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Identifier column : joinColumns) {
            Symbol output = this.symbolAllocator.newSymbol((Expression)column, this.analysis.getType((Expression)column));
            outputs.add((Object)output);
            assignments.put(output, (Expression)new CoalesceExpression((Expression)((Symbol)leftJoinColumns.get(column)).toSymbolReference(), (Expression)((Symbol)rightJoinColumns.get(column)).toSymbolReference(), new Expression[0]));
        }
        Iterator<Object> iterator = joinAnalysis.getOtherLeftFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = left.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.put(symbol, (Expression)symbol.toSymbolReference());
        }
        iterator = joinAnalysis.getOtherRightFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = right.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.put(symbol, (Expression)symbol.toSymbolReference());
        }
        return new RelationPlan(new ProjectNode(this.idAllocator.getNextId(), join, assignments.build()), this.analysis.getScope((Node)node), (List<Symbol>)outputs.build(), this.outerContext);
    }

    private static Optional<Unnest> getUnnest(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return RelationPlanner.getUnnest(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Unnest) {
            return Optional.of((Unnest)relation);
        }
        return Optional.empty();
    }

    private static Optional<Lateral> getLateral(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return RelationPlanner.getLateral(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Lateral) {
            return Optional.of((Lateral)relation);
        }
        return Optional.empty();
    }

    private RelationPlan planCorrelatedJoin(Join join, RelationPlan leftPlan, Lateral lateral) {
        BooleanLiteral filterExpression;
        PlanBuilder leftPlanBuilder = PlanBuilder.newPlanBuilder(leftPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        RelationPlan rightPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, Optional.of(leftPlanBuilder.getTranslations()), this.session, this.recursiveSubqueries).process((Node)lateral.getQuery(), null);
        PlanBuilder rightPlanBuilder = PlanBuilder.newPlanBuilder(rightPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        if (join.getCriteria().isEmpty()) {
            filterExpression = BooleanLiteral.TRUE_LITERAL;
        } else {
            JoinCriteria criteria = (JoinCriteria)join.getCriteria().get();
            if (criteria instanceof JoinUsing || criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)join, "Correlated join with criteria other than ON is not supported", new Object[0]);
            }
            filterExpression = (Expression)Iterables.getOnlyElement((Iterable)criteria.getNodes());
        }
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
        TranslationMap translationMap = new TranslationMap(this.outerContext, this.analysis.getScope((Node)join), this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)outputSymbols).withAdditionalMappings(leftPlanBuilder.getTranslations().getMappings()).withAdditionalMappings(rightPlanBuilder.getTranslations().getMappings());
        Expression rewrittenFilterCondition = translationMap.rewrite((Expression)filterExpression);
        PlanBuilder planBuilder = this.subqueryPlanner.appendCorrelatedJoin(leftPlanBuilder, rightPlanBuilder.getRoot(), lateral.getQuery(), CorrelatedJoinNode.Type.typeConvert(join.getType()), rewrittenFilterCondition, (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of());
        return new RelationPlan(planBuilder.getRoot(), this.analysis.getScope((Node)join), (List<Symbol>)outputSymbols, this.outerContext);
    }

    private static boolean isEqualComparisonExpression(Expression conjunct) {
        return conjunct instanceof ComparisonExpression && ((ComparisonExpression)conjunct).getOperator() == ComparisonExpression.Operator.EQUAL;
    }

    private RelationPlan planJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node) {
        Optional<Expression> filterExpression = Optional.empty();
        if (joinNode.getCriteria().isPresent()) {
            JoinCriteria criteria = (JoinCriteria)joinNode.getCriteria().get();
            if (criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "Natural join involving UNNEST is not supported", new Object[0]);
            }
            if (criteria instanceof JoinUsing) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "USING for join involving UNNEST is not supported", new Object[0]);
            }
            Expression filter = (Expression)Iterables.getOnlyElement((Iterable)criteria.getNodes());
            if (filter.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                filterExpression = Optional.of(filter);
            } else {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "JOIN involving UNNEST on condition other than TRUE is not supported", new Object[0]);
            }
        }
        return this.planUnnest(PlanBuilder.newPlanBuilder(leftPlan, this.analysis, this.lambdaDeclarationToSymbolMap), node, leftPlan.getFieldMappings(), filterExpression, joinNode.getType(), this.analysis.getScope((Node)joinNode));
    }

    private RelationPlan planUnnest(PlanBuilder subPlan, Unnest node, List<Symbol> replicatedColumns, Optional<Expression> filter, Join.Type type, Scope outputScope) {
        subPlan = subPlan.appendProjections(node.getExpressions(), this.symbolAllocator, this.idAllocator);
        Map allocations = (Map)this.analysis.getOutputDescriptor((Node)node).getVisibleFields().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this.symbolAllocator::newSymbol));
        Analysis.UnnestAnalysis unnestAnalysis = this.analysis.getUnnest(node);
        ImmutableList.Builder mappings = ImmutableList.builder();
        for (Expression expression : node.getExpressions()) {
            Symbol input = subPlan.translate(expression);
            List outputs = (List)unnestAnalysis.getMappings().get(NodeRef.of((Node)expression)).stream().map(allocations::get).collect(ImmutableList.toImmutableList());
            mappings.add((Object)new UnnestNode.Mapping(input, outputs));
        }
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), subPlan.getRoot(), replicatedColumns, (List<UnnestNode.Mapping>)mappings.build(), unnestAnalysis.getOrdinalityField().map(allocations::get), JoinNode.Type.typeConvert(type), filter);
        return new RelationPlan(unnestNode, outputScope, unnestNode.getOutputSymbols(), this.outerContext);
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        RelationPlan plan = (RelationPlan)this.process((Node)node.getQuery(), context);
        return new RelationPlan(plan.getRoot(), this.analysis.getScope((Node)node), plan.getFieldMappings(), this.outerContext);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).plan(node);
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).plan(node);
    }

    protected RelationPlan visitSubqueryExpression(SubqueryExpression node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitValues(Values node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList outputSymbols = outputSymbolsBuilder.build();
        TranslationMap translationMap = new TranslationMap(this.outerContext, this.analysis.getScope((Node)node), this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)outputSymbols);
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Expression row : node.getRows()) {
            if (row instanceof Row) {
                rows.add((Object)new Row((List)((Row)row).getItems().stream().map(item -> QueryPlanner.coerceIfNecessary(this.analysis, item, translationMap.rewrite((Expression)item))).collect(ImmutableList.toImmutableList())));
                continue;
            }
            if (this.analysis.getType(row) instanceof RowType) {
                rows.add((Object)QueryPlanner.coerceIfNecessary(this.analysis, row, translationMap.rewrite(row)));
                continue;
            }
            rows.add((Object)new Row((List)ImmutableList.of((Object)QueryPlanner.coerceIfNecessary(this.analysis, row, translationMap.rewrite(row)))));
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbols, (List<Expression>)rows.build());
        return new RelationPlan(valuesNode, scope, (List<Symbol>)outputSymbols, this.outerContext);
    }

    protected RelationPlan visitUnnest(Unnest node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        return this.planUnnest(this.planSingleEmptyRow(scope.getOuterQueryParent()), node, (List<Symbol>)ImmutableList.of(), Optional.empty(), Join.Type.INNER, scope);
    }

    private PlanBuilder planSingleEmptyRow(Optional<Scope> parent) {
        Scope.Builder scope = Scope.builder();
        parent.ifPresent(scope::withOuterQueryParent);
        ValuesNode values = new ValuesNode(this.idAllocator.getNextId(), 1);
        TranslationMap translations = new TranslationMap(this.outerContext, scope.build(), this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)ImmutableList.of());
        return new PlanBuilder(translations, values);
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), planNode.getOutputSymbols(), this.outerContext);
    }

    protected RelationPlan visitIntersect(Intersect node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for INTERSECT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        IntersectNode planNode = new IntersectNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()), node.isDistinct());
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols(), this.outerContext);
    }

    protected RelationPlan visitExcept(Except node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for EXCEPT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        ExceptNode planNode = new ExceptNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()), node.isDistinct());
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols(), this.outerContext);
    }

    private SetOperationPlan process(SetOperation node) {
        RelationType outputFields = this.analysis.getOutputDescriptor((Node)node);
        List outputs = (List)outputFields.getAllFields().stream().map(this.symbolAllocator::newSymbol).collect(ImmutableList.toImmutableList());
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        ImmutableList.Builder sources = ImmutableList.builder();
        for (Relation child : node.getRelations()) {
            RelationPlan plan = (RelationPlan)this.process((Node)child, null);
            List<Type> types = this.analysis.getRelationCoercion(child);
            NodeAndMappings planAndMappings = types == null ? QueryPlanner.pruneInvisibleFields(plan, this.idAllocator) : QueryPlanner.coerce(plan, types, this.symbolAllocator, this.idAllocator);
            for (int i = 0; i < outputFields.getAllFields().size(); ++i) {
                symbolMapping.put((Object)((Symbol)outputs.get(i)), (Object)planAndMappings.getFields().get(i));
            }
            sources.add((Object)planAndMappings.getNode());
        }
        return new SetOperationPlan((List<PlanNode>)sources.build(), (ListMultimap<Symbol, Symbol>)symbolMapping.build());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(node.getOutputSymbols()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
    }

    private static /* synthetic */ boolean lambda$visitPatternRecognitionRelation$0(Set inputSymbolsOnOutput, Symbol symbol) {
        return !inputSymbolsOnOutput.contains(symbol);
    }

    public static class PatternRecognitionComponents {
        private final Map<IrLabel, Set<IrLabel>> subsets;
        private final Map<Symbol, PatternRecognitionNode.Measure> measures;
        private final List<Symbol> measureOutputs;
        private final Optional<IrLabel> skipToLabel;
        private final SkipTo.Position skipToPosition;
        private final boolean initial;
        private final IrRowPattern pattern;
        private final Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> variableDefinitions;

        public PatternRecognitionComponents(Map<IrLabel, Set<IrLabel>> subsets, Map<Symbol, PatternRecognitionNode.Measure> measures, List<Symbol> measureOutputs, Optional<IrLabel> skipToLabel, SkipTo.Position skipToPosition, boolean initial, IrRowPattern pattern, Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> variableDefinitions) {
            this.subsets = Objects.requireNonNull(subsets, "subsets is null");
            this.measures = Objects.requireNonNull(measures, "measures is null");
            this.measureOutputs = Objects.requireNonNull(measureOutputs, "measureOutputs is null");
            this.skipToLabel = Objects.requireNonNull(skipToLabel, "skipToLabel is null");
            this.skipToPosition = Objects.requireNonNull(skipToPosition, "skipToPosition is null");
            this.initial = initial;
            this.pattern = Objects.requireNonNull(pattern, "pattern is null");
            this.variableDefinitions = Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
        }

        public Map<IrLabel, Set<IrLabel>> getSubsets() {
            return this.subsets;
        }

        public Map<Symbol, PatternRecognitionNode.Measure> getMeasures() {
            return this.measures;
        }

        public List<Symbol> getMeasureOutputs() {
            return this.measureOutputs;
        }

        public Optional<IrLabel> getSkipToLabel() {
            return this.skipToLabel;
        }

        public SkipTo.Position getSkipToPosition() {
            return this.skipToPosition;
        }

        public boolean isInitial() {
            return this.initial;
        }

        public IrRowPattern getPattern() {
            return this.pattern;
        }

        public Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> getVariableDefinitions() {
            return this.variableDefinitions;
        }
    }

    private static final class SetOperationPlan {
        private final List<PlanNode> sources;
        private final ListMultimap<Symbol, Symbol> symbolMapping;

        private SetOperationPlan(List<PlanNode> sources, ListMultimap<Symbol, Symbol> symbolMapping) {
            this.sources = sources;
            this.symbolMapping = symbolMapping;
        }

        public List<PlanNode> getSources() {
            return this.sources;
        }

        public ListMultimap<Symbol, Symbol> getSymbolMapping() {
            return this.symbolMapping;
        }
    }
}

