/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.trino.operator.unnest.UnnestOperatorBlockUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;

class UnnestBlockBuilder {
    private final Type type;
    private Block source;
    private final NullElementFinder nullFinder = new NullElementFinder();
    private boolean usingCopiedBlock;
    private int[] ids;
    private int positionCount;
    private BlockBuilder outputBlockBuilder;
    private PageBuilderStatus pageBuilderStatus;

    public UnnestBlockBuilder(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public void resetInputBlock(Block block) {
        this.source = Objects.requireNonNull(block, "block is null");
        this.clearCurrentOutput();
        this.nullFinder.resetCheck();
    }

    @VisibleForTesting
    void clearCurrentOutput() {
        this.ids = new int[0];
        this.positionCount = 0;
        this.usingCopiedBlock = false;
        this.outputBlockBuilder = null;
        this.pageBuilderStatus = null;
    }

    public void startNewOutput(PageBuilderStatus pageBuilderStatus, int expectedEntries) {
        Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"source is null");
        this.pageBuilderStatus = pageBuilderStatus;
        this.ids = new int[expectedEntries];
        this.positionCount = 0;
        this.usingCopiedBlock = false;
    }

    public Block buildOutputAndFlush() {
        Object outputBlock = this.usingCopiedBlock ? this.outputBlockBuilder.build() : new DictionaryBlock(this.positionCount, this.source, this.ids);
        this.clearCurrentOutput();
        return outputBlock;
    }

    public void appendElement(int index) {
        Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"source is null");
        Preconditions.checkElementIndex((int)index, (int)this.source.getPositionCount());
        if (this.usingCopiedBlock) {
            this.type.appendTo(this.source, index, this.outputBlockBuilder);
        } else {
            this.appendId(index);
        }
    }

    public void appendRange(int startPosition, int length) {
        Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"source is null");
        Preconditions.checkPositionIndexes((int)startPosition, (int)(startPosition + length), (int)this.source.getPositionCount());
        if (this.usingCopiedBlock) {
            for (int i = 0; i < length; ++i) {
                this.type.appendTo(this.source, startPosition + i, this.outputBlockBuilder);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.appendId(startPosition + i);
            }
        }
    }

    public void appendNull() {
        if (this.usingCopiedBlock) {
            this.outputBlockBuilder.appendNull();
        } else {
            int nullIndex = this.nullFinder.getNullElementIndex();
            if (nullIndex == -1) {
                this.startUsingCopiedBlock();
                this.appendNull();
            } else {
                this.appendId(nullIndex);
            }
        }
    }

    private void startUsingCopiedBlock() {
        Objects.requireNonNull(this.pageBuilderStatus, "pageBuilderStatus is null");
        this.outputBlockBuilder = this.type.createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), this.ids.length);
        for (int i = 0; i < this.positionCount; ++i) {
            this.type.appendTo(this.source, this.ids[i], this.outputBlockBuilder);
        }
        this.ids = new int[0];
        this.positionCount = 0;
        this.usingCopiedBlock = true;
    }

    private void appendId(int sourcePosition) {
        if (this.positionCount == this.ids.length) {
            int newSize = UnnestOperatorBlockUtil.calculateNewArraySize(this.ids.length);
            this.ids = Arrays.copyOf(this.ids, newSize);
        }
        this.ids[this.positionCount] = sourcePosition;
        ++this.positionCount;
    }

    public int getPositionCount() {
        if (this.usingCopiedBlock) {
            return this.outputBlockBuilder.getPositionCount();
        }
        return this.positionCount;
    }

    private class NullElementFinder {
        private boolean checkedForNull;
        private int nullElementPosition = -1;

        private NullElementFinder() {
        }

        void resetCheck() {
            this.checkedForNull = false;
            this.nullElementPosition = -1;
        }

        private int getNullElementIndex() {
            if (this.checkedForNull) {
                return this.nullElementPosition;
            }
            this.checkForNull();
            return this.nullElementPosition;
        }

        private void checkForNull() {
            this.nullElementPosition = -1;
            for (int i = 0; i < UnnestBlockBuilder.this.source.getPositionCount(); ++i) {
                if (!UnnestBlockBuilder.this.source.isNull(i)) continue;
                this.nullElementPosition = i;
                break;
            }
            this.checkedForNull = true;
        }
    }
}

