/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.TriStateBooleanState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;

@AggregationFunction(value="bool_and", alias={"every"})
public final class BooleanAndAggregation {
    private BooleanAndAggregation() {
    }

    @InputFunction
    public static void booleanAnd(@AggregationState TriStateBooleanState state, @SqlType(value="boolean") boolean value) {
        if (!value) {
            state.setValue((byte)-1);
        } else if (state.getValue() == 0) {
            state.setValue((byte)1);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState TriStateBooleanState state, @AggregationState TriStateBooleanState otherState) {
        if (state.getValue() == 0) {
            state.setValue(otherState.getValue());
            return;
        }
        if (otherState.getValue() == -1) {
            state.setValue((byte)-1);
        }
    }

    @OutputFunction(value="boolean")
    public static void output(@AggregationState TriStateBooleanState state, BlockBuilder out) {
        TriStateBooleanState.write((Type)BooleanType.BOOLEAN, state, out);
    }
}

