/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.NotFoundException;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class ColumnNotFoundException
extends NotFoundException {
    private final SchemaTableName tableName;
    private final String columnName;

    public ColumnNotFoundException(SchemaTableName tableName, String columnName) {
        this(tableName, columnName, "Column " + columnName + " not found in table " + tableName);
    }

    public ColumnNotFoundException(SchemaTableName tableName, String columnName, String message) {
        super(message);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    public ColumnNotFoundException(SchemaTableName tableName, String columnName, Throwable cause) {
        this(tableName, columnName, "Table " + tableName + " not found", cause);
    }

    public ColumnNotFoundException(SchemaTableName tableName, String columnName, String message, Throwable cause) {
        super(message, cause);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

