/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import io.agroal.api.AgroalDataSourceListener;
import io.agroal.pool.util.ListenerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public final class PriorityScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private static final Runnable EMPTY_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final Queue<RunnableFuture<?>> priorityTasks = new ConcurrentLinkedQueue();
    private final AgroalDataSourceListener[] listeners;

    public PriorityScheduledExecutor(int executorSize, String threadPrefix, AgroalDataSourceListener ... listeners) {
        super(executorSize, new PriorityExecutorThreadFactory(threadPrefix), new ThreadPoolExecutor.CallerRunsPolicy());
        this.setRemoveOnCancelPolicy(true);
        this.listeners = listeners;
    }

    public void executeNow(Runnable priorityTask) {
        this.executeNow(new FutureTask<Object>(priorityTask, null));
    }

    public <T> Future<T> executeNow(Callable<T> priorityTask) {
        return this.executeNow(new FutureTask<T>(priorityTask));
    }

    public <T> Future<T> executeNow(RunnableFuture<T> priorityFuture) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Task " + String.valueOf(priorityFuture) + " rejected from " + String.valueOf(this));
        }
        this.priorityTasks.add(priorityFuture);
        if (!priorityFuture.isDone()) {
            this.execute(EMPTY_TASK);
        }
        return priorityFuture;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable lowPriorityTask) {
        RunnableFuture<?> priorityTask;
        while ((priorityTask = this.priorityTasks.poll()) != null) {
            if (this.isShutdown()) {
                priorityTask.cancel(false);
                continue;
            }
            try {
                priorityTask.run();
                this.afterExecute(priorityTask, null);
            }
            catch (Throwable t) {
                this.afterExecute(priorityTask, t);
            }
        }
        super.beforeExecute(thread, lowPriorityTask);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t != null) {
            ListenerHelper.fireOnWarning(this.listeners, t);
        }
        super.afterExecute(r, t);
    }

    @Override
    public void shutdown() {
        if (!this.isShutdown()) {
            this.executeNow(() -> super.shutdown());
            this.execute(this::shutdownNow);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        for (RunnableFuture runnableFuture : this.priorityTasks) {
            runnableFuture.cancel(true);
        }
        ArrayList<Runnable> allTasks = new ArrayList<Runnable>(this.priorityTasks);
        this.priorityTasks.clear();
        allTasks.addAll(super.shutdownNow());
        return allTasks;
    }

    private static class PriorityExecutorThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadCount;
        private final String threadPrefix;

        PriorityExecutorThreadFactory(String threadPrefix) {
            this.threadPrefix = threadPrefix;
            this.threadCount = new AtomicLong();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.threadPrefix + this.threadCount.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }
}

