/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AksExchangeTokenCredential;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.ManagedIdentityMsalCredential;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIdentityCredential.class);
    final ManagedIdentityServiceCredential managedIdentityServiceCredential;
    private final IdentityClientOptions identityClientOptions;
    private final String managedIdentityId;
    static final String PROPERTY_IDENTITY_SERVER_THUMBPRINT = "IDENTITY_SERVER_THUMBPRINT";
    static final String AZURE_FEDERATED_TOKEN_FILE = "AZURE_FEDERATED_TOKEN_FILE";

    ManagedIdentityCredential(String clientId, String resourceId, String objectId, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder clientBuilder = new IdentityClientBuilder().clientId(clientId).resourceId(resourceId).objectId(objectId).identityClientOptions(identityClientOptions);
        this.identityClientOptions = identityClientOptions;
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        this.managedIdentityId = this.fetchManagedIdentityId(clientId, resourceId, objectId);
        if (configuration.contains("AZURE_TENANT_ID") && configuration.get(AZURE_FEDERATED_TOKEN_FILE) != null) {
            String clientIdentifier = clientId == null ? configuration.get("AZURE_CLIENT_ID") : clientId;
            clientBuilder.clientId(clientIdentifier);
            clientBuilder.tenantId(configuration.get("AZURE_TENANT_ID"));
            clientBuilder.clientAssertionPath(configuration.get(AZURE_FEDERATED_TOKEN_FILE));
            clientBuilder.clientAssertionTimeout(Duration.ofMinutes(5L));
            this.managedIdentityServiceCredential = new AksExchangeTokenCredential(clientIdentifier, clientBuilder.identityClientOptions(identityClientOptions).build());
        } else {
            this.managedIdentityServiceCredential = new ManagedIdentityMsalCredential(clientId, clientBuilder.build());
        }
        LoggingUtil.logAvailableEnvironmentVariables(LOGGER, configuration);
    }

    public String getClientId() {
        return this.managedIdentityServiceCredential.getClientId();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.managedIdentityServiceCredential == null) {
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. The Target Azure platform could not be determined from environment variables.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/managedidentitycredential/troubleshoot"))));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)this.managedIdentityId)) {
            ManagedIdentitySourceType managedIdentitySourceType = ManagedIdentityApplication.getManagedIdentitySource();
            if (ManagedIdentitySourceType.CLOUD_SHELL.equals((Object)managedIdentitySourceType) || ManagedIdentitySourceType.AZURE_ARC.equals((Object)managedIdentitySourceType)) {
                return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. User-assigned managed identity is not supported in " + managedIdentitySourceType + ". To use system-assigned managed identity, remove the configured client ID on the " + (this.identityClientOptions.isChained() ? "DefaultAzureCredentialBuilder." : "ManagedIdentityCredentialBuilder.")))));
            }
            if (ManagedIdentitySourceType.SERVICE_FABRIC.equals((Object)managedIdentitySourceType)) {
                return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("Specifying a clientId or resourceId is not supported by the Service Fabric managed identity environment. The managed identity configuration is determined by the Service Fabric cluster resource configuration. See https://aka.ms/servicefabricmi for more information."))));
            }
            LOGGER.info("User-assigned Managed Identity ID: " + this.getClientId());
        }
        return this.managedIdentityServiceCredential.authenticate(request).doOnSuccess(t -> LOGGER.info("Azure Identity => Managed Identity environment: {}", new Object[]{this.managedIdentityServiceCredential.getEnvironment()})).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClientOptions, request, error));
    }

    String fetchManagedIdentityId(String clientId, String resourceId, String objectId) {
        if (clientId != null) {
            return clientId;
        }
        if (resourceId != null) {
            return resourceId;
        }
        if (objectId != null) {
            return objectId;
        }
        return null;
    }
}

