/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.polaris.persistence.nosql.nodeids.api;

import jakarta.annotation.Nullable;

public interface NodeLease {
  /**
   * Returns the {@link Node} representation for this lease if the lease has not been released or
   * {@code null}.
   */
  @Nullable
  Node node();

  /**
   * Permanently release the lease. Does nothing, if already released. Throws if persisting the
   * released state fails.
   */
  void release();

  /**
   * Force a lease renewal, generally not recommended nor necessary. Throws, if the lease is already
   * released.
   */
  void renew();

  /** Returns the node ID if the lease is active/valid or {@code -1}. */
  int nodeIdIfValid();
}
