/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.json;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.json.JSONRecordExtractor;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;
import org.apache.pinot.spi.utils.JsonUtils;

public class JSONRecordReader
implements RecordReader {
    private File _dataFile;
    private InputStream _inputStream;
    private JSONRecordExtractor _recordExtractor;
    private MappingIterator<Map<String, Object>> _iterator;

    private void init() throws IOException {
        this._inputStream = RecordReaderUtils.getBufferedInputStream((File)this._dataFile);
        try {
            this._iterator = JsonUtils.DEFAULT_READER.forType((TypeReference)new TypeReference<Map<String, Object>>(){}).readValues(this._inputStream);
        }
        catch (Exception e) {
            if (this._iterator != null) {
                this._iterator.close();
            }
            if (this._inputStream != null) {
                this._inputStream.close();
            }
            throw e;
        }
    }

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
        this._dataFile = dataFile;
        this._recordExtractor = new JSONRecordExtractor();
        this._recordExtractor.init(fieldsToRead, null);
        this.init();
    }

    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    public GenericRow next(GenericRow reuse) {
        Map record = (Map)this._iterator.next();
        this._recordExtractor.extract(record, reuse);
        return reuse;
    }

    public void rewind() throws IOException {
        this._iterator.close();
        this._inputStream.close();
        this.init();
    }

    public void close() throws IOException {
        this._iterator.close();
        this._inputStream.close();
    }
}

