/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientToAMTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_CLIENT_TOKEN");
    private YarnSecurityTokenProtos.ClientToAMTokenIdentifierProto proto;

    public ClientToAMTokenIdentifier() {
    }

    public ClientToAMTokenIdentifier(ApplicationAttemptId id, String client) {
        YarnSecurityTokenProtos.ClientToAMTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.ClientToAMTokenIdentifierProto.newBuilder();
        if (id != null) {
            builder.setAppAttemptId(((ApplicationAttemptIdPBImpl)id).getProto());
        }
        if (client != null) {
            builder.setClientName(client);
        }
        this.proto = builder.build();
    }

    public ApplicationAttemptId getApplicationAttemptID() {
        if (!this.proto.hasAppAttemptId()) {
            return null;
        }
        return new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId());
    }

    public String getClientName() {
        return this.proto.getClientName();
    }

    public YarnSecurityTokenProtos.ClientToAMTokenIdentifierProto getProto() {
        return this.proto;
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.proto.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        this.proto = YarnSecurityTokenProtos.ClientToAMTokenIdentifierProto.parseFrom((DataInputStream)in);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public UserGroupInformation getUser() {
        String clientName = this.getClientName();
        if (clientName == null) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)clientName);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals(((ClientToAMTokenIdentifier)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }
}

