/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.store.FSStoreOpHandler;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonAppendableFSNodeLabelStore
extends FileSystemNodeLabelsStore {
    protected static final Logger LOG = LoggerFactory.getLogger(NonAppendableFSNodeLabelStore.class);

    @Override
    public void close() throws IOException {
    }

    @Override
    public void recover() throws YarnException, IOException {
        Path newMirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror.new");
        Path oldMirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror");
        this.loadFromMirror(newMirrorPath, oldMirrorPath);
        if (this.fs.exists(newMirrorPath)) {
            try {
                this.fs.delete(oldMirrorPath, false);
            }
            catch (IOException e) {
                LOG.debug("Exception while removing old mirror", e);
            }
            this.fs.rename(newMirrorPath, oldMirrorPath);
        }
        LOG.info("Node label store recover is completed");
    }

    @Override
    public void updateNodeToLabelsMappings(Map<NodeId, Set<String>> nodeToLabels) throws IOException {
        this.writeNewMirror();
    }

    @Override
    public void storeNewClusterNodeLabels(List<NodeLabel> labels) throws IOException {
        this.writeNewMirror();
    }

    @Override
    public void removeClusterNodeLabels(Collection<String> labels) throws IOException {
        this.writeNewMirror();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNewMirror() throws IOException {
        ReentrantReadWriteLock.ReadLock readLock = ((CommonNodeLabelsManager)((Object)this.manager)).readLock;
        readLock.lock();
        try {
            Path newTmpPath = new Path(this.fsWorkingPath, "nodelabel.mirror.new.tmp");
            try (FSDataOutputStream os = this.fs.create(newTmpPath, true);){
                FSNodeStoreLogOp op = FSStoreOpHandler.getMirrorOp(this.getStoreType());
                op.write(os, this.manager);
            }
            Path newPath = new Path(this.fsWorkingPath, "nodelabel.mirror.new");
            this.fs.delete(newPath, false);
            this.fs.rename(newTmpPath, newPath);
            Path mirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror");
            this.fs.delete(mirrorPath, false);
            this.fs.rename(newPath, mirrorPath);
        }
        finally {
            readLock.unlock();
        }
    }
}

