/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class YarnUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(YarnUncaughtExceptionHandler.class);
    private static final Marker FATAL = MarkerFactory.getMarker("FATAL");

    @Override
    public void uncaughtException(Thread t2, Throwable e) {
        if (ShutdownHookManager.get().isShutdownInProgress()) {
            LOG.error("Thread " + t2 + " threw an Throwable, but we are shutting down, so ignoring this", e);
        } else if (e instanceof Error) {
            try {
                LOG.error(FATAL, "Thread " + t2 + " threw an Error.  Shutting down now...", e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (e instanceof OutOfMemoryError) {
                try {
                    System.err.println("Halting due to Out Of Memory Error...");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ExitUtil.halt((int)-1);
            } else {
                ExitUtil.terminate((int)-1);
            }
        } else {
            LOG.error("Thread " + t2 + " threw an Exception.", e);
        }
    }
}

