/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemBasedConfigurationProvider
extends ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemBasedConfigurationProvider.class);
    private FileSystem fs;
    private Path configDir;

    @Override
    public synchronized InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws IOException, YarnException {
        Path filePath;
        if (name == null || name.isEmpty()) {
            throw new YarnException("Illegal argument! The parameter should not be null or empty");
        }
        if (YarnConfiguration.RM_CONFIGURATION_FILES.contains(name) || YarnConfiguration.NM_CONFIGURATION_FILES.contains(name)) {
            filePath = new Path(this.configDir, name);
            if (!this.fs.exists(filePath)) {
                LOG.info(filePath + " not found");
                return null;
            }
        } else {
            filePath = new Path(name);
            if (!this.fs.exists(filePath)) {
                LOG.info(filePath + " not found");
                return null;
            }
        }
        return this.fs.open(filePath);
    }

    @Override
    public synchronized void initInternal(Configuration bootstrapConf) throws Exception {
        Configuration conf = new Configuration(bootstrapConf);
        this.configDir = new Path(conf.get("yarn.resourcemanager.configuration.file-system-based-store", "/yarn/conf"));
        String scheme = this.configDir.toUri().getScheme();
        if (scheme == null) {
            scheme = FileSystem.getDefaultUri((Configuration)conf).getScheme();
        }
        if (scheme != null) {
            String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
            conf.setBoolean(disableCacheName, true);
        }
        this.fs = this.configDir.getFileSystem(conf);
        this.fs.mkdirs(this.configDir);
    }

    @Override
    public synchronized void closeInternal() throws Exception {
        this.fs.close();
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public Path getConfigDir() {
        return this.configDir;
    }
}

