/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.files;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskManifest
extends AbstractManifestData<TaskManifest> {
    public static final int VERSION = 1;
    public static final String TYPE = "org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest/1";
    private static final Logger LOG = LoggerFactory.getLogger(TaskManifest.class);
    private static final long serialVersionUID = 7090285511966046095L;
    @JsonProperty(value="type")
    private String type = "org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest/1";
    @JsonProperty(value="version")
    private int version = 1;
    @JsonProperty(value="jobId")
    private String jobId;
    @JsonProperty(value="jobAttemptNumber")
    private int jobAttemptNumber;
    @JsonProperty(value="taskID")
    private String taskID;
    @JsonProperty(value="taskAttemptID")
    private String taskAttemptID;
    @JsonProperty(value="taskAttemptDir")
    private String taskAttemptDir;
    @JsonProperty(value="files")
    private final List<FileEntry> filesToCommit = new ArrayList<FileEntry>();
    @JsonProperty(value="directories")
    private final List<DirEntry> destDirectories = new ArrayList<DirEntry>();
    private final Map<String, String> extraData = new HashMap<String, String>(0);
    @JsonProperty(value="iostatistics")
    private IOStatisticsSnapshot iostatistics = new IOStatisticsSnapshot();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public IOStatisticsSnapshot getIOStatistics() {
        return this.iostatistics;
    }

    public void setIOStatistics(@Nullable IOStatisticsSnapshot ioStatistics) {
        this.iostatistics = ioStatistics;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public int getJobAttemptNumber() {
        return this.jobAttemptNumber;
    }

    public void setJobAttemptNumber(int jobAttemptNumber) {
        this.jobAttemptNumber = jobAttemptNumber;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public String getTaskAttemptID() {
        return this.taskAttemptID;
    }

    public void setTaskAttemptID(String taskAttemptID) {
        this.taskAttemptID = taskAttemptID;
    }

    public String getTaskAttemptDir() {
        return this.taskAttemptDir;
    }

    public void setTaskAttemptDir(String taskAttemptDir) {
        this.taskAttemptDir = taskAttemptDir;
    }

    public void addFileToCommit(FileEntry entry) {
        this.filesToCommit.add(entry);
    }

    public List<FileEntry> getFilesToCommit() {
        return this.filesToCommit;
    }

    @JsonIgnore
    public long getTotalFileSize() {
        return this.filesToCommit.stream().mapToLong(FileEntry::getSize).sum();
    }

    public List<DirEntry> getDestDirectories() {
        return this.destDirectories;
    }

    public void addDirectory(DirEntry entry) {
        this.destDirectories.add(entry);
    }

    public Map<String, String> getExtraData() {
        return this.extraData;
    }

    @Override
    public byte[] toBytes() throws IOException {
        return TaskManifest.serializer().toBytes((Object)this);
    }

    public String toJson() throws IOException {
        return TaskManifest.serializer().toJson((Object)this);
    }

    @Override
    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        TaskManifest.serializer().save(fs, path, (Object)this, overwrite);
    }

    @Override
    public TaskManifest validate() throws IOException {
        TaskManifest.verify(TYPE.equals(this.type), "Wrong type: %s", this.type);
        TaskManifest.verify(this.version == 1, "Wrong version: %s", this.version);
        this.validateCollectionClass(this.extraData.keySet(), String.class);
        this.validateCollectionClass(this.extraData.values(), String.class);
        HashSet<String> destinations = new HashSet<String>(this.filesToCommit.size());
        this.validateCollectionClass(this.filesToCommit, FileEntry.class);
        for (FileEntry c : this.filesToCommit) {
            c.validate();
            TaskManifest.verify(!destinations.contains(c.getDest()), "Destination %s is written to by more than one pending commit", c.getDest());
            destinations.add(c.getDest());
        }
        return this;
    }

    @Override
    public JsonSerialization<TaskManifest> createSerializer() {
        return TaskManifest.serializer();
    }

    public static JsonSerialization<TaskManifest> serializer() {
        return new JsonSerialization(TaskManifest.class, false, true);
    }

    public static TaskManifest load(FileSystem fs, Path path) throws IOException {
        LOG.debug("Reading Manifest in file {}", (Object)path);
        return ((TaskManifest)TaskManifest.serializer().load(fs, path)).validate();
    }

    public static TaskManifest load(JsonSerialization<TaskManifest> serializer, FileSystem fs, Path path, FileStatus status) throws IOException {
        LOG.debug("Reading Manifest in file {}", (Object)path);
        return ((TaskManifest)serializer.load(fs, path, status)).validate();
    }
}

